/*
 * main.c
 *
 * The dispatcher for the pvf utilities. It looks up the name in
 * argv[0] and calls the appropiate subroutine.
 *
 */

#include "../include/voice.h"

char *pvftools_main_c = "$Id: main.c,v 1.3 1996/07/25 19:23:43 marc Exp $";

typedef int pvffunc _PROTO((int, char**));

extern pvffunc pvfamp, pvfcut, pvfecho, pvfsine,
               pvfreverse, pvfspeed, pvfmix, pvf_zyxel,
               pvftoau, autopvf, pvftobasic, basictopvf,
               pvftolin, lintopvf, pvftovoc, voctopvf,
               pvffft, rmdtosnd, sndtormd;

typedef struct {
     char *name;
     pvffunc *func;
} tab_t;

static tab_t tab[]={
     {"pvfamp", pvfamp},
     {"pvfcut", pvfcut},
     {"pvfecho", pvfecho},
     {"pvfreverse", pvfreverse},
     {"pvfspeed", pvfspeed},
     {"pvfmix", pvfmix},
     {"pvfsine", pvfsine},
     {"pvffft", pvffft},

     {"pvftozyxel2", pvf_zyxel},
     {"pvftozyxel3", pvf_zyxel},
     {"pvftozyxel4", pvf_zyxel},
     {"zyxeltopvf",  pvf_zyxel},

     {"sndtorock2", sndtormd},
     {"sndtorock3", sndtormd},
     {"sndtorock4", sndtormd},
     {"rmdtosnd", rmdtosnd},

     {"pvftoau", pvftoau},
     {"autopvf", autopvf},

     {"pvftobasic", pvftobasic},
     {"basictopvf", basictopvf},

     {"pvftolin", pvftolin},
     {"lintopvf", lintopvf},

     {"pvftovoc", pvftovoc},
     {"voctopvf", voctopvf},

     {0, 0}
};

char *command;   /* used in error messages, includes path name */

int
main _P2((argc, argv), int argc, char **argv) {
     int i=0;
     char *s, *cmd;

     command = cmd = argv[0];

     if( (s=strrchr(cmd, '/')) !=0 ) cmd=s+1;

     while( tab[i].name != 0 ) {
          if( strcmp(cmd, tab[i].name) ==0 ) {
               return tab[i].func(argc, argv);
          }
          i++;
     }
     ERRORRETURN("unknown command");
     return 1;
}
