

# Usage: restore [-<options>] [user]
# restore v0.4 - restore fileareas using tar
# last updated: 27/o7 1995 audun

# defaults
$defsource = "/iu/nexus/backup/";

# options and subprocedures
%optionlist =
(
 '-f', 'file_option',
 '-d', 'dirs_option',
 '--help', 'help_option',
);

# misc
$syntax = "syntax: restore [-<options>] [keyword]";
$options = "options: [-f file] [--help]";

# env
$whoami = $ENV{USER};
$home = $ENV{HOME};


&parse;
&restore;


sub parse
{
    print "restore v0.4 - restore userfiles\n";
    # check for arguments
    if ($#ARGV >= 0)
    {
	undef $users;
	undef $sourcer;
	# parse all supplied arguments
	for ($arg = 0; $arg <= $#ARGV; $arg++)
	{
	    &users if (substr($ARGV[$arg], 0, 1) ne "-");
	    &options if (substr($ARGV[$arg], 0, 1) eq "-");
	}
    }	

}


sub restore
{
    # restore the shit
    # set restore dir to default home if no user specified
    if (!$users)
    {
	$users = $home;
	# snip leading "/", if any
	$users = substr($users, 1, length($users)) if (substr($users, 0, 1) eq "/");
    }
    # make restore dir in user area and add datestamp
    ($sec, $min, $hour, $mday, $mon, $year) = localtime(time);
    $mon++;
    $today = "$mday.$mon.$year";

    # if no source specified, use all default backupfiles available
    if (!$source)
    {
	&scanfiles;
	foreach $file (@backupfiles)
	{
	    $source .= $file;
	}
    }

    $destination = "$home/restore.$today";
    system "mkdir $destination";

    # extract backupfile
    @source = split(" ", $source);
    foreach $source (@source)
    {
	undef $file;
	# expect current dir if no leading "/"
	$file = "../$source" if (substr($source, 0, 1) ne "/");

	# userdirs defined
	if ($dir{$source})
	{
	    system "cd $destination; tar zxpf $file $dir{$source} >/dev/null" if ($file);
	    system "cd $destination; tar zxpf $source $dir{$source} >/dev/null" if (!$file);
	}
	else
	{
	    $source = $file if ($file);
	    system "cd $destination; tar zxpf $source $users";
	}
    }
}


sub scanfiles
{
    opendir(SDIR, $defsource);
    
    # reading the directory, scanning for yer backup
    if ($whoami eq "root")
    {
	@backupfiles = grep(/^backup/, readdir(SDIR));
    }
    else
    {
	@backupfiles = grep(/$whoami/, readdir(SDIR));
    }
    foreach $file (@backupfiles)
    {
	$bfile = $defsource;
	$bfile .= $file;
	$file = $bfile;
    }
    closedir(SDIR);
}


sub users
{
    # add keyword (or user) directory/file/pattern
    # check for absolute path
    if (substr($ARGV[$arg], 0, 1) eq "/")
    {
	# snip leading "/"
	$users .= substr($ARGV[$arg], 1, length($ARGV[$arg]));
    }
    else
    {
	print "please be patient, this may take a while...\n";
	# no absolute path, scan for dir/filename
	# if no source file specified, scan all backup files
	&scanfiles if (!$source);
	undef $source;
	foreach $file (@backupfiles)
	{
	    open(IN, "/local/gnu/bin/tar ztf $file | grep $ARGV[$arg] |") || die "fatal: can't open $file\n";
	    while(<IN>)
	    {
		if ($_)
		{
		    chop;
		    print "found: $ARGV[$arg], in file $file\n";
		    # remove trailing "/" if any (or else tar won't
		    # extract contents of directory)
		    if (substr($_, -1, 1) eq "/")
		    {
			chop;
			$found_dir = 1;
		    }
		    # this backupfile should be used
		    $_ .= " ";
		    $dir{$file} .= $_;
		    $filename = $file;
		    $filename .= " ";
		    $source .= $filename;
		    # no need to go on if we found a directory
		    last if ($found_dir);
		}
	    }
	}
    }
}


sub options
{
    # check supplied options and sub to command if defined
    die "option not defined!\n$options\n" if (!$optionlist{$ARGV[$arg]});
    $sub = $optionlist{$ARGV[$arg]};
    &$sub;
}


sub file_option
{
    # set source filename
    $arg++;

    # check for syntax error
    die "bad filename!!\n$options\n" if (substr($ARGV[$arg], 0, 1) eq "-") || ($ARGV[$arg] eq "");

    $source .= $ARGV[$arg];
    $source .= " ";
    @backupfiles = split(" ", $source);
}


sub help_option
{
    print "Usage: restore [-<options>] [keyword]\n";
    print "restore v0.4 - restore fileareas using tar\n";
    print "last updated: 27/o7 1995 audun\n";
    print "options:      -f backupfile source\n";
    print "              --help display help\n";
    print "keyword:      directory, file, pattern\n";
    print "example:      restore /iu/nexus/u2/robocop/jpegs\n";
    exit;
}

