/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/

# ifndef LLERROR_H
# define LLERROR_H

extern /*@falseexit@*/ void check (bool x);
# define check(x) \
  do { bool m_res = x; \
       if (!m_res) { \
		       llmsg (message ("%q:%d,1: at source point", \
				       cstring_makeLiteral (__FILE__), __LINE__)); \
     		       llbuglit ("check failed: " #x); \
		       } \
      } while (FALSE)

extern /*@falseexit@*/ void llassert (/*@sef@*/ bool test);
# define llassert(tst) \
    do { if (!(tst)) { \
	   llmsg (message ("%q:%d,1: at source point", \
			   cstring_makeLiteral (__FILE__), __LINE__)); \
	   llbuglit ("llassert failed: " #tst); \
       }} while (FALSE)

extern /*@falseexit@*/ void llassertfatal (/*@sef@*/ bool test);
# define llassertfatal(tst) \
    do { if (!(tst)) \
	   llfatalbug (message("%q:%d: fatal llassert failed: " #tst, \
			       cstring_makeLiteral (__FILE__), __LINE__)); \
       } while (FALSE)

/*
** llassertprint and llassertprintret are in lclintMacros.nf
*/

extern /*@exits@*/ void lclplainfatalerror (/*@only@*/ cstring msg) /*@modifies stderr@*/ ;
extern void llmsg (/*@only@*/ cstring s) /*@modifies stderr@*/ ;
extern void llmsgplain (/*@only@*/ cstring s) /*@modifies stderr@*/ ;
extern void llhint (/*@only@*/ cstring s) 
   /*@globals currentloc, stderr;@*/ 
   /*@modifies stderr@*/ ;
extern /*@exits@*/ void llfatalbug (/*@only@*/ cstring s) 
   /*@globals currentloc, stderr@*/
   /*@modifies stderr@*/ ;
extern void llgloberror (/*@only@*/ cstring s) /*@modifies stderr@*/ ;
extern bool llgenerror (flagcode o, /*@only@*/ cstring s, fileloc fl) /*@modifies stderr@*/ ;
extern bool llgenhinterror (flagcode o, /*@only@*/ cstring s, /*@only@*/ cstring hint, 
			    fileloc fl) /*@modifies stderr@*/ ;
extern void llerror (flagcode o, /*@only@*/ cstring s) 
   /*@globals stderr, currentloc@*/ 
   /*@modifies stderr@*/ ;
extern void llgenmsg (/*@only@*/ cstring s, fileloc fl) /*@modifies stderr@*/ ;
extern /*@exits@*/ void llfatalerror (/*@only@*/ cstring s) /*@modifies stderr@*/ ;
extern /*@exits@*/ void llfatalerrorLoc (/*@only@*/ cstring s) 
   /*@globals stderr, currentloc@*/ 
   /*@modifies stderr@*/ ;
extern void llparseerror (/*@only@*/ cstring s) 
   /*@globals stderr, currentloc@*/ 
   /*@modifies stderr@*/ ;
extern /*@exits@*/ void lclfatalbug (/*@temp@*/ char *sg) /*@modifies stderr@*/ ;
extern int lclNumberErrors (void) /*@*/ ;

extern void flagWarning (/*@observer@*/ cstring s) /*@modifies stderr@*/ ;

extern /*@exits@*/ void llbug (/*@only@*/ cstring s) 
   /*@globals stderr, currentloc@*/
   /*@modifies *stderr@*/ ; 
   /* doesn't really exit, but don't mind errors if it doesn't */

extern void llcontbug (/*@only@*/ cstring s) /*@modifies *stderr@*/ ; 
       /* doesn't really exit, but don't mind errors if it doesn't */
# define llcontbug(s)  (llbug (s))

extern void cleanupMessages (void) 
   /*@globals stderr, currentloc;@*/
   /*@modifies stderr, internalState@*/ ;

extern bool lclHadNewError (void) /*@modifies internalState@*/ ;

/*
** Report error iff f1 and f2 are set.
*/

extern bool 
optgenerror2 (flagcode f1, flagcode f2, /*@only@*/ cstring s, fileloc loc)
  /*@modifies *stderr, internalState@*/ ;

/*
** Report error if f1 is set and f2 is not set.
*/

extern bool 
optgenerror2n (flagcode f1, flagcode f2, /*@only@*/ cstring s, fileloc loc)
  /*@modifies *stderr, internalState@*/ ;

extern bool lloptgenerror (flagcode o, /*@only@*/ cstring s, fileloc loc)
  /*@modifies *stderr, internalState@*/ ;

extern bool llnoptgenerror (flagcode o, /*@only@*/ cstring s, fileloc loc)
  /*@modifies *stderr, internalState@*/ ;

extern bool llgentypeerror (ctype t1, exprNode e1,
			    ctype t2, exprNode e2,
			    /*@only@*/ cstring s,
			    fileloc loc)
  /*@modifies *stderr, internalState@*/ ;

extern bool gentypeerror (/*@sef@*/ ctype t1, 
			  /*@sef@*/ exprNode e1,
			  /*@sef@*/ ctype t2, 
			  /*@sef@*/ exprNode e2,
			  /*@sef@*/ /*@only@*/ cstring s,
			  /*@sef@*/ fileloc loc)
  /*@modifies *stderr, internalState@*/ ;

/*@-branchstate@*/ /* sef only s is freed on one branch */
#define gentypeerror(t1, e1, t2, e2, s, loc)      \
   (context_suppressFlagMsg (FLG_TYPE,loc) \
    ? (flagcode_recordSuppressed (FLG_TYPE), FALSE) \
    : llgentypeerror (t1, e1, t2, e2, s, loc))
/*@=branchstate@*/

/*
** These are macros to save evaluating s (which may be some expensive
** message generation function).
*/

extern bool 
  optgenerror (/*@sef@*/ flagcode o, /*@sef@*/ /*@only@*/ cstring s,
	       /*@sef@*/ fileloc loc)
  /*@modifies *stderr, internalState@*/ ;

/*@-branchstate@*/ /* sef only s is freed on one branch */
#define optgenerror(o,s,loc)      \
   (context_suppressFlagMsg(o,loc) ? (flagcode_recordSuppressed(o), FALSE) \
                                     : lloptgenerror (o, s, loc))
/*@=branchstate@*/

extern void 
  voptgenerror (/*@sef@*/ flagcode o, /*@sef@*/ /*@only@*/ cstring s, 
		/*@sef@*/ fileloc loc)
  /*@modifies *stderr, internalState@*/ ;
#define voptgenerror(o, s, loc)   ((void) optgenerror(o,s,loc))

extern void 
  voptgenerror2 (/*@sef@*/ flagcode f1, /*@sef@*/ flagcode f2, 
		 /*@sef@*/ /*@only@*/ cstring s, /*@sef@*/ fileloc loc);
#define voptgenerror2(f1, f2, s, loc)   ((void) optgenerror2 (f1, f2, s, loc))

extern void 
  voptgenerror2n (/*@sef@*/ flagcode f1, /*@sef@*/ flagcode f2, 
		  /*@sef@*/ /*@only@*/ cstring s, /*@sef@*/ fileloc loc);
#define voptgenerror2n(f1, f2, s, loc)   ((void) optgenerror2n (f1, f2, s, loc))

extern void noptgenerror (/*@sef@*/ flagcode code, 
			  /*@sef@*/ /*@only@*/ cstring s,
			  /*@sef@*/ fileloc loc);
/*@-branchstate@*/ /* sef only s is freed on one branch */
#define noptgenerror(o,s,loc)     \
   (context_suppressNotFlagMsg (o, loc) \
    ? (flagcode_recordSuppressed(o), FALSE) \
    : llnoptgenerror (o, s, loc))
/*@=branchstate@*/

extern void 
  vnoptgenerror (/*@sef@*/ flagcode code, /*@sef@*/ /*@only@*/ cstring msg,
		 /*@sef@*/ fileloc loc);
# define vnoptgenerror(o, s, loc) ((void) noptgenerror(o, s, loc))

extern void 
  vgenhinterror (flagcode code, /*@only@*/ cstring mst,
		 /*@only@*/ cstring hint, /*@sef@*/ fileloc loc);
# define vgenhinterror(o, s, h, loc) \
    ((void) llgenhinterror(o, s, h, loc))

extern 
void llforceerror (flagcode code, /*@only@*/ cstring s, fileloc fl) /*@modifies stderr@*/ ; 

extern /*@exits@*/ void lclfatalerror (ltoken t, /*@only@*/ cstring msg);
extern void lclerror (ltoken t, /*@only@*/ cstring msg);

extern void lclbug (/*@only@*/ cstring s);
extern void lclplainerror (/*@only@*/ cstring msg);
extern bool lclHadError (void);
extern void lclRedeclarationError (ltoken id);
extern void llerrorlit (flagcode o, char *s);
extern void llgenindentmsg (/*@only@*/ cstring s, fileloc fl) /*@modifies stderr@*/ ;

extern /*@exits@*/ void llbugexitlit (char *s);
extern /*@exits@*/ void llbuglit (char *s);
extern void llcontbuglit (char *s);

# define llerror(o, s)      ((void) llgenerror (o, s, currentloc))
# define llerrorlit(o, s)   ((void) llerror (o, cstring_makeLiteral (s)))
# define llbuglit(s)        (llbug (cstring_makeLiteral (s)))
# define llcontbuglit(s)    (llbug (cstring_makeLiteral (s)))
# define llbugexitlit(s)    (llbug (cstring_makeLiteral (s)))

extern void checkParseError (void);

extern void llmsglit (char *s);
# define llmsglit(s)        (llmsg (cstring_makeLiteral (s)))

extern void ppllerror (/*@only@*/ cstring s);
extern void ppllmsg (/*@only@*/ cstring s);

extern void llgenindentmsgnoloc (/*@only@*/ cstring s);

# else
# error "Multiple include"
# endif

