/*
 * ImageButtonGroup.java - radio group of image buttons
 *
 * crated: kwagen, 19970915
 *
 * changed: kwagen, 19970915
 * changed: mpichler, 19970916
 *
 * $Id: ImageButtonGroup.java,v 1.1 1997/09/17 08:20:02 mpichler Exp $
 */


package iicm.widgets;

import java.util.Vector;


/**
 * ImageButtonGroup.java - radio group of image buttons
 */

public class ImageButtonGroup
{
  private Vector buttons_ = new Vector ();
  private int current = -1;

  void addButton (ImageButton imgb)
  {
    if (buttons_.contains (imgb))
      return;
    buttons_.addElement (imgb);
    if (imgb.getState ())
    {
      if (current > -1)
        ((ImageButton) buttons_.elementAt (current)).setState (false);
      current = buttons_.size () - 1;
    }
    if (current < 0)
    {
      current = 0;
      ((ImageButton) buttons_.elementAt (current)).setState (true);
    }
  }

  public void setCurrent (ImageButton imgb)
  {
    ((ImageButton) buttons_.elementAt (current)).setState (false);
    current = buttons_.indexOf (imgb);
  }

  public ImageButton getCurrent ()
  {
    return (ImageButton) buttons_.elementAt (current);
  }
} // ImageButtonGroup
