.TH chaintest 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
chaintest - a three-species food chain model 
.SH CALLING SEQUENCE
.nf
chaintest([f_l,b1,odem,xdim,npts])
[xdot]=chain(t,x)
[z1]=ch_f1(u)
[z2]=ch_f2(u)
.fi
.SH PARAMETERS
.TP
f_l
: the name of the macro which code the three-species food chain model (default
value \fV chain\fR).
.TP
odem,xdim,npts
: are optional arguments. Their meaning and syntax can be found in the \fVportr3d\fR  help
.SH DESCRIPTION
A call to the function \fVchaintest()\fR will interactively 
display a phase portrait of  a three-species food chain model given by:
.nf
	ff1= f1(x(1))
	ff2= f2(x(2))

	xdot1= x(1)*(1-x(1)) - ff1*x(2)
	xdot2= ff1*x(2) -  ff2*x(3) - 0.4*x(2)
	xdot3= ff2*x(3) - 0.01*x(3)
.fi
and 
.nf
	f1(u)=5*u/(1+b1*u)
	f2(u)z2=0.1*u/(1+2*u)
.fi
The default value for \fVb1\fR is 3.0.
.LP
The Scilab macros \fVchain(t,x)\fR,\fVf1(u),f2(u)\fR code the dynamical system
.SH SEE ALSO
portr3d, ode 



