.TH spzeros 1 "January 1995" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
spzeros -  sparse zero matrix
.SH SYNTAX
sp=spzeros(nrows,ncols)

sp=spzeros(A)
.SH PARAMETERS
.TP 8
nrows
: integer (number of rows)
.TP
ncols
: integer (number os columns)
.TP
A
: sparse matrix
.TP
sp
: sparse zero matrix
.SH DESCRIPTION
\fVsp=spzeros(nrows,ncols,fill)\fR returns a sparse zero matrix \fVsp\fR 
with \fVnrows\fR rows, \fVncols\fR columns. 
(Equivalent to \fVsparse([],[],[nrow,ncols])\fR)
.LP
\fVsp=spzeros(A)\fR returns a sparse zero matrix with same
dimensions as \fVA\fR. If \fV[m,n]=size(A)\fR, \fVspzeros(m,n)\fR and
\fVspzeros(A)\fR are equivalent. In particular \fVspzeros(3)\fR is not
equivalent to \fVspzeros(3,3)\fR.
.SH EXAMPLE
.nf
sum(spzeros(1000,1000))
.fi
.SH SEE ALSO
sparse, full, eye, speye, spones



                        
