/* This is an Scheme48/C interface file, 
** automatically generated by cig.
*/

#include <stdio.h>
#include <stdlib.h> /* For malloc. */
#include "libcig.h"

#include <sys/types.h>
#include <sys/socket.h>

/* Make sure foreign-function stubs interface to the C funs correctly: */
#include "network1.h"

extern int errno;
extern int h_errno;

#define errno_on_zero_or_false(x) ((x) ? SCHFALSE : ENTER_FIXNUM(errno))
#define errno_or_false(x) (((x) == -1) ? ENTER_FIXNUM(errno) : SCHFALSE)
#define False_on_zero(x) ((x) ? ENTER_FIXNUM(x) : SCHFALSE)
scheme_value df_socket(long nargs, scheme_value *args)
{
    extern int socket(int , int , int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(4, nargs, "socket");
    r1 = socket(EXTRACT_FIXNUM(args[3]), EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]));
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_scheme_bind(long nargs, scheme_value *args)
{
    extern int scheme_bind(int , int , scheme_value );
    scheme_value ret1;
    int r1;

    cig_check_nargs(3, nargs, "scheme_bind");
    r1 = scheme_bind(EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]), args[0]);
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_scheme_connect(long nargs, scheme_value *args)
{
    extern int scheme_connect(int , int , scheme_value );
    scheme_value ret1;
    int r1;

    cig_check_nargs(3, nargs, "scheme_connect");
    r1 = scheme_connect(EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]), args[0]);
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_listen(long nargs, scheme_value *args)
{
    extern int listen(int , int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(2, nargs, "listen");
    r1 = listen(EXTRACT_FIXNUM(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_scheme_accept(long nargs, scheme_value *args)
{
    extern int scheme_accept(int , int , scheme_value );
    scheme_value ret1;
    int r1;

    cig_check_nargs(4, nargs, "scheme_accept");
    r1 = scheme_accept(EXTRACT_FIXNUM(args[3]), EXTRACT_FIXNUM(args[2]), args[1]);
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_scheme_peer_name(long nargs, scheme_value *args)
{
    extern int scheme_peer_name(int , int , scheme_value );
    scheme_value ret1;
    int r1;

    cig_check_nargs(3, nargs, "scheme_peer_name");
    r1 = scheme_peer_name(EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]), args[0]);
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_scheme_socket_name(long nargs, scheme_value *args)
{
    extern int scheme_socket_name(int , int , scheme_value );
    scheme_value ret1;
    int r1;

    cig_check_nargs(3, nargs, "scheme_socket_name");
    r1 = scheme_socket_name(EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]), args[0]);
    ret1 = False_on_zero(r1);
    return ret1;
    }

scheme_value df_shutdown(long nargs, scheme_value *args)
{
    extern int shutdown(int , int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(2, nargs, "shutdown");
    r1 = shutdown(EXTRACT_FIXNUM(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_scheme_socket_pair(long nargs, scheme_value *args)
{
    extern int scheme_socket_pair(int , int *, int *);
    scheme_value ret1;
    int r1;
    int r2;
    int r3;

    cig_check_nargs(2, nargs, "scheme_socket_pair");
    r1 = scheme_socket_pair(EXTRACT_FIXNUM(args[1]), &r2, &r3);
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r2);
    VECTOR_REF(*args,1) = ENTER_FIXNUM(r3);
    return ret1;
    }

scheme_value df_recv_substring(long nargs, scheme_value *args)
{
    extern int recv_substring(int , int , scheme_value , int , int , scheme_value );
    scheme_value ret1;
    int r1;

    cig_check_nargs(7, nargs, "recv_substring");
    r1 = recv_substring(EXTRACT_FIXNUM(args[6]), EXTRACT_FIXNUM(args[5]), args[4], EXTRACT_FIXNUM(args[3]), EXTRACT_FIXNUM(args[2]), args[1]);
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_send_substring(long nargs, scheme_value *args)
{
    extern int send_substring(int , int , scheme_value , int , int , int , scheme_value );
    scheme_value ret1;
    int r1;

    cig_check_nargs(8, nargs, "send_substring");
    r1 = send_substring(EXTRACT_FIXNUM(args[7]), EXTRACT_FIXNUM(args[6]), args[5], EXTRACT_FIXNUM(args[4]), EXTRACT_FIXNUM(args[3]), EXTRACT_FIXNUM(args[2]), args[1]);
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_scheme_getsockopt(long nargs, scheme_value *args)
{
    extern int scheme_getsockopt(int , int , int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(4, nargs, "scheme_getsockopt");
    r1 = scheme_getsockopt(EXTRACT_FIXNUM(args[3]), EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]));
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_scheme_getsockopt_linger(long nargs, scheme_value *args)
{
    extern int scheme_getsockopt_linger(int , int , int , int *);
    scheme_value ret1;
    int r1;
    int r2;

    cig_check_nargs(4, nargs, "scheme_getsockopt_linger");
    r1 = scheme_getsockopt_linger(EXTRACT_FIXNUM(args[3]), EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]), &r2);
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r1);
    VECTOR_REF(*args,1) = ENTER_FIXNUM(r2);
    return ret1;
    }

scheme_value df_scheme_getsockopt_timeout(long nargs, scheme_value *args)
{
    extern int scheme_getsockopt_timeout(int , int , int , int *);
    scheme_value ret1;
    int r1;
    int r2;

    cig_check_nargs(4, nargs, "scheme_getsockopt_timeout");
    r1 = scheme_getsockopt_timeout(EXTRACT_FIXNUM(args[3]), EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]), &r2);
    ret1 = errno_or_false(r1);
    VECTOR_REF(*args,0) = ENTER_FIXNUM(r1);
    VECTOR_REF(*args,1) = ENTER_FIXNUM(r2);
    return ret1;
    }

scheme_value df_scheme_setsockopt(long nargs, scheme_value *args)
{
    extern int scheme_setsockopt(int , int , int , int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(4, nargs, "scheme_setsockopt");
    r1 = scheme_setsockopt(EXTRACT_FIXNUM(args[3]), EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_scheme_setsockopt_linger(long nargs, scheme_value *args)
{
    extern int scheme_setsockopt_linger(int , int , int , int , int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(5, nargs, "scheme_setsockopt_linger");
    r1 = scheme_setsockopt_linger(EXTRACT_FIXNUM(args[4]), EXTRACT_FIXNUM(args[3]), EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_scheme_setsockopt_timeout(long nargs, scheme_value *args)
{
    extern int scheme_setsockopt_timeout(int , int , int , int , int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(5, nargs, "scheme_setsockopt_timeout");
    r1 = scheme_setsockopt_timeout(EXTRACT_FIXNUM(args[4]), EXTRACT_FIXNUM(args[3]), EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = errno_or_false(r1);
    return ret1;
    }

scheme_value df_scheme_host_address2host_info(long nargs, scheme_value *args)
{
    extern int scheme_host_address2host_info(scheme_value , char **, char** *, char** *);
    scheme_value ret1;
    int r1;
    char *r2;
    char** r3;
    char** r4;

    cig_check_nargs(2, nargs, "scheme_host_address2host_info");
    r1 = scheme_host_address2host_info(args[1], &r2, &r3, &r4);
    ret1 = False_on_zero(r1);
    {AlienVal(CAR(VECTOR_REF(*args,0))) = (long) r2; CDR(VECTOR_REF(*args,0)) = strlen_or_false(r2);}
    AlienVal(VECTOR_REF(*args,1)) = (long) r3;
    AlienVal(VECTOR_REF(*args,2)) = (long) r4;
    return ret1;
    }

scheme_value df_scheme_host_name2host_info(long nargs, scheme_value *args)
{
    extern int scheme_host_name2host_info(const char *, char **, char** *, char** *);
    scheme_value ret1;
    int r1;
    char *r2;
    char** r3;
    char** r4;

    cig_check_nargs(2, nargs, "scheme_host_name2host_info");
    r1 = scheme_host_name2host_info(cig_string_body(args[1]), &r2, &r3, &r4);
    ret1 = False_on_zero(r1);
    {AlienVal(CAR(VECTOR_REF(*args,0))) = (long) r2; CDR(VECTOR_REF(*args,0)) = strlen_or_false(r2);}
    AlienVal(VECTOR_REF(*args,1)) = (long) r3;
    AlienVal(VECTOR_REF(*args,2)) = (long) r4;
    return ret1;
    }

scheme_value df_scheme_net_address2net_info(long nargs, scheme_value *args)
{
    extern int scheme_net_address2net_info(scheme_value , scheme_value , char **, char** *);
    scheme_value ret1;
    int r1;
    char *r2;
    char** r3;

    cig_check_nargs(3, nargs, "scheme_net_address2net_info");
    r1 = scheme_net_address2net_info(args[2], args[1], &r2, &r3);
    ret1 = False_on_zero(r1);
    {AlienVal(CAR(VECTOR_REF(*args,0))) = (long) r2; CDR(VECTOR_REF(*args,0)) = strlen_or_false(r2);}
    AlienVal(VECTOR_REF(*args,1)) = (long) r3;
    return ret1;
    }

scheme_value df_scheme_net_name2net_info(long nargs, scheme_value *args)
{
    extern int scheme_net_name2net_info(const char *, scheme_value , char **, char** *);
    scheme_value ret1;
    int r1;
    char *r2;
    char** r3;

    cig_check_nargs(3, nargs, "scheme_net_name2net_info");
    r1 = scheme_net_name2net_info(cig_string_body(args[2]), args[1], &r2, &r3);
    ret1 = False_on_zero(r1);
    {AlienVal(CAR(VECTOR_REF(*args,0))) = (long) r2; CDR(VECTOR_REF(*args,0)) = strlen_or_false(r2);}
    AlienVal(VECTOR_REF(*args,1)) = (long) r3;
    return ret1;
    }

scheme_value df_scheme_serv_port2serv_info(long nargs, scheme_value *args)
{
    extern int scheme_serv_port2serv_info(int , const char *, char **, char** *, int *, char **);
    scheme_value ret1;
    int r1;
    char *r2;
    char** r3;
    int r4;
    char *r5;

    cig_check_nargs(3, nargs, "scheme_serv_port2serv_info");
    r1 = scheme_serv_port2serv_info(EXTRACT_FIXNUM(args[2]), cig_string_body(args[1]), &r2, &r3, &r4, &r5);
    ret1 = False_on_zero(r1);
    {AlienVal(CAR(VECTOR_REF(*args,0))) = (long) r2; CDR(VECTOR_REF(*args,0)) = strlen_or_false(r2);}
    AlienVal(VECTOR_REF(*args,1)) = (long) r3;
    VECTOR_REF(*args,2) = ENTER_FIXNUM(r4);
    {AlienVal(CAR(VECTOR_REF(*args,3))) = (long) r5; CDR(VECTOR_REF(*args,3)) = strlen_or_false(r5);}
    return ret1;
    }

scheme_value df_scheme_serv_name2serv_info(long nargs, scheme_value *args)
{
    extern int scheme_serv_name2serv_info(const char *, const char *, char **, char** *, int *, char **);
    scheme_value ret1;
    int r1;
    char *r2;
    char** r3;
    int r4;
    char *r5;

    cig_check_nargs(3, nargs, "scheme_serv_name2serv_info");
    r1 = scheme_serv_name2serv_info(cig_string_body(args[2]), cig_string_body(args[1]), &r2, &r3, &r4, &r5);
    ret1 = False_on_zero(r1);
    {AlienVal(CAR(VECTOR_REF(*args,0))) = (long) r2; CDR(VECTOR_REF(*args,0)) = strlen_or_false(r2);}
    AlienVal(VECTOR_REF(*args,1)) = (long) r3;
    VECTOR_REF(*args,2) = ENTER_FIXNUM(r4);
    {AlienVal(CAR(VECTOR_REF(*args,3))) = (long) r5; CDR(VECTOR_REF(*args,3)) = strlen_or_false(r5);}
    return ret1;
    }

scheme_value df_scheme_proto_num2proto_info(long nargs, scheme_value *args)
{
    extern int scheme_proto_num2proto_info(int , char **, char** *, int *);
    scheme_value ret1;
    int r1;
    char *r2;
    char** r3;
    int r4;

    cig_check_nargs(2, nargs, "scheme_proto_num2proto_info");
    r1 = scheme_proto_num2proto_info(EXTRACT_FIXNUM(args[1]), &r2, &r3, &r4);
    ret1 = False_on_zero(r1);
    {AlienVal(CAR(VECTOR_REF(*args,0))) = (long) r2; CDR(VECTOR_REF(*args,0)) = strlen_or_false(r2);}
    AlienVal(VECTOR_REF(*args,1)) = (long) r3;
    VECTOR_REF(*args,2) = ENTER_FIXNUM(r4);
    return ret1;
    }

scheme_value df_scheme_proto_name2proto_info(long nargs, scheme_value *args)
{
    extern int scheme_proto_name2proto_info(const char *, char **, char** *, int *);
    scheme_value ret1;
    int r1;
    char *r2;
    char** r3;
    int r4;

    cig_check_nargs(2, nargs, "scheme_proto_name2proto_info");
    r1 = scheme_proto_name2proto_info(cig_string_body(args[1]), &r2, &r3, &r4);
    ret1 = False_on_zero(r1);
    {AlienVal(CAR(VECTOR_REF(*args,0))) = (long) r2; CDR(VECTOR_REF(*args,0)) = strlen_or_false(r2);}
    AlienVal(VECTOR_REF(*args,1)) = (long) r3;
    VECTOR_REF(*args,2) = ENTER_FIXNUM(r4);
    return ret1;
    }

scheme_value df_veclen(long nargs, scheme_value *args)
{
    extern scheme_value veclen(const long * );
    scheme_value ret1;
    scheme_value r1;

    cig_check_nargs(1, nargs, "veclen");
    r1 = veclen((const long * )AlienVal(args[0]));
    ret1 = r1;
    return ret1;
    }

scheme_value df_set_longvec_carriers(long nargs, scheme_value *args)
{
    extern void set_longvec_carriers(scheme_value , long const * const * );

    cig_check_nargs(2, nargs, "set_longvec_carriers");
    set_longvec_carriers(args[1], (long const * const * )AlienVal(args[0]));
    return SCHFALSE;
    }

