/***************************************************************************

  Xmame 3Dfx console-mode driver

  Written based on Phillip Ezolt's svgalib driver by Mike Oliphant -

    oliphant@ling.ed.ac.uk

    http://www.ling.ed.ac.uk/~oliphant/glmame

***************************************************************************/
#define __SVGAFX_C

#include <vga.h>
#include <vgagl.h>
#include <vgakeyboard.h>
#include <vgamouse.h>
#include <signal.h>
#include <linux/kd.h>
#include <sys/ioctl.h>
#include <glide.h>
#include "xmame.h"
#include "devices.h"

extern int  InitVScreen(void);
extern void CloseVScreen(void);
extern void InitGlide(void);
extern int  SetResolution(const char*,int*,int*);

int fx=1;
int winwidth=640;
int winheight=480;

static int console_fd       = -1;
static int leds             =  0;
static int use_signals      =  0;
static struct sigaction sig1handler;
static struct sigaction oldsig1handler;
static struct sigaction sig2handler;
static struct sigaction oldsig2handler;

int sysdep_init(void)
{
   InitGlide();
   vga_init();
   return OSD_OK;
}

void sysdep_close(void)
{
}

void Sig1HandlerFunction(int n)
{
   grSstControl(GR_CONTROL_DEACTIVATE);
   if (use_signals)   
   {
      (*(oldsig1handler.sa_handler))(n);
      sigaction(SIGUSR1, &sig1handler, NULL);
   }
}

void Sig2HandlerFunction(int n)
{
   keyboard_clearstate();
   if (use_signals)
   {
      (*(oldsig2handler.sa_handler))(n);
      sigaction(SIGUSR2, &sig2handler, NULL);
   }
   grSstControl(GR_CONTROL_ACTIVATE);
   if (console_fd >= 0)
      ioctl(console_fd, KDSETLED, leds);
}

/* This name doesn't really cover this function, since it also sets up mouse
   and keyboard. This is done over here, since on most display targets the
   mouse and keyboard can't be setup before the display has. */
int sysdep_create_display(void)
{
  if(video_16bit)
  {
     fprintf(stderr_file, "%s doesn't support 16bpp video modes\n", title);
     return OSD_NOT_OK;
  }

  printf("Using FXmame v0.5 driver for xmame, written by Mike Oliphant\n");

  if(SetResolution(geometry,&winwidth,&winheight)!=OSD_OK)
    return OSD_NOT_OK;
  printf("Screen Resolution set to %dx%d\n", winwidth, winheight);
  
  if (InitVScreen() != OSD_OK)
     return OSD_NOT_OK;
  
   if (vga_setmode(-1)<0x1410)
   {  
      use_signals = 1;
      memset(&sig1handler, 0, sizeof(struct sigaction));
      memset(&sig2handler, 0, sizeof(struct sigaction));
      sig1handler.sa_handler=Sig1HandlerFunction;
      sig2handler.sa_handler=Sig2HandlerFunction;
      sigaction(SIGUSR1, &sig1handler, &oldsig1handler);
      sigaction(SIGUSR2, &sig2handler, &oldsig2handler);
      fprintf(stderr_file, "SvgaFX: Info: Using signals for console switches\n");
      /* grr on older svgalibs vga_setmode(-1) messes up the display */
      vga_setmode(TEXT);
   }
   else
   {
      vga_runinbackground(VGA_GOTOBACK, sig1handler);
      vga_runinbackground(VGA_COMEFROMBACK, sig2handler);
      fprintf(stderr_file, "SvgaFX: Info: Using vga_runinbackground for console switches\n");
   }

   /* init the keyboard */
   if ((console_fd = keyboard_init_return_fd()) < 0)
   {
      fprintf(stderr_file, "Svgalib: Error: Couldn't open keyboard\n");
      return OSD_NOT_OK;
   }
   ioctl(console_fd, KDSETLED, leds);
   local_key=keyboard_getstate();

   /* 
      not sure if this is the best site but mouse init routine must be 
      called after video initialization...
   */   
   if(use_mouse)
   {
	int fd;
	vga_setmousesupport(TRUE);
	fd=mouse_init_return_fd("/dev/mouse",vga_getmousetype(),MOUSE_DEFAULTSAMPLERATE);
	if (fd<0)
	{
		perror("mouse_init");
		fprintf(stderr_file,"SVGALib: failed to open mouse device %d\n",fd);
		use_mouse=0;
	}
	else
	{
		/* fix ranges and initial position of mouse */
		/* fix ranges and initial position of mouse */
		mouse_setrange_6d(-500,500, -500,500, -500,500, -500,500,
                   -500,500, -500,500, MOUSE_6DIM);
		mouse_setposition_6d(0, 0, 0, 0, 0, 0, MOUSE_6DIM);
	}
   }
   
#ifdef USE_TIMER
    /* svgalib catches the timer alarm. so we have to arm it after all
       other svgalib initialising. */
    if (play_sound)
    {
       if(start_timer()==OSD_NOT_OK)
       {
          osd_close_display();
          return OSD_NOT_OK;
       }
    }
#endif

  return OSD_OK;
}


/* shut up the display */
void osd_close_display(void)
{
   if (use_signals)
   {
      sigaction(SIGUSR1, &oldsig1handler, NULL);
      sigaction(SIGUSR2, &oldsig2handler, NULL);
   }
   if (console_fd >= 0)
   {
      ioctl(console_fd, KDSETLED, 8);
      keyboard_close();
   }
   osd_free_bitmap(bitmap);
   CloseVScreen();  /* Shut down glide stuff */
   if (use_mouse) mouse_close();
}

int sysdep_mapkey(char *arg) 
{
	return OSD_OK;
}

void sysdep_mouse_poll (void)
{
	int i, mouse_buttons;
	
	mouse_update();
	
	mouse_getposition_6d(&mouse_data[0].deltas[0],
           &mouse_data[0].deltas[1],
           &mouse_data[0].deltas[2],
           &mouse_data[0].deltas[3],
           &mouse_data[0].deltas[4],
           &mouse_data[0].deltas[5]);
	
	mouse_buttons = mouse_getbutton();

        for(i=0; i<JOY_BUTTONS; i++)
        {
           mouse_data[0].buttons[i] = mouse_buttons & (0x01 << i);
        }

	mouse_setposition_6d(0, 0, 0, 0, 0, 0, MOUSE_6DIM);
}

static const int led_flags[3] = {
  LED_NUM,
  LED_CAP,
  LED_SCR
};

void osd_led_w(int led,int on)
{
	if (led>=3) return;
	if (on)
		leds |=  led_flags[led];
	else
		leds &= ~led_flags[led];
	if (console_fd >= 0)
		ioctl(console_fd, KDSETLED, leds);
}
