#ifndef __SOUND_H_
#define __SOUND_H_

#ifdef __SOUND_C_
#define EXTERN
#else
#define EXTERN extern
#endif

/* Hacked to use 16bit stereo sound by Mike Oliphant
   (oliphant@ling.ed.ac.uk) */

/* audio related stuff */
#define SAMP_MAX_8 127
#define SAMP_MIN_8 -128
#define SAMP_MAX_16 32767
#define SAMP_MIN_16 -32768
#define AUDIO_SAMPLE_FREQ	(22050)
#define AUDIO_SAMPLE_BITS	(8)

/* ideally should be set to some whole divider of the system timer,
   since the system timer of most unix systems has a freq of 100 we use 50 */
#ifndef AUDIO_TIMER_FREQ
#define AUDIO_TIMER_FREQ	(50)
#endif

/* the +1 is gone now although newer oss versions still do strange things,
   but that's autoqueried now */
#define AUDIO_BUFF_SIZE (num_frags*frag_size)

typedef struct sample_t
{
   int loop_stream;
   float vol;
   int pan;
   float freq_fac;
   signed short *end_data_pt;
   signed short *data;
   size_t datasize;
   struct sample_t *next_sample;
}
SAMPLE_T;

typedef struct voice_t
{
   signed short *current_data_pt;
   float pos_frac;
   SAMPLE_T *sample;
}
VOICE_T;

EXTERN int audio_timer_freq;

#undef EXTERN
#endif
