$ !
$ ! Make a transfer vector table for a library
$ !
$ lib = p1
$ libname = f$parse(p1,,,"name")
$ !
$ versionstring = "''p2'"
$ versionMajor = f$element(0, ".", versionstring)
$ versionMinor = f$string(-
	f$integer(f$element(1, ".", versionstring)) * 1000-
	+ f$integer(f$element(2, ".", versionstring))-
  )
$ ! sharedlib is always a subdirectory of the library we are sharing:
$ repository = p3
$ if repository .eqs. "" then repository="omnilib:"
$ !
$ write sys$output "GSMATCH=LEQUAL," + versionMajor + "," + versionMinor
$ !
$ ! create three files: 'libname'_modulenames.dat (side effect of
$ ! processmodules), 'libname'_manglednames.dat (std$output of tee), and
$ ! 'libname'_demangled.dat (output of cxxdemangler)
$ !
$ modulenamesdat=libname + "_modulenames.dat"
$ manglednamesdat=libname + "_manglednames.dat"
$ demanglednamesdat=libname + "_demanglednames.dat"
$ seg1 = "lib/list/names " + lib
$ seg2 = "processmodules " + libname
$ seg3 = "cxxdemangler /repository=" + repository
$ pipe seg1 | seg2 | tee 'manglednamesdat' | seg3 > 'demanglednamesdat'
$ !
$ currentmodule=""
$ open/error=modulesopen/read modules 'modulenamesdat'
$ open/error=mangledopen/read manglednames 'manglednamesdat'
$ open/error=demangledopen/read demanglednames 'demanglednamesdat'
$ !
$ next:
$ read/end=end_modules modules modulename
$ read/end=end_mangled manglednames mangledname
$ read/end=end_demangled demanglednames demangledname
$ !
$ ! Exclude compiler generated initialization routines and pointers:
$ !
$ pInit = "void (*const _p__init_" + modulename
$ pInitMangled = "_P__INIT_" + moduleName	! C++ 5.6 doesn't demangle this.
$ init = "void __init_" + modulename
$ if f$extract(0,f$length(pInit),demangledname) .nes. pInit .and.-
     f$extract(0,f$length(pInitMangled),mangledname) .nes. pInitMangled .and.-
     f$extract(0,f$length(init),demangledname) .nes. init
$ then
$   write sys$output "SYMBOL_VECTOR=(" + mangledname + "=PROCEDURE)"
$ endif
$ goto next
$ !
$end_modules:
$ !
$ close demanglednames
$ close manglednames
$ close modules
$ delete 'modulenamesdat';*
$ delete 'manglednamesdat';*
$ delete 'demanglednamesdat';*
$ exit
$ !
$modulesopen:
$ write sys$error "error opening " + modulenamesdat
$ exit 0
$ !
$mangledopen: write sys$error "error opening " + manglednamesdat
$ close modules
$ exit 0
$ !
$demangledopen: write sys$error "error opening " + demanglednamesdat
$ close manglednames
$ close modules
$ exit 0
$ !
$end_mangled:
$ write sys$error "Premature end of file reading " + manglednamesdat
$ close demanglednames
$ close manglednames
$ close modules
$ exit 0
$ !
$end_demangled:
$ write sys$error "Premature end of file reading " + demanglednamesdat
$ close demanglednames
$ close manglednames
$ close modules
$ exit 0
