package biss.awt;

import biss.ObserverSocket;
import java.util.Observable;
import java.util.Observer;

/**
 * logical view for generic confirm dialogs
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class Confirmer
  extends ObserverSocket
  implements Observer
{
	MessageBox View;

public Confirmer ( String text, Object selector,
            Observer owner, TopWindow parent ) {
	super( owner, selector);
	addObserver( owner);

	View = new MessageBox( "Please Confirm", text, parent);
	View.addButton( "Yes");
	View.addButton( "No");
	View.addCancelButton();

	View.OsClose.addObserver( this);
	View.openCentered();
}

public void update ( Observable obs, Object arg ) {
	if ( obs == View.OsClose ) {
		if ( View.wasConfirmed() ) {
			notifyObservers( Category);
		}
	}
}
}
