package biss.calendar;

import biss.DateLib;
import biss.awt.Awt;
import biss.awt.GraphicsLib;
import biss.awt.List;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

/**
 * Zeichenfunktionen fr die Darstellung der Calendar Eintrge
 */
public class DrawSupport
{
	static int XInc = Calendar.TextFontMetrics.charWidth( 'X');
	static Image ImgClock;
	static Image ImgAlarm;

static {
	Awt.insertGifPaths( Calendar.Values.getPaths( "GifPaths", "~/biss/src/biss/apps/calendar"));

	ImgClock = Awt.getImage( "bsacalboxclk.gif");
	ImgAlarm = Awt.getImage( "bsacalalarm.gif");
}

static void drawDateEntry ( List p ) {
	Graphics  g = p.DrawGraphics;
	Rectangle r = p.DrawRect;
	DateEntry o = (DateEntry)p.DrawObject;

	int x = r.x + 2;
	int y = r.y + r.height - Calendar.TextFontMetrics.getDescent() -
	( r.height - Calendar.TextFontMetrics.getHeight()) / 2;

	g.setFont( Calendar.TextFont);
	g.drawString( DateLib.toHMString( o.SDate) + ' ' +
	              o.ItemText, x, y );
}

static void drawDayEntry ( List p ) {
	Graphics  g = p.DrawGraphics;
	Rectangle r = p.DrawRect;
	ViewEntry o = (ViewEntry)p.DrawObject;

	int x = r.x + 2;
	int y = r.y + r.height - Calendar.TextFontMetrics.getDescent() -
	( r.height - Calendar.TextFontMetrics.getHeight()) / 2;

	g.setFont( Calendar.TextFont);

	if ( o.VSep )
		g.drawLine( r.x, r.y, r.width, r.y);

	g.drawString( o.Label, x, y );
	x += XInc * 5;
	g.drawLine( x, r.y, x, r.y+r.height);

	if ( !o.isEmpty() ){
		g.setColor( (o.ClashCount == 0) ? Color.lightGray : Color.red);
		g.fillRect( x+1, r.y, XInc-1, r.height );
		if ( o.numDates() > 1 ){
			g.setColor( Color.white);
			g.drawString( Integer.toString(o.numDates()), x+1, y);
		}
		g.setColor( p.DrawClrFore);
	}

	x += XInc;
	g.drawLine( x, r.y, x, r.y+r.height);

	x += XInc;
	if ( o.hasDates() ){
		String s = "";
		int alc = 0;
		for ( int i=0; i<o.Dates.size(); i++) {
			DateEntry de = (DateEntry)o.Dates.elementAt( i);
			s += de.ItemText;
			if ( de.ADate != null)
				alc++;
			if ( i<o.Dates.size()-1 )
				s += " / ";
		}
		if ( alc > 0){
			GraphicsLib.drawImageVCentered( g, ImgAlarm, x, r.y, r.height, p);
			x += 2*XInc;
		}
		g.drawString( s, x, y );

	} 
}

static void drawMonthEntry ( List p ) {
	drawWeekEntry( p);
}

static void drawWeekEntry ( List p ) {
	Graphics  g = p.DrawGraphics;
	Rectangle r = p.DrawRect;
	ViewEntry o = (ViewEntry)p.DrawObject;

	int x = r.x + 2;
	int y = r.y + r.height - Calendar.TextFontMetrics.getDescent() -
	( r.height - Calendar.TextFontMetrics.getHeight()) / 2;

	g.setFont( Calendar.TextFont);
	if ( o.VSep){
		g.setColor( Color.lightGray);
		g.fillRect( r.x, r.y, r.width, r.height);
		g.setColor( p.DrawClrFore);
		g.drawLine( r.x, r.y, r.x+r.width, r.y);
	}
	g.drawString( o.Label, x, y);
	if ( ! o.isEmpty() ){
		x += 10 * XInc;
		g.drawString( ((DateEntry)o.Dates.firstElement()).ItemText, x, y);
	}

}
}
