#include "global.h"
#include "parse.h"


#define M_2PI	6.28318530717958647692

/* earth parser */
Private
void earthParser(char *l, WObject *pearth)
{
  char *w;

  w = parseFileLine(l);
  w = parsePosition(w, pearth);
  pearth->soh = SolidParser(w);
}

/* system of equations handling permanent motion */
Private
void earthChangePermanent(float lasting, WObject *pearth)
{
  pearth->a1 += lasting * (-0.05);
  pearth->a1 -= M_2PI * (float)floor((double)(pearth->a1 / M_2PI));
}

/* condition to do position modifications */
Private
int earthChange(WObject *pearth)
{
  return (pearth->ext.earth.move.remaintime > 0.0005) ? TRUE : FALSE;
}

/* create from a fileline */
Private
void createEarthFromFile(Fileline l)
{
  WObject *pearth;

  pearth = (WObject*) malloc(sizeof(WObject));
  memset(pearth, 0, sizeof(WObject));    
  pearth->noh.type = EARTHTYPE;
  earthParser(l, pearth);
  strcpy(pearth->h_name, EARTHNAME);
  createNetObjectFromString(&(pearth->noh), "2/1", PERMANENT); /* obj name */
  pearth->ext.earth.move.remaintime = 0.0;
  pearth->changeflag = FALSE;

  updateObjectIn3D(pearth);
  updateBB(pearth);
  setOptionalBuffer(pearth);
  mobilelist = addObjectToList(pearth, mobilelist);
  insertObjectIntoGrid(pearth);

  pearth->ext.earth.aspeed = 0.1;
  pearth->ext.earth.remaint = 0;
  pearth->secs = 1;
  pearth->usecs = 0;
}

/* update an earth towards the network */
Private
int updateEarthToNetwork(WObject *pearth, WObject *pearthold)
{
  return TRUE;
}

/* object intersects: stop */
Private
void earthIntersect(WObject *pwoh, WObject *pwohold, WObject *pearth)
{
  copyPositionAndBB(pwohold, pwoh);
}

/* earth functions initialization */
Public
void initEarthFuncList(void)
{
  generalFuncList[EARTHTYPE].createFromFileline = createEarthFromFile;
  generalFuncList[EARTHTYPE].change = earthChange;
  /* generalFuncList[EARTHTYPE].updateToNetwork = updateEarthToNetwork; */
  generalFuncList[EARTHTYPE].whenIntersect = earthIntersect;
  generalFuncList[EARTHTYPE].changePermanent= earthChangePermanent;

  propertiesnumber[EARTHTYPE] = 0;

  defmaxlasting[EARTHTYPE] = MAXFLOAT;
}
