#ifndef RTPSESSION_H
#define RTPSESSION_H

#include "rtp.h"


typedef struct _sitem {
  u_int8	type;
  u_int8	len;
  u_int8 	*content;
  struct _sitem *next;
} sdes_item;

typedef struct _sinfo {
  u_int32	ssrc;
  u_int32	extended_max;
  u_int32	expected;
  u_int32	lost;
  source	s;
  sdes_item	sdes;		/* sdes from the source, if we received it */
  rtcp_sr_t	sr;
  rtcp_rr_t	rr;
  struct _sinfo *next;
} source_info;

typedef struct _Session {	/* Informations on the session */
  u_int32	sess_group;
  u_int16	sess_rtp_port;
  u_int16	sess_rtcp_port;
  u_int8	sess_ttl;
  rtp_hdr_t	sess_rtp_hdr;	/* session rtp header */
  u_int16	sess_rtp_seq;
  rtcp_sr_t	sess_sr;
  source_info	*sess_sinfo;	/* Informations on sources */
  u_int16	sess_nbsources;
  sdes_item	*sess_sdes;
  u_int8	sess_nbsdes;	/* number of sdes_items */
  struct _Session *next;
} Session;


Session * RtpAllocSession();
void RtpFreeSession(Session *);
void RtpCreateSession(Session *, u_int32, u_int16, u_int8);
void RtpCloseSession(Session *);
void RtpCreateHeader(Session *, rtp_hdr_t *);
void RtpInitSeq(source *, u_int16);
void RtpRefreshSDES(Session *);
source_info * RtpGetSinfo(u_int32);
void RtpDeleteSinfo(Session *, u_int32);
int RtpUpdateSeq(source *, u_int16);
char * AvatarName();
char * RtcpEmail();
char * RtcpName();
void RtpSendBye(Channel *);
/* u_int16 RtpCreateSeq(); */
/* u_int32 RtpCreateSsrc(int); */


#endif /* RTPSESSION_H */
