/*
 * Whiteboard tool
 *
 * Philippe Dax
 * Nov 1997
 */

#include "global.h"
#include "whiteboard.h"
#include "mc.h"

#ifdef WITHWHITEBOARD

/* global variable */
int whiteboardtool = WB_TOOL;
int whiteboardpid = -1;


void startwhiteboard(char *mc)
{
	char *p, *ttl;
	static char whiteboardmc[CHAN_LEN];

	strncpy(whiteboardmc, getwhiteboardmc(mc), sizeof(whiteboardmc));
	p = strrchr(whiteboardmc, '/');
	*p = '\0';
	ttl = ++p;
	whiteboardpid = fork();
	switch (whiteboardpid) {
	case -1:
		trace(DBG_TOOL, "can't fork for whiteboard");
		break;
	case 0:
#ifdef WITHWB
		if (whiteboardtool == WB_TOOL) {
			execl(WBPATH, "wb", "-C", "VReng", "-t", ttl, "-l", "+r", whiteboardmc,
				(char *) NULL);
			trace(DBG_TOOL, "can't exec wb");
		}
#endif
#ifdef WITHWBD
		if (whiteboardtool == WBD_TOOL) {
			execl(WBDPATH, "wbd", "-C", "VReng", "-t", ttl, "-l", "+r", whiteboardmc,
				(char *) NULL);
			trace(DBG_TOOL, "can't exec wbd");
		}
#endif
#ifdef WITHNT
		if (whiteboardtool == NT_TOOL) {
			execl(NTPATH, "nt", "-C", "VReng", "-t", ttl, whiteboardmc,
				(char *) NULL);
			trace(DBG_TOOL, "can't exec nt");
		}
#endif
		exit(1);
	default:
		break;
	}
}

void quitwhiteboard()
{
	if (whiteboardpid > 0) {
		kill(whiteboardpid, SIGKILL);
	}
}

char * getwhiteboardmc(char *mc)
{
	static char whiteboardmc[CHAN_LEN], group[GROUP_LEN];
	unsigned short port;

	port = getvrport(mc);
	port += WHITEBOARD_INCR_PORT;
	strncpy(group, getvrgroup(mc), sizeof(group));
	strncpy(whiteboardmc, createmc(group, port, ttlorigin), sizeof(whiteboardmc));
	trace(DBG_TOOL, "whiteboardmc=%s", whiteboardmc);
	return(whiteboardmc);
}

#endif /* WITHWHITEBOARD */
