/*
 * Video tool
 *
 * Philippe Dax
 * Nov 1997
 */


#include "global.h"
#include "video.h"
#include "mc.h"

#ifdef WITHVIDEO

/* global variable */
int videotool = VIC_TOOL;
int videopid = -1;


void startvideo(char *mc)
{
	static char videomc[CHAN_LEN];

	strncpy(videomc, getvideomc(mc), sizeof(videomc));
	videopid = fork();
	switch (videopid) {
	case -1:
		trace(DBG_TOOL, "can't fork for video");
		break;
	case 0:
		execl(VICPATH, "vic", "-A", "rtp", "-B", "20", "-D", VIDEODEVICE, "-f", "h261", "-C", "VReng", videomc,
			(char *) NULL);
		trace(DBG_TOOL, "can't exec vic");
		exit(1);
	default:
		break;
	}
}

void quitvideo()
{
	if (videopid > 0) {
		kill(videopid, SIGKILL);
	}
}

char * getvideomc(char *mc)
{
	static char videomc[CHAN_LEN], group[GROUP_LEN];
	unsigned short port;

        port = getvrport(mc);
	port += 4;
        if (port % 1)
                port++; /* even port for RTP */
	strncpy(group, getvrgroup(mc), sizeof(group));
	strncpy(videomc, createmc(group, port, ttlorigin), sizeof(videomc));
	trace(DBG_TOOL, "videomc=%s", videomc);
	return(videomc);
}

#endif /* WITHVIDEO */
