/*
 * INTERPPS tool
 *
 * Philippe Dax
 * Jul 1999
 */

#include "global.h"
#include "mc.h"
#include "pspdf.h"


Private
int wget(char *url)
{
#ifdef WITHWGET
	int wgetpid, wgetstatus;
	char *ps;
	char tmpps[32];

	ps = strrchr(url, '/');
	sprintf(tmpps, "/tmp/%s", ++ps);

	wgetpid = fork();
	switch (wgetpid) {
	case -1:
		trace(DBG_TOOL, "can't fork for wget");
		return(-1);
	case 0:
		execl(WGETPATH, "wget", "-qO", tmpps, url, (char *) NULL);
		trace(DBG_TOOL, "can't exec wget");
		exit(1);
	default:
#if HAVE_WAITPID
        	while (waitpid(-1, 0, WNOHANG) > 0)
#else
#if HAVE_WAIT3
        	while (wait3(&wgetstatus, WNOHANG, NULL) > 0)
#else
		while (wait(&wgetstatus) != -1)
#endif
#endif
		;
		trace(DBG_TOOL, "wgetstatus = %d", wgetstatus);
		return(0);
	}
#endif /* WITHWGET */
}

#ifdef WITHINTERPS

/* global variable */
int pstool = GV_TOOL;

Private
void startgv(char *tool, char *url)
{
#if defined(WITHGV) | defined(WITHGHOSTVIEW)
	int pspid = -1;
	char *ps;
	char tmpps[32];

	ps = strrchr(url, '/');
	sprintf(tmpps, "/tmp/%s", ++ps);

	pspid = fork();
	switch (pspid) {
	case -1:
		trace(DBG_TOOL, "can't fork for %s", tool);
		break;
	case 0:
#ifdef GVPATH
		execl(GVPATH, tool, tmpps, (char *) NULL);
#else
		execl(GHOSTVIEWPATH, tool, tmpps, (char *) NULL);
#endif
		trace(DBG_TOOL, "can't exec %s", tool);
		exit(1);
	default:
		break;
	}
#endif /* defined(WITHGV) | defined(WITHGHOSTVIEW) */
}

Public
void viewps(char *url)
{
	trace(DBG_TOOL, "pstool=%d url=%s", pstool, url);
	if (wget(url) == 0) {
		if (pstool == GV_TOOL)
			startgv("gv", url);
		else if (pstool == GHOSTVIEW_TOOL)
			startgv("ghostview", url);
		else trace(DBG_TOOL, "unknown ps");
	}
}

#endif /* WITHINTERPS */

Private
void starta2ps(char *tool, char *url)
{
#ifdef WITHA2PS
	int pspid = -1;
	char *ps;
	char tmpps[32];

	ps = strrchr(url, '/');
	sprintf(tmpps, "/tmp/%s", ++ps);

	pspid = fork();
	switch (pspid) {
	case -1:
		trace(DBG_TOOL, "can't fork for %s", tool);
		break;
	case 0:
		execl(A2PSPATH, tool, "-d", tmpps, (char *) NULL);
		trace(DBG_TOOL, "can't exec %s\n", tool);
		exit(1);
	default:
		break;
	}
#endif /* WITHA2PS */
}

Public
void printps(char *url)
{
	if (wget(url) == 0) {
		starta2ps("a2ps", url);
	}
}

