#
# Copyright (c) 1995 Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#	This product includes software developed by the Network Research
#	Group at Lawrence Berkeley National Laboratory.
# 4. Neither the name of the University nor of the Laboratory may be used
#    to endorse or promote products derived from this software without
#    specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#

set rtp_type(0) pcm
set rtp_type(1) celp
set rtp_type(3) gsm
set rtp_type(5) dvi
set rtp_type(7) lpc

proc vat_main {} {
	global V
	set V(class) Vat
	set V(app) vat
	set V(media) audio

	init_local

	#
	# Open a conference bus on the global channel (0).
	# We use this for negotiating ownership of
	# exclusive-access audio devices.
	#
	set V(devbus) [new confbus 0]
	$V(devbus) handler confbusHandler

	init_confbus
	# init_gui has to happen before init_network because under
	# windows the async i/o allows packets to come in before we
	# finish here & we need a controller object to handle them.
	init_gui
	init_network
	init_tk
	init_late
	
	#
	# Set up for backward compat
	#
	if { [resource sessionType] == "vat" } {
		set confid [resource confid]
		if { $confid == "" } {
			set confid 0
		}
		session confid $confid
		$V(session) confid $confid
	}
	# vat doesn't want traffic looped back (like vic does)
	$V(session) loopback 0

	# send back-to-back packets spaced out at 128kb/s
	$V(session) data-bandwidth 128
}
