/* sfm -- Simple File Manager
   Copyright (C) 1998 Pixel (Pascal Rigaux)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */
#ifndef SFM_DOC_H
#define SFM_DOC_H

#include "io.h"
#include "sfm_server.h"

#define NB_DIRENTRIES_MAX 20

typedef struct _SfmDoc SfmDoc;

struct _SfmDoc {
  char *initial_cwd;
  char *prog_name;
  int number;
  int cdm;

  char *dir_prefix;
  char *dir_suffix;
  DirList dir_list;

  int current_dir_entry, nb_dir_entries;
  char *dir_entries[NB_DIRENTRIES_MAX];
};


extern SfmDoc *sfm_doc_new(int number, int *argc, char ***argv);
extern void sfm_doc_free(SfmDoc *doc);
extern void sfm_doc_quit(SfmDoc *doc);
extern void sfm_doc_new_directory(SfmDoc *doc, char *name);
extern boolean sfm_doc_up_directory(SfmDoc *doc);
extern void sfm_doc_directory_has_changed(SfmDoc *doc);
extern void sfm_doc_delete(SfmDoc *doc, int *tab, int nb);
extern boolean sfm_doc_rename(SfmDoc *doc, char *before, char *after);
extern void sfm_doc_copy_or_cut(SfmDoc *doc, TypePaste type_paste, TypeAddOrOverride add_or_override, int *tab, int nb);
extern void sfm_doc_paste(SfmDoc *doc);

extern int sfm_doc_search_starts_with(SfmDoc *doc, char *word, int startIndice);
extern int sfm_doc_get_color_of_file(SfmDoc *doc, int indice);

extern boolean sfm_doc_create_directory(SfmDoc *doc);
extern boolean sfm_doc_create_file(SfmDoc *doc);
extern boolean sfm_doc_new_view(SfmDoc *doc, int num);
extern boolean sfm_doc_action(SfmDoc *doc, char *file);
extern void sfm_doc_many_actions(SfmDoc *doc, int *tab, int nb);
extern void sfm_doc_that_action(SfmDoc *doc, char *file, char *prog);
extern char **sfm_doc_choose_action(SfmDoc *doc, char *file, int *nb);
extern void sfm_doc_action_many_files(SfmDoc *doc, int *tab, int nb, char *prog);

extern int sfm_doc_find_name(SfmDoc *doc, char *name);
extern char *sfm_doc_set_dir_entry(SfmDoc *doc);
extern char *sfm_doc_down_stack_dir_entries(SfmDoc *doc);
extern char *sfm_doc_up_stack_dir_entries(SfmDoc *doc);
 
#endif
