/*
** 1998-10-21 -	A little module to hold the quit commands. Purged them from the main
**		gentoo.c module, in an effort to shrink it a little.
** 1999-05-07 -	Slightly rewritten using the new command argument support. Removed
**		the QuitNow command, use "Quit dialog=false" for the same effect.
** 1999-06-19 -	Adapted for the new dialog module.
*/

#include "gentoo.h"
#include "dialog.h"
#include "cmdarg.h"
#include "cmd_quit.h"

/* ----------------------------------------------------------------------------------------- */

/* 1998-09-15 -	Quit the program, but first check if there have been changes to the config. */
int cmd_quit(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	guint	dd, dialog = FALSE;
	gint	ret;

	dd = (min->cfg.flags & CFLG_CHANGED) ? 2 : 0;
	dialog = car_keyword_get_boolean(ca, "dialog", dd);

	if(dialog == 2)		/* Only show dialog if config changed (default behaviour). */
		gtk_signal_emit_by_name(GTK_OBJECT(min->gui->window), "delete_event", min, &ret);
	else if(dialog == 1)	/* Show dialog always. */
	{
		if(dlg_dialog_sync_new_simple_wait("Are you sure you want to quit?", "Confirm", "Yes|No") == DLG_POSITIVE)
			gtk_main_quit();
	}
	else
		gtk_main_quit();

	return TRUE;
}
