//  wminterface.cc for bbtools.
//
//  Copyright (c) 1998-1999 by John Kennis, jkennis@chello.nl
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// (See the included file COPYING / GPL-2.0)
//

#include "wminterface.hh"
#include "resource.hh"

WMInterface::WMInterface(ToolWindow *toolwindow) {
  bbtool=toolwindow;
  kwm_module_desktop_change =
    XInternAtom(bbtool->getDisplay(),"KWM_MODULE_DESKTOP_CHANGE", False);
  kwm_module_desktop_number_change =
    XInternAtom(bbtool->getDisplay(),"KWM_MODULE_DESKTOP_NUMBER_CHANGE", False);
  kwm_module_init = XInternAtom(bbtool->getDisplay(),"KWM_MODULE_INIT", False);
  kwm_module_win_add = XInternAtom(bbtool->getDisplay(), "KWM_MODULE_WIN_ADD", False);
  kwm_module_win_remove =
    XInternAtom(bbtool->getDisplay(), "KWM_MODULE_WIN_REMOVE", False);
  kwm_module_win_change =
    XInternAtom(bbtool->getDisplay(),"KWM_MODULE_WIN_CHANGE",False);
  kwm_module_win_activate =
    XInternAtom(bbtool->getDisplay(),"KWM_MODULE_WIN_ACTIVATE",False);
  kwm_module_win_iconfied = XInternAtom(bbtool->getDisplay(),"KWM_WIN_ICONFIED",False);
  kwm_module_win_raise = XInternAtom(bbtool->getDisplay(),"KWM_MODULE_WIN_RAISE",False);
  kwm_module_win_lower = XInternAtom(bbtool->getDisplay(),"KWM_MODULE_WIN_LOWER",False);
}

void WMInterface::moduleInit() {
  static Atom kwm_atom = 0;
  long int data=1;
  if (!kwm_atom)
    kwm_atom = XInternAtom(bbtool->getDisplay(), "KWM_MODULE", False);

  XChangeProperty(bbtool->getDisplay(), bbtool->framewin,
                  kwm_atom, kwm_atom, 32,
                  PropModeReplace, (unsigned char *)&data, 1);

  sendClientMessage(kwm_atom, (long) bbtool->framewin);
}

void WMInterface::sendClientMessage(Atom atom, XID data) {
  XEvent e;
  unsigned long mask;

  e.xclient.type = ClientMessage;
  e.xclient.window = bbtool->framewin;

  e.xclient.message_type = atom;
  e.xclient.format = 32;
  e.xclient.data.l[0] = (unsigned long) data;
  e.xclient.data.l[1] = CurrentTime;

  mask =  SubstructureRedirectMask;
  XSendEvent(bbtool->getDisplay(), 
             bbtool->getCurrentScreenInfo()->getRootWindow(),
             False, mask, &e);
}

void WMInterface::changeDesktop(int desk_number) {
  static Atom kwm_atom = 0;
  unsigned long int data=desk_number+1;
  if (!kwm_atom)
    kwm_atom = XInternAtom(bbtool->getDisplay(), "KWM_CURRENT_DESKTOP", False);

  XChangeProperty(bbtool->getDisplay(), 
                  bbtool->getCurrentScreenInfo()->getRootWindow(), 
                  kwm_atom, kwm_atom, 32,
                  PropModeReplace, (unsigned char *)&data, 1);

}


void WMInterface::sendWindowToDesktop(Window win,int desk_number) {
  static Atom kwm_atom = 0;
  unsigned long int data=desk_number;
  if (!kwm_atom)
    kwm_atom = XInternAtom(bbtool->getDisplay(), "KWM_WIN_DESKTOP", False);

  XChangeProperty(bbtool->getDisplay(), win, kwm_atom, kwm_atom, 32,
                  PropModeReplace, (unsigned char *)&data, 1);

  sendClientMessage(kwm_atom, data);
}

int WMInterface::getWinOnDesktop(Window win) {
  static Atom kwm_atom = 0;
  Atom real_type;
  int format;
  unsigned long n, extra;
  int status;
  long *p=0;

  if (!kwm_atom)
    kwm_atom = XInternAtom(bbtool->getDisplay(), "KWM_WIN_DESKTOP", False);

  status = XGetWindowProperty(bbtool->getDisplay(), win, kwm_atom, 0L, 1L,
                              False, kwm_atom, &real_type, &format,
                              &n, &extra,  (unsigned char**)&p);
  if (!status)
    return (int) p[0];
  
  return -1;
}

int WMInterface::isIcon(Window win) {
  static Atom kwm_atom = 0;
  Atom real_type;
  int format;
  unsigned long n, extra;
  int status;
  long *p=0;

  if (!kwm_atom)
    kwm_atom = XInternAtom(bbtool->getDisplay(), "KWM_WIN_ICONIFIED", False);

  status = XGetWindowProperty(bbtool->getDisplay(), win, kwm_atom, 0L, 1L,
                              False, kwm_atom, &real_type, &format,
                              &n, &extra,  (unsigned char**)&p);

  if (!status) {
    if (p) return (int) p[0];
    else return 0;
  }

  return -1;
}

int WMInterface::isSticky(Window win) {
  static Atom kwm_atom = 0;
  Atom real_type;
  int format;
  unsigned long n, extra;
  int status;
  long *p=0;

  if (!kwm_atom)
    kwm_atom = XInternAtom(bbtool->getDisplay(), "KWM_WIN_STICKY", False);

  status = XGetWindowProperty(bbtool->getDisplay(), win, kwm_atom, 0L, 1L,
                              False, kwm_atom, &real_type, &format,
                              &n, &extra,  (unsigned char**)&p);

  if (!status) {
    if (p) return (int) p[0];
    else return 0;
  }

  return -1;
}


int WMInterface::getNumberOfDesktops() {
  static Atom kwm_atom = 0;
  Atom real_type;
  int format;
  unsigned long n, extra;
  int status;
  long *p=0;

  if (!kwm_atom)
    kwm_atom = XInternAtom(bbtool->getDisplay(), "KWM_NUMBER_OF_DESKTOPS", False);
  status = XGetWindowProperty(bbtool->getDisplay(), 
                              bbtool->getCurrentScreenInfo()->getRootWindow(),
                              kwm_atom, 0L, 1L,
                              False, kwm_atom, &real_type, &format,
                              &n, &extra,  (unsigned char**)&p);

  return (int) p[0];
}

int WMInterface::getCurrentDesktop() {
  static Atom kwm_atom = 0;
  Atom real_type;
  int format;
  unsigned long n, extra;
  int status;
  long *p=0;

  if (!kwm_atom)
    kwm_atom = XInternAtom(bbtool->getDisplay(), "KWM_CURRENT_DESKTOP", False);

  status = XGetWindowProperty(bbtool->getDisplay(), 
                            bbtool->getCurrentScreenInfo()->getRootWindow(),
                              kwm_atom, 0L, 1L,
                              False, kwm_atom, &real_type, &format,
                              &n, &extra,  (unsigned char**)&p);

  return (int) p[0];
}

void WMInterface::addSticky(WindowList *tmp)
{
  tmp->sticky=True;
        
  LinkedListIterator<DesktopList> desktop_it(bbtool->desktopList);

  for (; desktop_it.current(); desktop_it++) {
    if (bbtool->getCurrentDesktopNr()!=
      desktop_it.current()->desktop_nr) {
      WindowList *copy = new WindowList;
      copy->win= tmp->win;
      copy->width=tmp->width;
      copy->height=tmp->height;
      copy->x_position=tmp->x_position;
      copy->y_position=tmp->y_position;
      copy->icon=tmp->icon;
      copy->sticky=tmp->sticky;
      copy->focused=tmp->focused;
      copy->desktop_nr=desktop_it.current()->desktop_nr;
      bbtool->addFrameWindow(copy,False);
      bbtool->windowList->insert(copy);
    }
  }
}

void WMInterface::removeSticky(Window win,int keep_on_desktop)
{
  int i;

  for (i=0;i<getNumberOfDesktops();i++) {
  LinkedListIterator<WindowList> win_it(bbtool->windowList);

  for (; win_it.current(); win_it++) {
    if (win_it.current()->win==win &&
      win_it.current()->desktop_nr!=keep_on_desktop)
      break;
    }
              
    if (win_it.current()) {
      WindowList *old = win_it.current();
      bbtool->windowList->remove(old);
      XDestroyWindow(bbtool->getDisplay(),old->pager_win);
      delete old;
    }
  }
}

void WMInterface::windowChange(Window win) {
  double xdiv,ydiv;
  int status;

  LinkedListIterator<WindowList> win_it(bbtool->windowList);
  for (; win_it.current(); win_it++)
    if ((win_it.current()->win) == win)
      break;

  if (win_it.current()) {
    WindowList *tmp = win_it.current();

    status=isIcon(tmp->win);

    if (status==-1) return;

    if (status==1) {
      if (!tmp->sticky) {
        XUnmapWindow(bbtool->getDisplay(),tmp->pager_win);
        tmp->icon=True;
      }
      else {
        LinkedListIterator<WindowList> win_it(bbtool->windowList);

        for (; win_it.current(); win_it++) {
          if (win_it.current()->win==tmp->win) {
            XUnmapWindow(bbtool->getDisplay(),win_it.current()->pager_win);
            win_it.current()->icon=True;
          }
        }
      }
    }
    else 
      if (tmp->icon) {
        if (!tmp->sticky) {
          XMapWindow(bbtool->getDisplay(),tmp->pager_win);
          tmp->icon=False;
        }
          else {
          LinkedListIterator<WindowList> win_it(bbtool->windowList);
  
          for (; win_it.current(); win_it++) {
            if (win_it.current()->win==tmp->win) {
              XMapWindow(bbtool->getDisplay(),win_it.current()->pager_win);
              win_it.current()->icon=False;
            }
          }
        }
      }
  
    status=isSticky(tmp->win);

    if (status==-1) return;
      
    if (status) {
      if (!tmp->sticky) {
        addSticky(tmp);
      }
    }
    else if (tmp->sticky) { 
      removeSticky(tmp->win,bbtool->getCurrentDesktopNr());
      tmp->sticky=False;
    }
    
    if (!tmp->sticky)
    {
      int desktop=getWinOnDesktop(tmp->win);
      if (desktop==-1) return;

      bbtool->moveWinToDesktop(tmp->win,desktop);
    }
    /* need only do this if geometry changed; FIX THIS */
    status=bbtool->getWindowGeometry(tmp);
    if (status==-1) return;
    xdiv=(double)bbtool->resource->desktopSize.width/
            bbtool->getCurrentScreenInfo()->getWidth();
    ydiv=(double)bbtool->resource->desktopSize.height/
            bbtool->getCurrentScreenInfo()->getHeight();
    tmp->pager_x=(int)(tmp->x_position*xdiv);
    tmp->pager_y=(int)(tmp->y_position*ydiv);
    tmp->pager_width=(unsigned int)(tmp->width*xdiv);
    tmp->pager_height=(unsigned int)(tmp->height*ydiv);
    if (tmp->pager_width==0) tmp->pager_width=1;
    if (tmp->pager_height==0) tmp->pager_height=1;
    
    if (!tmp->sticky) {
      XMoveResizeWindow(bbtool->getDisplay(), tmp->pager_win,tmp->pager_x,tmp->pager_y,
                      tmp->pager_width,tmp->pager_height);

      if (!win_it.current()->focused || 
                      bbtool->resource->getFocusStyle()!=texture)
        XSetWindowBackgroundPixmap(bbtool->getDisplay(), tmp->pager_win,
                                 bbtool->getPixmap().window);
         else
            XSetWindowBackgroundPixmap(bbtool->getDisplay(),
                                    win_it.current()->pager_win,
                                    bbtool->getPixmap().focusedWindow);
    }
    else {
      LinkedListIterator<WindowList> win_it(bbtool->windowList);

      for (; win_it.current(); win_it++) {
        if (win_it.current()->win==tmp->win) {
          XMoveResizeWindow(bbtool->getDisplay(), win_it.current()->pager_win,
                            tmp->pager_x,tmp->pager_y,
                            tmp->pager_width,tmp->pager_height);

          if (!win_it.current()->focused || 
                            bbtool->resource->getFocusStyle()!=texture)
            XSetWindowBackgroundPixmap(bbtool->getDisplay(),
                                    win_it.current()->pager_win,
                                    bbtool->getPixmap().window);
          else
            XSetWindowBackgroundPixmap(bbtool->getDisplay(),
                                    win_it.current()->pager_win,
                                    bbtool->getPixmap().focusedWindow);
 
        }
      }
    }
  }
}
