/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1996-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */

#ifndef _GREP_H_
#define _GREP_H_

int Hex2Pat( const char *str, char* pat );

/*
 * FSearch -- functions family for searching pattern in a file
 * pattern (pat) format is:
 * ~pattern -- regular expression ( start with `~' => `~^[123]+\t')
 * $pattern -- hex pattern ( start with `$' => `$ FF 0A B4...' )
 *  pattern -- normal exact string pattern ( use `\' to escape first char:
 *              example => `\~tilde_expansion' or `\$440 is too much' )
 * tip: if you want to search normal pattern which starts with `\' you
 *      have to enter this: `\\start slash etc.'
 *
 * RETURN VALUE:
 * -1  -- pattern not found
 * -2  -- pattern incorrect (for regexp's and hex patterns)
 * xx  -- found position
 */

long FSearch   ( const char *pat, int patsize, const char* pfIn, int nocase, int spos = -1 );
long FSearch   ( const char *pat, int patsize, FILE* pfIn, int nocase, int spos = -1 );
long FSearchStr( const char *pat, const char* pfIn, int nocase, int spos = -1 );
long FSearchStr( const char *pat, FILE* pfIn, int nocase, int spos = -1 );

// normally should use the functions bove, these below are kind of low-level's

long FKMPSearch( const char *pat, int patsize, FILE* pfIn, int nocase, int spos = -1 );

extern int FGREPMAXLINE; // change this for new input line length
extern int FGrepLines; // how many lines FGrep has passed
long FGrep     ( const char *pat, FILE* pfIn, int nocase, int spos = -1 );

#endif //_GREP_H_
