#include "config.h"
#include "writefile.h"
#include <errno.h>
#include <unistd.h>
#include <stdio.h>

/* ****************************************************************** */
void writefile(int fd) {
  char membuf[512];
  int n = 0;
  int m = 0;
  int count = 0;
  char *bufptr;

  /* Copy stdin to the output file, watching the return values each time. */
  while(1) {
    /* Read stdin into the buffer. */
    n = read(STDIN_FILENO, membuf, 512);
    if(n<0 && errno == EINTR) continue;
    if(n<0) {
      perror("Error reading input");
      exit(-1);
    }
    if(n == 0) break;

    /* Write the buffer to our file. */
    bufptr = membuf;
    for(count=0; count < n; count++) {
      do{m = write(fd, bufptr, 1);} while( m==0 || (m<0 && errno == EINTR));
      if(m<0) {
	perror("Error writing output");
	exit(-1);
      }
      bufptr++;
    }
  }

  /* The file is copied. */
  return;
}
/* ****************************************************************** */


