/*
 *  $Id: wnnerrmsg.c $
 */

/*
 * FreeWnn is a network-extensible Kana-to-Kanji conversion system.
 * This file is part of FreeWnn.
 * 
 * Copyright Kyoto University Research Institute for Mathematical Sciences
 *                 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1999
 * Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright FreeWnn Project 1999, 2000
 *
 * Maintainer:  FreeWnn Project   <freewnn@tomo.gr.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include "jslib.h"
#include "commonhd.h"
#include "wnn_os.h"
#include "msg.h"

#ifdef  not_use
char *wnn_errormsg[] = {
  "no_error 0",
  "ե뤬¸ߤޤ",   /*WNN_NO_EXIST  1 */
  "no_error 2",
  "allocǼԤޤ",        /*WNN_MALLOC_ERR        3 */
  "no_error 4",
  "ǤϤޤ",       /*WNN_NOT_A_DICT        5  */
  "٥եǤϤޤ",       /*WNN_NOT_A_HINDO_FILE  6  */
  "°եǤϤޤ",     /*WNN_NOT_A_FUZOKUGO_FILE 7  */
  "no_error 8",
  "ơ֥뤬դǤ",   /*WNN_JISHOTABLE_FULL   9 */
  "٥ե뤬ꤵ줿٥եǤϤޤ",
  /*WNN_HINDO_NO_MATCH   10 */
  "no_error 11",
  "no_error 12",
  "no_error 13",
  "no_error 14",
  "no_error 15",
  "ե뤬ץǤޤ",     /*WNN_OPENF_ERR         16 */
  "٥եǤϤޤ", /* WNN_NOT_HINDO_FILE   17 */
  "°եǤϤޤ",       /* WNN_NOT_FZK_FILE 18 */
  "°θĿ٥Ĺʤɤ¿᤮ޤ", /* WNN_FZK_TOO_DEF 19 */
  "ֹμϡȤƤޤ",       /*WNN_DICT_NOT_USED     20 */
  "no_error 21",
  "no_error 22",
  "no_error 23",
  "°եƤޤ",     /* WNN_BAD_FZK_FILE  24     */
  "ʻֹ椬۾Ǥhinsi.dataޤ",       /*WNN_GIJI_HINSI_ERR 25 */
  "̤ʻ줬üʻȤƤޤ",     /*WNN_NO_DFE_HINSI 26 */
  "°ե뤬ɤ߹ޤƤޤ",     /*WNN_FZK_FILE_NO_LOAD        27 */
  "no_error 28",
  "no_error 29",
  "Υȥ꤬¿᤮ޤ",     /*WNN_DIC_ENTRY_FULL    30 */
  "Ѵ褦ȤʸĹ᤮ޤ",       /*WNN_LONG_MOJIRETSU    31 */
  "°ΰ褬­Ƥޤ",   /*WNN_WKAREA_FULL       32 */
  "no_error 33",
  "ΰ褬­Ƥޤ",       /* WNN_JKTAREA_FULL 34 */
  "䤬 1 ĤޤǤ ",     /* WNN_NO_KOUHO 35 */
  "no_error 36",
  "no_error 37",
  "no_error 38",
  "no_error 39",
  "ɤߤĹ᤮ޤ",         /*WNN_YOMI_LONG 40 */
  "Ĺ᤮ޤ",         /*WNN_KANJI_LONG        41 */
  "ꤵ줿ϡϿǽǤϤޤ", /*WNN_NOT_A_UD    42 */
  "ɤߤĹ0Ǥ",        /*WNN_NO_YOMI   43 */
  "ꤵ줿ϡհǽǤϤޤ",       /* WNN_NOT_A_REV        44 */
  "꡼ɥ꡼μϿ/褦Ȥޤ",  /*WNN_RDONLY    45 */
  "Ķ¸ߤʤϿ褦Ȥޤ",       /* WNN_DICT_NOT_IN_ENV 46 */
  "no_error 47",
  "no_error 48",
  "꡼ɥ꡼٤ѹ褦Ȥޤ",       /* WNN_RDONLY_HINDO 49 */
  "ꤵ줿ñ줬¸ߤޤ",     /*WNN_WORD_NO_EXIST     50 */
  "no_error 51",
  "no_error 52",
  "no_error 53",
  "no_error 54",
  "no_error 55",
  "no_error 56",
  "no_error 57",
  "no_error 58",
  "no_error 59",
  "allocǼԤޤ",        /*WNN_MALLOC_INITIALIZE 60 */
  "no_error 61",
  "no_error 62",
  "no_error 63",
  "no_error 64",
  "no_error 65",
  "no_error 66",
  "no_error 67",
  "Υ顼ޤ",       /* WNN_SOME_ERROR 68 */
  "ХȯƤͤǤ",       /*WNN_SONOTA 69 */
  "ФǤޤ",     /*WNN_JSERVER_DEAD 70 */
  "alloc˼Ԥޤ",      /*WNN_ALLOC_FAIL        71 */
  "Ф³ǤޤǤ",     /*WNN_SOCK_OPEN_FAIL    72 */
  "̿ץȥΥС󤬹äƤޤ",       /* WNN_BAD_VERSION      73 */
  "饤ȤĶǤϤޤ", /* WNN_BAD_ENV 74 */
  "no_error 75",
  "no_error 76",
  "no_error 77",
  "no_error 78",
  "no_error 79",
  "ǥ쥯ȥ뤳ȤǤޤ",       /* WNN_MKDIR_FAIL       80      */
  "no_error 81",
  "no_error 82",
  "no_error 83",
  "no_error 84",
  "no_error 85",
  "no_error 86",
  "no_error 87",
  "no_error 88",
  "no_error 89",
  "եɤ߹ळȤǤޤ",       /* WNN_FILE_READ_ERROR  90 */
  "ե񤭽ФȤǤޤ",       /* WNN_FILE_WRITE_ERROR 91 */
  "饤Ȥɤ߹եǤϤޤ",   /* WNN_FID_ERROR 92 */
  "ʾեɤ߹ळȤǤޤ",       /* WNN_NO_MORE_FILE     93 */
  "ѥɤְäƤޤ",       /* WNN_INCORRECT_PASSWD    94   */
  "ե뤬ɤ߹ޤƤޤ ",    /*WNN_FILE_IN_USE            95 */
  "ե뤬Ǥޤ ",        /*WNN_UNLINK             96 */
  "ե뤬ޤ", /*WNN_FILE_CREATE_ERROR   97 */
  "ףΥեǤޤ",     /*WNN_NOT_A_FILE              98      */
  "եI-nodeFILE_UNIQפǤޤ",    /*WNN_INODE_CHECK_ERROR   99 */

  "ʻե뤬礭᤮ޤ",       /* WNN_TOO_BIG_HINSI_FILE 100 */
  "ʻե뤬礭᤮ޤ",       /* WNN_TOO_LONG_HINSI_FILE_LINE 101  */
  "ʻե뤬¸ߤޤ",       /* WNN_NO_HINSI_DATA_FILE 102 */
  "ʻեƤְäƤޤ",       /* WNN_BAD_HINSI_FILE 103 */
  "no_error 104",
  "ʻե뤬ɤ߹ޤƤޤ",       /* WNN_HINSI_NOT_LOADED 105 */
  "ʻְ̾äƤޤ",   /* WNN_BAD_HINSI_NAME 106 */
  "ʻֹ椬ְäƤޤ", /* WNN_BAD_HINSI_NO 107 */
  "no_error 108",
  "ϥݡȤƤޤ", /*NOT_SUPPORTED_OPERATION 109 Not Used */
  "ѥɤäƤե뤬ץǤޤ",       /*WNN_CANT_OPEN_PASSWD_FILE 110  */
/* Υ顼  */
  "uumrcե뤬¸ߤޤ",      /*WNN_RC_FILE_NO_EXIST    111 Not Used */
  "uumrcեηäƤޤ",        /* WNN_RC_FILE_BAD_FORMAT  112 Not Used */
  "ʾĶ뤳ȤϤǤޤ",       /* WNN_NO_MORE_ENVS  113 */
  "Υ饤Ȥɤ߹եǤޤ", /* WNN_FILE_NOT_READ_FROM_CLIENT 114 */
  "٥ե뤬ĤƤޤ",       /*WNN_NO_HINDO_FILE 115 */
  "ѥɤΥե뤬ޤ"      /*WNN_CANT_CREATE_PASSWD_FILE 116 */
};

int wnn_errormsg_len = sizeof (wnn_errormsg) / sizeof (char *);

extern int wnn_errorno;
static char msg[] = ":BAD ERRORNO!!! ";

char *
wnn_perror ()
{
  static char msgarea[100];

  if ((wnn_errorno < 0) || (wnn_errorno > sizeof (wnn_errormsg) / sizeof (char *)))
    {
      sprintf (msgarea, "%d", wnn_errorno);
      strcat (msgarea, msg);
      return (msgarea);
    }
  return (wnn_errormsg[wnn_errorno]);
}
#endif /* not_use */

extern int wnn_errorno;
extern struct msg_cat *wnn_msg_cat;
static char msg[] = ":BAD ERRORNO!!! ";

char *
wnn_perror_lang (lang)
     char *lang;
{
  static char msgarea[100];

  sprintf (msgarea, "%d", wnn_errorno);
  strcat (msgarea, msg);
  return (msg_get (wnn_msg_cat, wnn_errorno, msgarea, lang));
}

char *
wnn_perror ()
{
  return (wnn_perror_lang (NULL));
}

/*
  Local Variables:
  eval: (setq kanji-flag t)
  eval: (setq kanji-fileio-code 0)
  eval: (mode-line-kanji-code-update)
  End:
*/
