/*

Sound audio library
   
Copyright (c) 1999 Pascal Hofstee & Alain Kalker
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

$Id: sound.c,v 1.10 1999/10/16 10:43:02 daeron Exp $

*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include "wsound.h"

#include <assert.h>


char *WSoundLibVersion="0.1";

int		SErrorCode=SERR_NONE;
proplist_t	WMSoundDB = NULL;
Bool		WMSoundDBLoaded = False;



void
wAbort(void) {
	exit(1);
}


int
SPlaySound(char *file) {
	if (SFindSoundServer() == -1) {
		SErrorCode = SERR_NOSERVER;
		return -1;
	}
	else {
		if (!WMSoundDBLoaded) {
			SLoadConfig();
		}
		SSetStringForKey(file, S_USERDEF);
		PLSave(WMSoundDB, YES);
		WMSoundDBLoaded = False;
		PLRelease(WMSoundDB);
		SSendSound();
	}
}


		
int
SCoreSound(char *file)
{
	SAudioFileInfo	*afInfo;
	
	assert(file != NULL);
	
	/* Aquire audio information */
	afInfo = SGetAudioFileInfo(file);
	if (!afInfo)
		return -1;

#ifdef DEBUG
	SPrintAudioFileInfo(afInfo);
#endif

	return SPerformAudio(afInfo);
}



void
SSendSound(void)
{
	XEvent          SoundEvent;
	SoundEvent.xclient.type         = ClientMessage;
	SoundEvent.xclient.message_type = _XA_WINDOWMAKER_WM_FUNCTION;
	SoundEvent.xclient.format       = 32;
	SoundEvent.xclient.display      = dpy;
	SoundEvent.xclient.window       = wsoundserver;
	SoundEvent.xclient.data.l[0]    = SEVNT_USERDEF;
	XSendEvent(dpy, wsoundserver, False, NoEventMask, &SoundEvent);
	XFlush(dpy);
	XCloseDisplay(dpy);
}



int
SPlayEvent(long wsEventID)
{
	char           *sound_file;
	int		errorcode;

	if (!WMSoundDBLoaded)
		SLoadConfig();
	
	sound_file = SGetSoundFile(SMapEventID(wsEventID));
	
	if (sound_file) {
		if (strcmp(sound_file, "None") == 0)
			errorcode = 0;
		else
			errorcode = SCoreSound(sound_file);
		free(sound_file);
	}
	else
		errorcode = -1;
	
	WMSoundDBLoaded = False;
	PLRelease(WMSoundDB);
	return errorcode;
}

