/* WSoundPrefs.h- general definitions
 *
 *  WSoundPrefs - WMSound Server Preferences Program
 *
 * Copyright (c) 1998, 1999 Pascal Hofstee
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _WSOUNDPREFS_H_
#define _WSOUNDPREFS_H_

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <limits.h>

#include <X11/Xlib.h>

#include <proplist.h>

#include <wraster.h>

#include <WINGs.h>
#include <WUtil.h>

#include <wsound.h>

#include "PLFunctions.h"

#define WVERSION        "1.1.0"
#define WMVERSION       "0.60.x"


/* 
 * Needed for HAVE_LIBINTL_H
 */              
#if HAVE_LIBINTL_H && I18N
# include <libintl.h>
# define _(text) gettext(text)
#else
# define _(text) (text)
#endif

typedef struct {
	WMWindow	*win;
	
	WMButton	*saveBtn;
	WMButton	*closeBtn;

	WMTabView	*tabView;
	WMFrame		*eventF;
		WMFrame		*sndevntF;
			WMPopUpButton	*sndevntP;
			WMLabel		*sndevntL;
		WMFrame		*sndfileF;
			WMTextField	*sndfileT;
			WMButton	*sndplayB;
			WMButton	*sndclearB;
			WMButton	*sndbrowseB;

		WMFrame		*sndsetF;
			WMButton	*sndsetloadB;
			WMButton	*sndsetsaveB;
			WMLabel		*sndsetsL;
		WMFrame		*devF;
			WMLabel		*devL;
			WMTextField	*devT;
	
	WMFrame		*soundpathF;
		WMList		*sndL;
		WMButton	*sndaB;
		WMButton	*sndrB;

	WMFrame		*soundsetpathF;
		WMList		*sndsetL;
		WMButton	*sndsetaB;
		WMButton	*sndsetrB;
		
	WMFrame		*aboutF;
		WMLabel         *iconL;
		WMLabel         *titleL;
		WMLabel         *authorsL;
		WMFrame         *infoFrm;
			WMLabel         *versionL;
			WMLabel         *wingsL;
			WMLabel         *vendorL;
			WMLabel         *osL;
			WMLabel         *cpuL;
			WMLabel         *userL;
		WMLabel         *copyrightL;
			
	WMColor *red;
	WMColor *black;
	WMColor *white;
	WMFont *font;
	

	char lastBrowseDir[PATH_MAX];
	char lastLoadDir[PATH_MAX];
	char lastSaveDir[PATH_MAX];
} Panel;

#endif

