/* Gtick  -  A Gtk+ Metronome
 *
 *   dsp.c: /dev/dsp access code
 *
 * Copyright (c) 1999, Alex Roberts
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
 /* Funky /dev/dsp programming stuff here.. */

#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <stdlib.h>
#ifdef FREEBSD
#include <machine/soundcard.h>
#else
#include <linux/soundcard.h>
#endif
#include <glib.h>

#include "gtick.h"

static int dsp;
static int rate, c, channels, format;
static unsigned char *data, *data2;
static unsigned char *ptr;
static unsigned char v = 128;

      
int gtInitDSP ()
{
#ifdef DEBUG
	g_print ("gtInitDSP: Initialising /dev/dsp..\n");
#endif

	/* Initialise /dev/dsp */
	if ((dsp = open ("/dev/dsp", O_WRONLY)) == -1)
	  {
	    perror ("/dev/dsp");
	    return -1;
	  }


	/* Set up Output format */
	format = AFMT_S16_LE;  
	if (ioctl (dsp, SNDCTL_DSP_SETFMT, &format) == -1)  
	  { /* Fatal error */  
	    perror ("SNDCTL_DSP_SETFMT");  
	    exit(1);  
	  }        
                        
	/* Set dsp to Mono */
	channels = 0;
	ioctl (dsp, SNDCTL_DSP_STEREO, &channels);
	
	/* Set the DSP rate (in Hz) */
	rate = 44100;
	ioctl (dsp, SNDCTL_DSP_SPEED, &rate);

      
	/* Set up output tone */
	data = g_malloc (44100);
	ptr = data;
        
	for (c=0; c<128; c++)
	   {
	     *ptr++ = v++;
	   }
     
	for (c=128; c < 44100; c++)
	   *ptr++ = 128;
        
        data2 = g_malloc (44100);
        ptr = data2;
        v = 128;
        
        
        for (c = 0; c < 256; c++)
           {
             *ptr++ = v++;
           }
        
        for (c = 256; c < 44100; c++)
           *ptr++ = 128;
        
	return 0;
}

void gtCloseDSP ()
{
#ifdef DEBUG
	g_print ("gtCloseDSP: Closing /dev/dsp..\n");
#endif
	close (dsp);
}


void gtDSPTick (gint count)
{
static int time;

	if (time == 0)
	  time = 1;

#ifdef DEBUG
	g_print ("Count=%d, Time=%d\n",count, time);
#endif
	
	
	if (count == 1)
	  {
	    write (dsp, data2, 16000);
	    return;
	  }
	
	if (time == 1)
	  {
	    write (dsp, data2, 16000);
	    time ++;
	  }
	else
	  {
	    write (dsp, data, 16000);

	    if (time >= count)
	        time = 1;
	    else
	        time++;
	    
	    return;
	  }

	return;
}

#ifdef TEST_DSP
int main ()
{
int t;

	gtInitDSP ();
  
	for (t = 0; t < 6; t++)
	   gtDSPTick ();

	gtCloseDSP ();
	
	return 0;
}
#endif /* TEST_DSP */