# Generic unix/gcc Makefile for abcMIDI package 
# 
#
# compilation #ifdefs - you need to compile with these defined to get
#                       the code to compile with PCC.
#
# NOFTELL in midifile.c and tomidi.c selects a version of the file-writing
#         code which doesn't use file seeking.
#
# PCCFIX in mftext.c midifile.c midi2abc.c
#        comments out various things that aren't available in PCC
#

all : abc2midi midi2abc abc2abc mftext

abc2midi : parseabc.o store.o genmidi.o midifile.o queues.o
	gcc -o abc2midi parseabc.o store.o genmidi.o queues.o midifile.o

abc2abc : parseabc.o toabc.o
	gcc -o abc2abc parseabc.o toabc.o

midi2abc : midifile.o midi2abc.o 
	gcc midifile.o midi2abc.o -o midi2abc

mftext : midifile.o mftext.o crack.o
	gcc midifile.o mftext.o crack.o -o mftext

parseabc.o : parseabc.c abc.h
	gcc -c parseabc.c 

toabc.o : toabc.c abc.h
	gcc -c toabc.c 

# could use -DNOFTELL here
genmidi.o : genmidi.c abc.h midifile.h
	gcc -c genmidi.c

store.o : store.c abc.h midifile.h
	gcc -c store.c

queues.o : queues.c
	gcc -c queues.c

# could use -DNOFTELL here
midifile.o : midifile.c midifile.h
	gcc -c midifile.c

midi2abc.o : midi2abc.c midifile.h
	gcc -c midi2abc.c

crack.o : crack.c
	gcc -c crack.c 

mftext.o : mftext.c midifile.h
	gcc -c mftext.c

clean :
	rm *.o abc2midi midi2abc abc2abc mftext
