#
#  $Id: MoneyManager.py,v 1.2 1999/12/11 12:35:11 rob Exp $
#
#  Copyright 1998-1999 Rob Tillotson <robt@debian.org>
#  All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee or royalty is
#  hereby granted, provided that the above copyright notice appear in
#  all copies and that both the copyright notice and this permission
#  notice appear in supporting documentation or portions thereof,
#  including modifications, that you you make.
#
#  THE AUTHOR ROB TILLOTSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
#  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
#  AND FITNESS.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
#  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
#  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
#  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE!
#
"""MoneyManager by StingerSoft.

  This module handles databases in the format used by MoneyManager, aka
  PilotMoney.  I have only been able to test this module with data from
  the last shareware version; the file format used by the commercial
  version might be different.
"""

__version__ = '$Id: MoneyManager.py,v 1.2 1999/12/11 12:35:11 rob Exp $'

__copyright__ = 'Copyright 1998-1999 Rob Tillotson <robt@debian.org>'


import Pyrite
import Pyrite.Connector.Connector
from Pyrite import Blocks, _
import struct, string, time

class Connector(Pyrite.Connector.Connector):
    name = 'MoneyManager'
    version = Pyrite.version
    author = Pyrite.author
    url = ''
    description = _("MoneyManager by StingerSoft.")

    def __init__(self, *a, **kw):
	apply(Pyrite.Connector.Connector.__init__, (self,)+a, kw)
	self.default_name = 'MoneyDB'
	self.default_class = Database
	self.default_creator = 'Mony'
	self.default_type = 'MoDT'
	self.flags = 0x0008
	
    def classify(self, info={}):
	if info.get('type') == 'MoDT' and info.get('creator') == 'Mony':
	    return Database
	

class Record(Blocks.Record):
    def __init__(self, raw='', index=0, id=0, attr=0, category=0):
	self.flags = 0
	self.checknum = 0
	self.amount = 0
	self.total = 0
	self.amountc = 0
	self.totalc = 0
	self.date = 0
	self.repeat = 0
	self.flags2 = 0
	self.type = 0
	self.reserved = ''
	self.description = ''
	self.note = ''
	Pyrite.Record.__init__(self, raw, index, id, attr, category)

    def unpack(self, raw):
	self.raw = raw

	self.flags, self.checknum, self.amount, self.total, self.amountc, \
		    self.totalc, sec, min, hr, day, month, year, wkday, \
		    self.repeat, self.flags2, self.type, self.reserved, \
		    self.description = \
		    struct.unpack('>bxHllhhhhhhhhhbbb3s19s', raw[0:55])
	self.note = raw[55:]
	if '\0' in self.note:
	    self.note = self.note[:string.index(self.note,'\0')]
	if '\0' in self.description:
	    self.description = self.description[:string.index(self.description,'\0')]
	self.date = int(time.mktime( (year, month, day, hr, min, sec, 0, 0, -1) ))

    def pack(self):
	tup = time.localtime(self.date)
	if tup[6] >= 6: wkday = 0
	else: wkday = tup[6] + 1
	r = struct.pack('>bxHllhhhhhhhhhbbb3s19s', self.flags, self.checknum,
			self.amount, self.total, self.amountc, self.totalc,
			tup[5], tup[4], tup[3], tup[2], tup[1], tup[0],
			wkday, self.repeat, self.flags2, self.type,
			self.reserved, self.description[:18])
	self.raw = r + self.note + '\0'
	return self.raw
    

class AppBlock(Blocks.AppBlock):
    def __init__(self, *a):
	apply(Pyrite.AppBlock.__init__, (self,)+a)

    def unpack(self, raw):
	self.raw = raw
	n = Pyrite.unpack_category_appinfo(self.__dict__, raw)
	raw = raw[n:]

	self.typelabels = []
	for x in range(0, 20):
	    z = raw[:10]
	    raw = raw[10:]
	    if '\0' in z: z = z[:string.index(z, '\0')]
	    self.typelabels.append(z)

	self.tranlabels = []
	for x in range(0, 20):
	    z = raw[:20]
	    raw = raw[20:]
	    if '\0' in z: z = z[:string.index(z, '\0')]
	    self.tranlabels.append(z)

    def pack(self):
	self.raw = Pyrite.pack_category_appinfo(self.__dict__)

	for l in (self.typelabels + 20*[''])[:20]:
	    self.raw = self.raw + struct.pack('>9s', l) + '\0'

	for l in (self.tranlabels + 20*[''])[:20]:
	    self.raw = self.raw + struct.pack('>19s', l) + '\0'
	return self.raw
    
	

class Database(Pyrite.Database):
    def __init__(self, *a, **kw):
	apply(Pyrite.Database.__init__, (self,)+a, kw)
	self.record_class = Record
	self.appblock_class = AppBlock
