/* pilrctst.c:  Test program for PilRC
 *
 * Wes Cherry
 * wesc@ricochet.net
 */

#pragma pack(2)

#include "pilrctst.h"
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>

int kidForm;


DWord PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags)
	{
	short err;
	EventType e;
	FormType *pfrm;

	if (!cmd) 
		{
		kidForm = kidForm1;
		FrmGotoForm(kidForm);

	    while(1) 
			{
			EvtGetEvent(&e, 100);
			if (SysHandleEvent(&e)) 
				continue;
			if (MenuHandleEvent((void *)0, &e, &err)) 
				continue;
	
			switch (e.eType) 
				{
			case ctlSelectEvent:
				if (e.data.ctlSelect.controlID == kidOk)
					{
					kidForm++;
					if (kidForm > kidFormLast)
						kidForm = kidForm1;
					FrmGotoForm(kidForm); 
					}
				goto Dft;
				break;
		
			case frmLoadEvent:
		        FrmSetActiveForm(FrmInitForm(e.data.frmLoad.formID));
				break;
	
			case frmOpenEvent:
				pfrm = FrmGetActiveForm();
				FrmDrawForm(pfrm);
				if (e.data.frmLoad.formID == kidForm12)
					{
					TableType *ptbl;
	
					ptbl = FrmGetObjectPtr(pfrm, FrmGetObjectIndex(pfrm, kidTable));
	
					TblSetColumnUsable(ptbl, 0, true);
					TblSetColumnUsable(ptbl, 1, true);
					TblSetColumnUsable(ptbl, 2, true);
					TblSetColumnUsable(ptbl, 3, true);
					TblSetColumnUsable(ptbl, 4, true);
					TblSetRowUsable(ptbl, 0, true);
					TblSetRowUsable(ptbl, 1, true);
	
					TblSetItemStyle(ptbl, 0, 0, textTableItem);
					TblSetItemStyle(ptbl, 1, 0, textTableItem);
					TblSetItemStyle(ptbl, 2, 0, textTableItem);
					TblDrawTable(ptbl);
					}
							
				break;

			case menuEvent:
				FrmAlert(kidAlert1);
				break;

			case appStopEvent:
				return 0;

			default:
Dft:
				FrmHandleEvent(FrmGetActiveForm(), &e);
				}
			}
		}
	return 0;
	}

