/* tracktype for all unidentified raw data files */

#ifndef STDFILETRACK_H
#define STDFILETRACK_H

#include "tracks.h"
#include "varman.h"
#include "rterm.h"

#define STDFILETRACK_MAXTRACKTYPES 30

typedef struct 
{
	char filename[256];       /* the file where the data is read from */
	int  filedes;             /* file descriptor pointing to the file if open,otherwise -1 */
	char *suffix;             /* convenience pointer to the filenames suffix */
	int  convpid;             /* pid and pipe of the converter process */
	int  filterpid;           /* containing the gtoaster internal filters pid */
	int  tracksize;           /* cache for tracksize */
	
	/* the rterm info is used if in debugging mode only (#define DEBUG in
	 * stdfiletrack.c */						     
	rterm_pipeinfo *debugfilter;
	int  errp;
	
} stdfiletrack_info;   

extern varman_database *stdfiletrack_tracktypes;

/* maybe we should move this functions to another file on the long run.
 * wouldnt piping.c seem quite appropriate ? */
void stdfiletrack_byteswap(int cstdin,int cstdout,int cstderr,gpointer data);

tracks_trackinfo *stdfiletrack_create(char *filename);
void stdfiletrack_init();

#endif // STDFILETRACK_H
