/* the widget displaying the fill state of the current cd */

#include "int.h"

#include <gtk/gtk.h>

#include "main.h"
#include "trackedit.h"
#include "updatehandlers.h"

GtkWidget *fillstate_progress;

void fillstate_updatehandler(gpointer data)
{
	unsigned int size;
	int i;
	
	size=0;
	for (i=0;i<trackedit->entries;i++)
		  size+=tracks_tracksize(tracklist_gettrack(trackedit,i));
	
	gtk_progress_set_value(GTK_PROGRESS(fillstate_progress),size/(1024*1024));
}
;

void fillstate_create()
{
	fillstate_progress=gtk_progress_bar_new();
	gtk_progress_bar_set_orientation(GTK_PROGRESS_BAR(fillstate_progress),
					 GTK_PROGRESS_LEFT_TO_RIGHT);
	gtk_progress_bar_set_bar_style(GTK_PROGRESS_BAR(fillstate_progress),
				       GTK_PROGRESS_CONTINUOUS);
	gtk_progress_set_format_string(GTK_PROGRESS(fillstate_progress),
				       _("Fillstate: %v MB/ %u MB ( %p %% )"));
	gtk_progress_set_show_text(GTK_PROGRESS(fillstate_progress),TRUE);	
	gtk_progress_set_text_alignment(GTK_PROGRESS(fillstate_progress),
					0.0,0.5);
	/* FIXME: get the cd size from record.c instead of assuming 650 MB */
	gtk_progress_configure(GTK_PROGRESS(fillstate_progress),
			       0,
			       0,
			       650);
	
	gtk_widget_show(fillstate_progress);
	gtk_box_pack_start(GTK_BOX(downbox),
			   fillstate_progress,
			   1,1,1);

	updatehandlers_register(&trackedit->updatehandlers,
				fillstate_updatehandler,
				NULL);
}
;
