#include <stdlib.h>
#include <stdio.h>

#include <gtk/gtk.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

int NP_Collections::do_one_server( char *server, FILE *file,
                                   NP_Stringarray& output_lines )
{
   int total_groups;
   if ( tree.get_node_stats( server, &total_groups,
                             NULL, NULL, NULL, NULL ))
   {
      tree.print_error();
      return 1;
   }

   if ( !total_groups )
      return 0;

   NP_Stringarray group_array;
   if ( tree.get_groups( server, group_array ))
   {
      tree.print_error();
      return 1;
   }

   for( int j = 0; j < total_groups; ++j )
   {
      char *group_name = ( char *)group_array[ j ];
      if ( group_name == NULL )
      {
         group_array.print_error();
         continue;
      }

      if ( !child_pid )
         return 1;
      
      char buffer[ 1024 ];
      snprintf( buffer, sizeof buffer, "%s:%s\n", server, group_name );
      if ( fputs( buffer, file ) <= 0 )
         return 1;

      snprintf( buffer, sizeof buffer, "%s: %s...", server, group_name );
      if ( output_lines.add_item( buffer ))
      {
         show_message( output_lines.get_error(), 0 );
         return 1;
      }
   }

   return 0;
}
