/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-1999 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include "defines.h"

extern void set_tty(int);

#define RCS_NUMBER 17

const char *rcs[] = {
   "# variables\n",
   "PFTPPORT     1234 # enter your default port number\n",
   "PFTPSFILTER  /bin/gzip -cd:/usr/bin/pgp -f\n",
   "PFTPCFILTER  gzip -4:pgp -fe\n",
   "PFTPPASS     *# holds the password if needed. A `*' forbids logins at all\n",
   "#PFTPCLIENTS  space separated list of allowed client hosts\n",
   "#PFTPRECEIVE  holds the absolute path to an upload directory\n",
   "#PFTPLOG      holds the absolute path to the client error log file\n",
   "#PFTPNETBUF   sets the maximum net buffer size in bytes\n",
   "#PFTPSORTBY   sets the sorting order within the pfm\n",
   "#PFTPRENAME   1 # automatically rename new files\n",
   "#PFTPUPLIMIT  sets the maximum size in kilo bytes of the upload directory\n\n",
   "# host names\n",
   "example.host.name1 2222 # port number is 2222\n",
   "example.host.name2      # the default port number is taken\n",
   "@V<REMOTEHOSTNAME>      # this line is substituted with the\n",
   "                        # environment variable REMOTEHOSTNAME.\n"
};

void create_rc_file(char *rcfile)
{
   char ch;
   fprintf(stderr, "** Couldn't find a pftp resource file.  Create it? (Y|n) ");
   set_tty(1);
   if ((ch = fgetc(stdin)) != '\n') fputc('\n', stderr);
   set_tty(0);
   if (ch != 'n') {
      int i=0, rfd=0;

      if ((rfd = open(rcfile, O_CREAT|O_WRONLY, 0600)) < 0) {
         fprintf(stderr, "Couldn't open file `%s' for writing.\n", rcfile);
         exit(PFTP_FILE_OPEN_ERR);
      }
      for (i=0; i < RCS_NUMBER; i++) {
         if (write(rfd, *(rcs+i), strlen(*(rcs+i))) < 0) {
            fprintf(stderr, "** write: %s\n", _PFTP_ERROR_ARRAY_);            
            exit(PFTP_WRITETODISK_ERR);
         }
      }
      close(rfd);
      fprintf(stderr, "Please adjust your personal needs in `%s'.\n", rcfile);
   }
   else {
      fprintf(stderr, "*** The resource file was not created.\n");
   }
}


#if defined HAVE_LIBCRYPT && !defined HP_UX && !defined FreeBSD && !defined OpenBSD && !defined unicos
#include <crypt.h>
#endif

void create_passwd(void)
{
   char *passwd=NULL, *p=NULL, *t=NULL;
   char salt[8], *s=NULL;
   int i=0;
   
   fprintf(stderr, "Please give me some salt! (two characters out of [a-zA-Z0-9./]): ");
   s = salt;
   set_tty(1);
   for (i=0; i < 2; i++, s++) {
      if (!((*s = fgetc(stdin)) >= 'a' && *s <= 'z') \
       && !(*s >= 'A' && *s <= 'Z') \
       && !(*s >= '0' && *s <= '9') \
       && *s != '.' && *s != '/') {
         fprintf(stderr, "\nHmmm...read the last line again.\n");
         set_tty(0);
         exit(PFTP_INPUT_ERR);
      }
   }
   *s = '\0';
   set_tty(0);
   set_tty(2);
   MEM_CHECK((passwd = (char *)calloc(SONAME, sizeof(char))));
   MEM_CHECK((p = (char *)calloc(SONAME, sizeof(char))));
   fprintf(stderr, "\nPassword: ");
   for (t=fgets(p, SONAME, stdin); *t && *t != '\n'; t++);
   *t = '\0';
   if (*p) strcpy(passwd, p);
   else {
      fprintf(stderr, "\n** No password entered.\n");
      set_tty(0);
      free(p);
      free(passwd);
      exit(PFTP_INPUT_ERR);
   }
   fprintf(stderr, "\nRetype the password: ");
   for (t=fgets(p, SONAME, stdin); *t && *t != '\n'; t++);
   *t = '\0';
   if (*p) {
      if (!strcmp(passwd, p)) {
         free(p);
         for (p=passwd, i=0; *p && *p != '\n' && i < 8; i++, p++);
         *p = '\0';
         fprintf(stderr, "\n");
         fprintf(stdout, "%s\n", (char *)crypt(passwd, salt));
         p = NULL;
      }
      else {
         fprintf(stderr, "\n** Mistyped. Try again.\n");
         set_tty(0);
         exit(PFTP_INPUT_ERR);
      }
   }
   else fprintf(stderr, "\n** No password entered.\n");
   set_tty(0);
   if (p) free(p);
   free(passwd);
   exit(PFTP_NO_ERR);
}
