/* NetLeds applet - Lights from a network device
 * Copyright (C) 1999 Michael Witrant
 *
 * Homepage: http://netleds.port5.com
 * Author: Michael Witrant
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "defines.h"

/* Images */
#include "pix/green_on.xpm"
#include "pix/green_off.xpm"
#include "pix/yellow_on.xpm"
#include "pix/yellow_off.xpm"
#include "pix/red_on.xpm"
#include "pix/red_off.xpm"
#include "pix/rect_green_on.xpm"
#include "pix/rect_green_off.xpm"
#include "pix/rect_yellow_on.xpm"
#include "pix/rect_yellow_off.xpm"
#include "pix/rect_red_on.xpm"
#include "pix/rect_red_off.xpm"

#define NULLPIX {{NULL,NULL},{NULL,NULL}}

lcolor t_lcolors[] = {
/*{ ID, Name,              pix on,             pix off,             NULLPIX },*/

  {  0, "Circle - Green",  green_on_xpm,       green_off_xpm,       NULLPIX },
  {  1, "Circle - Yellow", yellow_on_xpm,      yellow_off_xpm,      NULLPIX },
  {  2, "Circle - Red",    red_on_xpm,         red_off_xpm,         NULLPIX },
  {  3, "Rect - Green",    rect_green_on_xpm,  rect_green_off_xpm,  NULLPIX },
  {  4, "Rect - Yellow",   rect_yellow_on_xpm, rect_yellow_off_xpm, NULLPIX },
  {  5, "Rect - Red",      rect_red_on_xpm,    rect_red_off_xpm,    NULLPIX },
  { -1, "<null>",          NULL,               NULL,                NULLPIX }
};
lcolor *lcolors = t_lcolors;

