/*
Copyright (C) 1997,1998  Ong Lon Voon <rarf@ddns.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-------------------------------------
Email bugs, comments to rarf@ddns.org
-------------------------------------
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <errno.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <signal.h>
#include "lib.h"

#define MAJOR_VERSION "0"
#define MINOR_VERSION "4"
#define BUILD_VERSION "7"
#ifndef CONF
#define CONF "/etc/irquery.conf"
#endif
#define SERVER "mars.netspire.com.sg"
#define PING "localhost"
#define MAXSERVER 5
#define PORT 9999
#define MAXPORT 5
#define BUFLEN 1000
#define DEBUG_LEVEL 0
#define VERSION MAJOR_VERSION"."MINOR_VERSION"."BUILD_VERSION
#define MAXLIST 50
#define IP_AUTO "AUTO"
#ifdef _WIN32
#define TMPFILE "/temp/irquery.ip"
#else
#define TMPFILE "/tmp/irquery.ip"
#endif
#define DMF_HOST "mail.ddns.org"
#define DMF_IP "203.120.99.200"
#define DHTTP_IP "203.120.99.200"
#ifndef TIME_OUT
#define TIME_OUT 0
#endif

int Connect(void);
int ReadConfig(void);
int init(void);
int search(void);
#if defined(_WIN32)
int snprintf(char *,int,const char *,va_list);
#elif defined(__osf__)||(__hpux)||(NO_SNPRINTF)
int snprintf(char *,int,const char *,...);
#endif
#if defined(_WIN32)
long gethostid(void);
#endif

char * Server[MAXSERVER+1]={"",SERVER};
int Port[MAXPORT+1]={0,PORT};
char * Id="1";
char * Email;
char * Ip="";
char * Host;
char * Pass;
char * List[MAXLIST+1];
char * Script="";
char * mode;
int count=0;
int pcount=0;
int scount=0;
int fd;
int debug=DEBUG_LEVEL;
char * Conf=CONF;
char * Tmpfile=TMPFILE;
int Timeout=0;
int XPass=0;
int Daemon=0;
int Dmf=0;
int Dhttp=0;
char * Flags;
int alarm_clock;

int main(int argc,char * * argv)
{
  int i;
  char * buf;
  int status;

  mode=strdup(argv[0]);
  if ((buf=strrchr(mode,'/'))!=NULL) {
    mode=buf+1;
  }
  if ((buf=strrchr(mode,'\\'))!=NULL) {
    mode=buf+1;
  }
#if defined(_WIN32)||(__EMX__)
  if ((buf=strchr(mode,'.'))!=NULL) {
    *buf='\0';
  }
#endif

  strtoupper(mode);
  for (i=1;i<argc;i+=2) {
    if (strcmp(argv[i],"-conf")==0) {
      Conf=strdup(argv[i+1]);
    }
    else if (strcmp(argv[i],"-debug")==0) {
      debug=atoi(argv[i+1]);
    }
    else if (strcmp(argv[i],"-ip")==0) {
      Ip=strdup(argv[i+1]);
    }
    else if (strcmp(argv[i],"-server")==0) {
      scount++;
      Server[scount]=strdup(argv[i+1]);
    }
    else if (strcmp(argv[i],"-port")==0) {
      pcount++;
      Port[pcount]=atoi(argv[i+1]);
    }
  }
  if (debug>1) {
    fprintf(stdout,"Conf  : %s\n",Conf);
  }
  ReadConfig();
  for (i=1;i<argc;i+=2) {
    if (strcmp(argv[i],"-id")==0) {
      Id=strdup(argv[i+1]);
    }
    else if (strcmp(argv[i],"-host")==0) {
      Host=strdup(argv[i+1]);
    }
    else if (strcmp(argv[i],"-email")==0) {
      Email=strdup(argv[i+1]);
    }
    else if (strcmp(argv[i],"-pass")==0) {
      Pass=strdup(argv[i+1]);
    }
    else if (strcmp(argv[i],"-xpass")==0) {
      Pass=strdup(argv[i+1]);
      XPass=1;
    }
    else if (strcmp(argv[i],"-list")==0) {
      count++;
      if (count<=MAXLIST) {
        List[count]=strdup(argv[i+1]);
      }
    }
    else if (strcmp(argv[i],"-debug")==0) {
      debug=atoi(argv[i+1]);
    }
    else if (strcmp(argv[i],"-timeout")==0) {
      Timeout=atoi(argv[i+1]);
    }
    else if (strcmp(argv[i],"-tmpfile")==0) {
      Tmpfile=strdup(argv[i+1]);
    }
    else if (strcmp(argv[i],"-script")==0) {
      Script=strdup(argv[i+1]);
      if (*Script=='\"') {
        Script++;
        *(Script+strlen(Script)-1)='\0';
      }
    }
    else if (strcmp(argv[i],"-daemon")==0) {
      Daemon=atoi(argv[i+1]);
    }
    else if (strcmp(argv[i],"-flags")==0) {
      Flags=strdup(argv[i+1]);
    }
    else if (strcmp(argv[i],"-dmf")==0) {
      Dmf=atoi(argv[i+1]);
    }
    else if (strcmp(argv[i],"-dhttp")==0) {
      Dhttp=atoi(argv[i+1]);
    }
    else if (strcmp(argv[i],"-help")==0) {
      fprintf(stdout,"%s [-switch parameter]\n",argv[0]);
      fprintf(stdout,"\twhere switch: email ip host pass xpass list debug\n");
      fprintf(stdout,"\t              conf id server port script tmpfile\n");
      fprintf(stdout,"\t              dmf dhttp daemon\n");
      fprintf(stdout,"URL: http://www.netspire.com.sg/IP/clients/documentation.html\n");
      fprintf(stdout,"Version: %s\n",VERSION);
      exit(0);
    }
  }
  if (strcmp(mode,"IRON")!=0) {
    Daemon=0;
  }
  if ((Daemon)&&(Timeout<(2*Daemon+5))) {
    Timeout=2*Daemon+5;
  }
  if (debug>1) {
    fprintf(stdout,"Final Settings...\n");
    fprintf(stdout,"Debug   : %d\n",debug);
    fprintf(stdout,"ID      : %s\n",Id);
    fprintf(stdout,"Email   : %s\n",Email);
    fprintf(stdout,"Pass    : ******\n");
    fprintf(stdout,"XPass   : ******\n");
    fprintf(stdout,"Host    : %s\n",Host);
    fprintf(stdout,"IP      : %s\n",Ip);
    for (i=1;i<=scount;i++) {
      fprintf(stdout,"Server  : %s\n",Server[i]);
    }
    for (i=1;i<=pcount;i++) {
      fprintf(stdout,"Port    : %d\n",Port[i]);
    }
    fprintf(stdout,"Script  : %s\n",Script);
    for (i=1;i<=count;i++) {
      fprintf(stdout,"List    : %s\n",List[i]);
    }
    fprintf(stdout,"Timeout : %d\n",Timeout);
    fprintf(stdout,"Daemon  : %d\n",Daemon);
    fprintf(stdout,"DMF     : %d\n",Dmf);
    fprintf(stdout,"DHTTP   : %d\n",Dhttp);
    fprintf(stdout,"Flags   : %s\n",Flags);
    fprintf(stdout,"End Settings...\n");
  }
#ifndef _WIN32
  if ((Daemon)&&(debug==0)) {
    status=fork();
    if (status!=0) {
      exit(0);
    }
  }
  else if ((Daemon)&&(debug)) {
    fprintf(stdout,"Daemon Mode Foreground in Debug Mode...\n");
  }
#endif
  while (Daemon) {
    /*
    status=ping(Server[1],"  ",5);
    */
    status=Connect();
    sleep(Daemon*60);
    execvp(argv[0],argv);
  }
  exit(Connect());
}

void alarm_handler(int sig)
{
  alarm_clock=1;
}

int Connect(void)
{
  static struct sockaddr_in serv_addr;
  struct hostent * serv_ent;
  struct in_addr addr;
  int status;
  char buf[BUFLEN];
  char * token;
  int i;
  int j;

  if (debug>1) {
    fprintf(stdout,"Connecting...\n");
  }

  for (i=1;i<=pcount;i++) {
    for (j=1;j<=scount;j++) {
      if (debug>2) {
        fprintf(stdout,"Trying %s:%d...\n",Server[j],Port[i]);
        fflush(stdout);
      }
      bzero((void *)&serv_addr,sizeof(serv_addr));
      serv_ent=gethostbyname(Server[j]);
      if (serv_ent==NULL) {
        serv_ent=gethostbyaddr(Server[j],strlen(Server[j]),AF_INET);
      }
      if (serv_ent==NULL) {
        if ((i==pcount)&&(j==scount)) {
          fprintf(stderr,"client gethostbyname() and gethostbyaddr() failed\n");
          exit(-1);
        }
        else {
          continue;
        }
      }
      addr=*((struct in_addr *)serv_ent->h_addr);
      serv_addr.sin_family=AF_INET;
      serv_addr.sin_addr.s_addr=addr.s_addr;
      serv_addr.sin_port=htons(Port[i]);

      fd=socket(PF_INET,SOCK_STREAM,0);
      if (fd==-1) {
        perror("client socket() call failed");
        exit(-1);
      }

      alarm_clock=0;
      alarm(TIME_OUT);
      signal(SIGALRM,alarm_handler);

      status=connect(fd,(struct sockaddr *)&serv_addr,sizeof(serv_addr));
      alarm(0);
      if (alarm_clock==1) {
        fprintf(stderr,"client connect() timed out\n");
        fflush(stderr);
        continue;
      }
      else if (status!=0) {
        close(fd);
      }
      if ((status==-1)&&(i==pcount)&&(j==scount)) {
        if (Daemon==0) {
          fprintf(stderr,"client connect() call failed\n");
          exit(-1);
        }
        return(-1);
      }
      else if (status!=-1) {
        if (debug>1) {
          fprintf(stdout,"Connected to %s:%d\n",Server[j],Port[i]);
        }
        break;
      }
    }
    if (status!=-1) {
      break;
    }
  }

  /* close socket on exec for daemon mode */
  fcntl(fd,F_SETFD,1);

  if (strlen(Script)) {
    if (debug>1) {
      fprintf(stdout,"Executing Script...\n");
    }
    token=strtok(Script,",");
    while (token!=NULL) {
      if (strchr(token,' ')!=NULL) {
        *(strchr(token,' '))='\0';
        strtoupper(token);
        *(token+strlen(token))=' ';
      }
      else {
        strtoupper(token);
      }
      if (strcmp(token,"INIT")==0) {
        if (init()==-1) {
          return(-1);
        }
      }
      else if (strcmp(token,"INIT_ON")==0) {
        if (dynamic(1)==-1) {
          return(-1);
        }
        if (init()==-1) {
          return(-1);
        }
      }
      else if (strcmp(token,"INIT_OFF")==0) {
        if (dynamic(0)==-1) {
          return(-1);
        }
        if (init()==-1) {
          return(-1);
        }
      }
      else if (strcmp(token,"SEARCH")==0) {
        search();
      }
      else if (strncmp(token,"DEBUG",5)==0) {
        debug=atoi(token+6);
      }
      else {
        snprintf(buf,BUFLEN,"%s",token);
        if (debug) {
          fprintf(stdout,"(Sent) %s\n",buf);
        }
        sendto(fd,buf,strlen(buf),0,NULL,0);
        status=recvfrom(fd,buf,BUFLEN,0,0,NULL);
        if (status==-1) {
          shutdown(fd,2);
          return(-1);
        }
        *(buf+status)='\0';
        if (debug) {
          fprintf(stdout,"(Received) %s",buf);
        }
        if ((strncmp(buf,"ERR PASS",8)==0)||
            (strncmp(buf,"ERR XPASS",9)==0)||
            (strncmp(buf,"ERR NEWPASS",11)==0)||
            (strncmp(buf,"ERR ID",6)==0)||
            (strncmp(buf,"ERR CLOSE",9)==0)) {
          shutdown(fd,2);
          return(-1);
        }
        else if (strncmp(buf,"OK QUIT",7)==0) {
          shutdown(fd,2);
          return(0);
        }
      }
      token=strtok(NULL,",");
    }
  }

  fprintf(stdout,"IP Registry Query Ver %s\n",VERSION);
  while(1) {
    fprintf(stdout,"<- ");
    fflush(stdin);
    fgets(buf,BUFLEN,stdin);
    strip(buf);
    if (strlen(buf)==0) {
      continue;
    }

    token=strdup((char *)strtok(strdup(buf)," "));
    strtoupper(token);
    if (strcmp(token,"INIT")==0) {
      if (init()==-1) {
        return(-1);
      }
    }
    else if (strcmp(token,"INIT_ON")==0) {
      if (dynamic(1)) {
        return(-1);
      }
      if (init()==-1) {
        return(-1);
      }
    }
    else if (strcmp(token,"INIT_OFF")==0) {
      if (dynamic(0)) {
        return(-1);
      }
      if (init()==-1) {
        return(-1);
      }
    }
    else if (strcmp(token,"SEARCH")==0) {
      search();
    }
    else if (strcmp(token,"DEBUG")==0) {
      debug=atoi(buf+6);
    }
    else if (strcmp(token,"EXIT")==0) {
      shutdown(fd,2);
      return(0);
    }
    else {
    /*
    else if (strcmp(token,"XPASS")==0) {
      status=getsockname(fd,(struct sockaddr *)&serv_addr,&(int)len);
      if (status==-1) {
        snprintf(buf,BUFLEN,"PASS %s",buf+6);
      }
      else {
        snprintf(buf,BUFLEN,"XPASS %s",(char *)xcrypt(Pass,serv_addr.sin_addr.s_addr));
      }
    }
    */
      sendto(fd,buf,strlen(buf),0,NULL,0);
      status=recvfrom(fd,buf,BUFLEN,0,0,NULL);
      if (status==-1) {
        shutdown(fd,2);
        return(-1);
      }
      *(buf+status)='\0';
      strip(buf);
      fprintf(stdout,"-> %s\n",buf);
      if ((strncmp(buf,"ERR PASS",8)==0)||
          (strncmp(buf,"ERR XPASS",9)==0)||
          (strncmp(buf,"ERR NEWPASS",11)==0)||
          (strncmp(buf,"ERR ID",6)==0)||
          (strncmp(buf,"ERR CLOSE",9)==0)) {
        shutdown(fd,2);
        return(-1);
      }
      else if (strncmp(buf,"OK QUIT",7)==0) {
        shutdown(fd,2);
        return(0);
      }
    }
  }
}

int init(void)
{
  char buf[BUFLEN];
  static struct sockaddr_in serv_addr;
  int status;
  int len=sizeof(struct sockaddr_in);

  if (strlen(Id)==0) {
    fprintf(stderr,"No ID!\n");
    return(-1);
  }
  else if ((Email==NULL)||(strlen(Email)==0)) {
    fprintf(stderr,"No Email!\n");
    return(-1);
  }
  else if ((Pass==NULL)||(strlen(Pass)==0)) {
    fprintf(stderr,"No Password!\n");
    return(-1);
  }
  else if ((Ip==NULL)||(strlen(Ip)==0)) {
    fprintf(stderr,"No IP!\n");
    return(-1);
  }
  if (debug>1) {
    fprintf(stdout,"Initialising Connection...\n");
  }
  snprintf(buf,BUFLEN,"ID %s",Id);
  if (debug) {
    fprintf(stdout,"(Sent) %s\n",buf);
  }
  sendto(fd,buf,strlen(buf),0,NULL,0);
  status=recvfrom(fd,buf,BUFLEN,0,0,NULL);
  if (status==-1) {
    shutdown(fd,2);
    return(-1);
  }
  *(buf+status)='\0';
  if (debug) {
    fprintf(stdout,"(Received) %s",buf);
  }
  if (strncmp(buf,"ERR",3)==0) {
    shutdown(fd,2);
    return(-1);
  }

  snprintf(buf,BUFLEN,"EMAIL %s",Email);
  if (debug) {
    fprintf(stdout,"(Sent) %s\n",buf);
  }
  sendto(fd,buf,strlen(buf),0,NULL,0);
  status=recvfrom(fd,buf,BUFLEN,0,0,NULL);
  if (status==-1) {
    shutdown(fd,2);
    return(-1);
  }
  *(buf+status)='\0';
  if (debug) {
    fprintf(stdout,"(Received) %s",buf);
  }
  
  snprintf(buf,BUFLEN,"IP %s",Ip);
  if (debug) {
    fprintf(stdout,"(Sent) %s\n",buf);
  }
  sendto(fd,buf,strlen(buf),0,NULL,0);
  status=recvfrom(fd,buf,BUFLEN,0,0,NULL);
  if (status==-1) {
    shutdown(fd,2);
    return(-1);
  }
  *(buf+status)='\0';
  if (debug) {
    fprintf(stdout,"(Received) %s",buf);
  }

  snprintf(buf,BUFLEN,"HOST %s",Host);
  if (debug) {
    fprintf(stdout,"(Sent) %s\n",buf);
  }
  sendto(fd,buf,strlen(buf),0,NULL,0);
  status=recvfrom(fd,buf,BUFLEN,0,0,NULL);
  if (status==-1) {
    shutdown(fd,2);
    return(-1);
  }
  *(buf+status)='\0';
  if (debug) {
    fprintf(stdout,"(Received) %s",buf);
  }

  if (XPass==1) {
    status=getsockname(fd,(struct sockaddr *)&serv_addr,&(int)len);
    if (status==-1) {
      XPass=0;
    }
    else {
      snprintf(buf,BUFLEN,"XPASS %s",(char *)xcrypt(Pass,serv_addr.sin_addr.s_addr));
    }
  }
  if (XPass==0) {
    snprintf(buf,BUFLEN,"PASS %s",Pass);
  }
  if (debug) {
    fprintf(stdout,"(Sent) %s\n",buf);
  }
  sendto(fd,buf,strlen(buf),0,NULL,0);
  status=recvfrom(fd,buf,BUFLEN,0,0,NULL);
  if (status==-1) {
    shutdown(fd,2);
    return(-1);
  }
  *(buf+status)='\0';
  if (debug) {
    fprintf(stdout,"(Received) %s",buf);
  }
  if (strncmp(buf,"ERR",3)==0) {
    return(-1);
  }

  if (Timeout) {
    snprintf(buf,BUFLEN,"TIMEOUT %d",Timeout);
    if (debug) {
      fprintf(stdout,"(Sent) %s\n",buf);
    }
    sendto(fd,buf,strlen(buf),0,NULL,0);
    status=recvfrom(fd,buf,BUFLEN,0,0,NULL);
    if (status==-1) {
      shutdown(fd,2);
      return(-1);
    }
    *(buf+status)='\0';
    if (debug) {
      fprintf(stdout,"(Received) %s",buf);
    }
  }
}

int search(void)
{
  int i;
  char buf[BUFLEN];
  int status;

  snprintf(buf,BUFLEN,"ID %s",Id);
  if (debug) {
    fprintf(stdout,"(Sent) %s\n",buf);
  }
  sendto(fd,buf,strlen(buf),0,NULL,0);
  status=recvfrom(fd,buf,BUFLEN,0,0,NULL);
  if (status==-1) {
    shutdown(fd,2);
    return(-1);
  }
  *(buf+status)='\0';
  if (debug) {
    fprintf(stdout,"(Received) %s",buf);
  }
  if (strncmp(buf,"ERR",3)==0) {
    return(-1);
  }

  for(i=1;i<=count;i++) {
    snprintf(buf,BUFLEN,"EMAIL %s",List[i]);
    if (debug) {
      fprintf(stdout,"(Sent) %s\n",buf);
    }
    sendto(fd,buf,strlen(buf),0,NULL,0);
    status=recvfrom(fd,buf,BUFLEN,0,0,NULL);
    if (status==-1) {
      shutdown(fd,2);
      return(-1);
    }
    *(buf+status)='\0';
    if (debug) {
      fprintf(stdout,"(Received) %s",buf);
    }

    fprintf(stdout,"Email    : %s\n",List[i]);

    strcpy(buf,"QHOST");
    if (debug) {
      fprintf(stdout,"(Sent) %s\n",buf);
    }
    sendto(fd,buf,strlen(buf),0,NULL,0);
    status=recvfrom(fd,buf,BUFLEN,0,0,NULL);
    if (status==-1) {
      shutdown(fd,2);
      return(-1);
    }
    *(buf+status)='\0';
    if (debug) {
      fprintf(stdout,"(Received) %s",buf);
    }
    if (strncmp(buf,"OK",2)==0) {
      fprintf(stdout," Host    : %s",buf+9);
    }

    strcpy(buf,"QIP");
    if (debug) {
      fprintf(stdout,"(Sent) %s\n",buf);
    }
    sendto(fd,buf,strlen(buf),0,NULL,0);
    status=recvfrom(fd,buf,BUFLEN,0,0,NULL);
    if (status==-1) {
      shutdown(fd,2);
      return(-1);
    }
    *(buf+status)='\0';
    if (debug) {
      fprintf(stdout,"(Received) %s",buf);
    }
    if (strncmp(buf,"OK",2)==0) {
      fprintf(stdout," IP      : %s",buf+7);
    }

    strcpy(buf,"QTIME");
    if (debug) {
      fprintf(stdout,"(Sent) %s\n",buf);
    }
    sendto(fd,buf,strlen(buf),0,NULL,0);
    status=recvfrom(fd,buf,BUFLEN,0,0,NULL);
    if (status==-1) {
      shutdown(fd,2);
      return(-1);
    }
    *(buf+status)='\0';
    if (debug) {
      fprintf(stdout,"(Received) %s",buf);
    }
    if (strncmp(buf,"OK",2)==0) {
      fprintf(stdout," Time    : %s",buf+9);
    }

    strcpy(buf,"QTIMEOUT");
    if (debug) {
      fprintf(stdout,"(Sent) %s\n",buf);
    }
    sendto(fd,buf,strlen(buf),0,NULL,0);
    status=recvfrom(fd,buf,BUFLEN,0,0,NULL);
    if (status==-1) {
      shutdown(fd,2);
      return(-1);
    }
    *(buf+status)='\0';
    if (debug) {
      fprintf(stdout,"(Received) %s",buf);
    }
    if (strncmp(buf,"OK",2)==0) {
      fprintf(stdout," Timeout : %s",buf+12);
    }
  }
}

int dynamic(int mode) {
  char * email_hold;
  char * host_hold;
  char * ip_hold;
  char buf[BUFLEN];
  int status;

  Id="3";
  if (Dmf) {
    if (init()==-1) {
      return(-1);
    }
    if (mode) {
      snprintf(buf,BUFLEN,"MXHOST","");
    }
    else {
      snprintf(buf,BUFLEN,"MXHOST %s",DMF_HOST);
    }
    if (debug) {
      fprintf(stdout,"(Sent) %s\n",buf);
    }
    sendto(fd,buf,strlen(buf),0,NULL,0);
    status=recvfrom(fd,buf,BUFLEN,0,0,NULL);
    if (status==-1) {
      shutdown(fd,2);
      return(-1);
    }
    *(buf+status)='\0';
    if (debug) {
      fprintf(stdout,"(Received) %s",buf);
    }
    if (mode) {
      snprintf(buf,BUFLEN,"MXIP","");
    }
    else {
      snprintf(buf,BUFLEN,"MXIP %s",DMF_IP);
    }
    if (debug) {
      fprintf(stdout,"(Sent) %s\n",buf);
    }
    sendto(fd,buf,strlen(buf),0,NULL,0);
    status=recvfrom(fd,buf,BUFLEN,0,0,NULL);
    if (status==-1) {
      shutdown(fd,2);
      return(-1);
    }
    *(buf+status)='\0';
    if (debug) {
      fprintf(stdout,"(Received) %s",buf);
    }
    snprintf(buf,BUFLEN,"MXUPDATE","");
    if (debug) {
      fprintf(stdout,"(Sent) %s\n",buf);
    }
    sendto(fd,buf,strlen(buf),0,NULL,0);
    status=recvfrom(fd,buf,BUFLEN,0,0,NULL);
    if (status==-1) {
      shutdown(fd,2);
      return(-1);
    }
    *(buf+status)='\0';
    if (debug) {
      fprintf(stdout,"(Received) %s",buf);
    }
  }
  if (Dhttp) {
    email_hold=Email;
    host_hold=Host;
    ip_hold=Ip;
    sprintf(buf,"webmaster@%s",Host);
    Email=strdup(buf);
    sprintf(buf,"www.%s",Host);
    Host=strdup(buf);
    if (mode) {
      sprintf(buf,"%s",Ip);
    }
    else {
      sprintf(buf,"%s",DHTTP_IP);
    }
    Ip=strdup(buf);
    if (init()==-1) {
      return(-1);
    }
    snprintf(buf,BUFLEN,"UPDATE","");
    if (debug) {
      fprintf(stdout,"(Sent) %s\n",buf);
    }
    sendto(fd,buf,strlen(buf),0,NULL,0);
    status=recvfrom(fd,buf,BUFLEN,0,0,NULL);
    if (status==-1) {
      shutdown(fd,2);
      return(-1);
    }
    *(buf+status)='\0';
    if (debug) {
      fprintf(stdout,"(Received) %s",buf);
    }
    Email=email_hold;
    Host=host_hold;
    Ip=ip_hold;
  }
  Id="1";
}

int ReadConfig(void)
{
  char buf[BUFLEN];
  char * key;
  char * ptr;
  FILE * fp;
  char * Get_ip="";
  int i;
  int status;
  struct in_addr addr;
  
  if (debug>1) {
    fprintf(stdout,"Reading Conf...\n");
  }
  fp=fopen(Conf,"r");
  if (fp!=NULL) {
    while(1) {
      fgets(buf,BUFLEN,fp);
      if (feof(fp)) {
        fclose(fp);
        break;
      }
      strip(buf);
      if (strncmp(buf,";",1)==0) {
        continue;
      }
      key=strdup(buf);
      strtoupper(key);
      if ((ptr=strchr(key,' '))!=NULL) {
        *ptr='\0';
      }
      if ((ptr=strchr(key,'\t'))!=NULL) {
        *ptr='\0';
      }
      if ((ptr=strchr(key,'='))!=NULL) {
        *ptr='\0';
      }
      ptr=strchr(buf,'=');
      if (ptr==NULL) {
        continue;
      }
      ptr++;
      while ((*ptr)==' ') {
        ptr++;
      }
      if (strcmp(key,"ID")==0) {
        Id=strdup(ptr);
        if (debug>2) {
          fprintf(stdout,"ID      : %s\n",ptr);
        }
      }
      else if (strcmp(key,"IP")==0) {
        if (strlen(Ip)==0) {
          Ip=strdup(ptr);
        }
        if ((debug>2)&&(strlen(Ip))) {
          fprintf(stdout,"IP      : %s\n",ptr);
        }
      }
      else if (strcmp(key,"HOST")==0) {
        Host=strdup(ptr);
        if (debug>2) {
          fprintf(stdout,"Host    : %s\n",ptr);
         }
      }
      else if (strcmp(key,"PASS")==0) {
        Pass=strdup(ptr);
        if (debug>2) {
          fprintf(stdout,"Pass    : ******\n");
        }
      }
      else if (strcmp(key,"XPASS")==0) {
        Pass=strdup(ptr);
        XPass=1;
        if (debug>2) {
          fprintf(stdout,"XPass   : ******\n");
        }
      }
      else if (strcmp(key,"PORT")==0) {
        pcount++;
        Port[pcount]=atoi(ptr);
        if (debug>2) {
          fprintf(stdout,"Port    : %s\n",ptr);
        }
      }
      else if (strcmp(key,"EMAIL")==0) {
        Email=strdup(ptr);
        if (debug>2) {
          fprintf(stdout,"Email   : %s\n",ptr);
        }
      }
      else if (strcmp(key,"SERVER")==0) {
        scount++;
        Server[scount]=strdup(ptr);
        if (debug>2) {
          fprintf(stdout,"Server  : %s\n",ptr);
        }
      }
      else if (strcmp(key,"LIST")==0) {
        count++;
        if (count<=MAXLIST) {
          List[count]=strdup(ptr);
        }
        if (debug>2) {
          fprintf(stdout,"List    : %s\n",ptr);
        }
      }
      else if (strcmp(key,"GET_IP")==0) {
        Get_ip=strdup(ptr);
        if (debug>2) {
          fprintf(stdout,"Get_IP  : %s\n",ptr);
        }
      }
      else if ((debug==0)&&(strcmp(key,"DEBUG")==0)) {
        debug=atoi(ptr);
        if (debug>2) {
          fprintf(stdout,"Debug   : %d\n",debug);
        }
      }
      else if (strcmp(key,"TIMEOUT")==0) {
        Timeout=atoi(ptr);
        if (debug>2) {
          fprintf(stdout,"Timeout : %d\n",Timeout);
        }
      }
      else if (strncmp(key,mode,strlen(mode))==0) {
        Script=strdup(ptr);
        if (debug>2) {
          fprintf(stdout,"Script  : %s\n",ptr);
        }
      }
      else if (strcmp(key,"DAEMON")==0) {
        Daemon=atoi(ptr);
        if (debug>2) {
          fprintf(stdout,"Daemon  : %d\n",Daemon);
        }
      }
      else if (strcmp(key,"FLAGS")==0) {
        Flags=strdup(ptr);
        if (debug>2) {
          fprintf(stdout,"Flags   : %d\n",Flags);
        }
      }
      else if (strcmp(key,"DMF")==0) {
        Dmf=atoi(ptr);
        if (debug>2) {
          fprintf(stdout,"DMF     : %d\n",Dmf);
        }
      }
      else if (strcmp(key,"DHTTP")==0) {
        Dhttp=atoi(ptr);
        if (debug>2) {
          fprintf(stdout,"DHTTP   : %d\n",Dhttp);
        }
      }
      fflush(stdout);
    }
  }

  if (debug>1) {
    fprintf(stdout,"Retrieving IP...\n");
  }
  if ((strcmp(mode,"IRFIND")==0)||(strcmp(mode,"IROFF")==0)) {
    Ip="203.120.99.5";
  }
  else if ((strlen(Get_ip))&&(strlen(Ip)==0)&&(strcmp(Get_ip,"ASK")!=0)) {
#ifndef _WIN32
      snprintf(buf,BUFLEN,"%s > %s",Get_ip,Tmpfile);
      status=system(buf);
      if (status==0) {
        fp=fopen(Tmpfile,"r");
        if (fp==NULL) {
          Ip="";
        }
        else {
          *buf='\0';
          fgets(buf,BUFLEN,fp);
          fclose(fp);
          unlink(Tmpfile);
          Ip=strdup(buf);
          strip(Ip);
        }
      }
      else {
        Ip="";
      }
#else
      sprintf(buf,"winipcfg -batch");
      system(buf);
      sleep(1);
      fp=fopen("winipcfg.out","r");
      if (fp==NULL) {
        Ip="";
      }
      else {
        for (i=1;i<=6;i++) {
          fgets(buf,BUFLEN,fp);
        }
        fclose(fp);
        unlink("winipcfg.out");
        Ip=strdup(buf+31);
        strip(Ip);
      }
#endif
  }
  if (strlen(Ip)) {
#if !(defined(_WIN32)||(__EMX__)||(sun))
    if (strcmp(Ip,IP_AUTO)!=0) {
      status=inet_aton(Ip,&addr);
      if (status==0) {
        fprintf(stderr,"Invalid IP, using AUTO instead!\n");
        Ip=IP_AUTO;
      }
    }
#endif
    if (debug>2) {
      fprintf(stdout,"IP      : %s\n",Ip);
    }
  }
  else if ((strcmp(mode,"IRFIND")!=0)&&(strcmp(mode,"IROFF")!=0)\
           &&((strcmp(Get_ip,"ASK")==0)||(strlen(Ip)==0))) {
    fprintf(stdout,"Enter IP: ");
    fgets(buf,BUFLEN,stdin);
    Ip=strdup(buf);
    strip(Ip);
  }
  if (debug>1) {
    fprintf(stdout,"End Conf...\n");
  }
}

#if defined(_WIN32)
int snprintf(char * str,int maxlen,const char * format,va_list ap)
{
  sprintf(str,format,ap);
}
#elif defined(__osf__)||(__hpux)||(NO_SNPRINTF)
int snprintf(char * str,int maxlen,const char * format,...)
{
  va_list ap;
  int len;
  char * ptr;
  int count=0;

  ptr=strdup(format);
  va_start(ap,format);
  do {
    ptr=strchr(ptr,'%');
    if (ptr!=NULL) {
      ptr++;
      count++;
    }
  } while(ptr);
  if (count==1) {
    sprintf(str,format,va_arg(ap,char *));
  }
  else if (count==2) {
    sprintf(str,format,va_arg(ap,char *),va_arg(ap,char *));
  }
  va_end(ap);
  *(str+maxlen)='\0';
  free(ptr);
}
#endif

#ifdef _WIN32
long gethostid(void)
{
  int s;
  int status;
  struct sockaddr_in local;
  struct sockaddr_in remote;
  int size=sizeof(struct sockaddr);

  local.sin_addr.s_addr=INADDR_ANY;
  s=socket(PF_INET,SOCK_DGRAM,0);
  if (s!=-1) {
    remote.sin_family=AF_INET;
    remote.sin_port=htons(IPPORT_ECHO);
    remote.sin_addr.s_addr=inet_addr("203.120.99.120");
    status=connect(s,(struct sockaddr *)&remote,sizeof(struct sockaddr));
    if (status!=-1) {
      getsockname(s,(struct sockaddr *)&local,(int *)&size);
      close(s);
    }
  }
  return(local.sin_addr.s_addr);
}
#endif
