/* gnome-napster, a GNOME Napster client.
 * Copyright (C) 1999 Evan Martin <eeyem@u.washington.edu>
 */
#include <gnome.h>
#include "util.h"

int g_quiet = 0;

void qprintf(char *fmt, ...) {
	va_list ap;

	if (!g_quiet) {
		va_start(ap, fmt);
		vprintf(fmt, ap);
		va_end(ap);
	}
}

char *short_path(char *path, int depth) {

	/* start at the end of the path string */
	char *p = path+strlen(path)-1;
	
	/* and move towards the beginning */
	for ( ; p >= path; p--) {
	
		/* look for path seperators allong the way */
		if ((*p == '\\') || (*p == '/'))  {
			depth--; /* we've found one */
			if (depth < 0) break; /* leave if that is as deep as
								   * we are supposed to be */
		}
	}
	if (p > path) 
		p++; /* skip the leftmost path separator */
	if (p == 0 || p < path) p = path; /* watch out for weird condititions */
	return p;
}

GtkWidget* hbox_new_with_label(gchar *text, GtkWidget *widg, gboolean exp) {
	GtkWidget *hbox;
	hbox = gtk_hbox_new(FALSE, 10);
	gtk_box_pack_start(GTK_BOX(hbox), gtk_label_new(text), FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), widg, exp, exp, 0);
	return hbox;
}

gchar *pixmap_file(char *fn) {
	char *file;
	if ((file = gnome_pixmap_file(fn)) == NULL) {
		/* if it's not in the pixmap path, try a relative path.
		 * it works for the animator, at least! */
		file = g_strconcat("../pixmaps/", fn, NULL);
	} 
	return file;
}

GList* g_list_free_all(GList *list) {

	GList *temp=list;

	/* clean up all of our data first */
	while (temp != NULL) {
		/* free the data */
		g_free(temp->data);
		temp->data = NULL;
		
		/* onto the next */
		temp = g_list_next(temp);
	}
	
	/* now let's get rid of the list */
	g_list_free(list);
	return NULL; /* the list is gone... kind of a useless response, but... */
}


