/* gnome-napster, a GNOME Napster client.
 * Copyright (C) 1999 Evan Martin <eeyem@u.washington.edu>
 */
#include <unistd.h>
#include <stdio.h>
#include <sys/param.h>
#include <gnome.h>
#include "ui.h"
#include "gconfig.h"
#include "util.h"
#include "config.h"

static struct poptOption options[] = {
	{ "quiet", 'q', POPT_ARG_NONE, &g_quiet, 0,  
		"Suppress all output.  (Not recommended!)", NULL },
	{ NULL, 0, 0, NULL, 0, NULL, NULL }
};

int main(int argc, char*argv[]) {
	if (!g_thread_supported()) g_thread_init(NULL);

	gnome_init_with_popt_table(PACKAGE, VERSION, argc, argv, options, 0, NULL);
	/* read configuration */

	/* chroot? */
	/*if (chdir("dl/") < 0) {
		perror("chdir"); return -1;
	}*/
	/*if (chroot(".") < 0) {
		perror("chroot"); return -1;
	}*/
	/*getcwd(buf, PATH_MAX);
	printf("cwd: %s\n", buf);*/
	
	ui_run();       /* start ui */

	return 0;
}
