#include <includes.h>
#include <darxite.h>

int main(int argc, char *argv[], char *envp[])
{
    struct hostent *he;
    int byname;
    char host[1024];
    char buf[1024];

    fgets(buf, sizeof(buf), stdin); byname = buf[0] - '0';
    fgets(host, sizeof(host), stdin);

    strip(host);
    if(byname) he = gethostbyname(host);
    else {
	struct in_addr addr;

	inet_aton(host, &addr);
	he = gethostbyaddr((char *)&addr, sizeof(struct in_addr), AF_INET);
    }

    if(!he) {
	/* Failed; pass "F" */
	printf("F\n");
	return 0;
    }

    /* Pass "S" (success) */
    printf("S\n");

    /* Pass the result to fd */
    if(byname == 1) {
	char buf[1024];
	strcpy(buf, inet_ntoa(* (struct in_addr *)he->h_addr));

	/* return first ip */
	printf("%s\n", buf);
    } else if(byname == 2) {
	/* return all ips, separated by spaces */
	int num=0;
	while(he->h_addr_list[num]) {
	    if(num != 0) printf(" ");
	    printf("%s", inet_ntoa(*(struct in_addr *) he->h_addr_list[num]));
	    num++;
	}
	printf("\n");
    } else  {
	printf("%s\n", he->h_name);
    }

    return 0;
}

