/* Gnome Darxite Control
 * 
 * Author: Manuel Clos
 * 
 * Darxite Author: Ashley Montanaro
 *
 * See AUTHORS for emails.
 */

#include <libgnorba/gnorba.h>

#include "global.h"
#include "functions.h"
#include "control-page.h"
#include "batch-status.h"
#include "file-log.h"
#include "main.h"
#include "../common/dnd.h"
#include "../common/callbacks.h"
#include "../common/connect.h"

/*Toolbar enum*/
enum {
	ICON_NEW,
		SEP_1,
	ICON_PLAY,
	ICON_PAUSE,
	ICON_CANCEL,
		SEP_2,
	ICON_REGET,
		SEP_3,
	ICON_CLEAR,
		SEP_4,
	ICON_EXIT
};



void update_menus(void);

/* Functions */

gint
file_status_cb(gpointer pointer_data)
{
	if (clists)
	   SendToDaemon("FastFileStatus\n");

        return TRUE;
}

gint
clist_event (GtkCList *clist, GdkEvent *event, gpointer data)
{
    GdkEventButton *button_event = (GdkEventButton *)event;
        
    if (!(event->type == GDK_BUTTON_PRESS && button_event->button == 3))
        return FALSE;

    switch(CONTROL_PAGE(mdi->active_child)->type){
	case CONTROL_PAGE_BATCH:	
//		    gtk_menu_popup (GTK_MENU(batch_popup_menu), NULL, NULL, NULL, NULL, 3, 
//	                    button_event->time);
			break;
	case CONTROL_PAGE_FILELOG:
//		    gtk_menu_popup (GTK_MENU(filelog_popup_menu), NULL,
//					NULL, NULL, NULL, 3, button_event->time);
			break;
	default:	break;
	}

    return TRUE;
}

void configure_connection()
{
	char buffer[256];
	GtkWidget *clist;
	
	if (clists)
	{
	   clist = GTK_WIDGET(clists->data);
	   if (clist)
	   {
	      gtk_clist_freeze(GTK_CLIST(clist));
	      {
	         FileInfo *download;
	         gint row;
		
	         batch = g_list_first(batch);
	         while (batch)
	         {
	            download = batch->data;
	            batch = g_list_remove(batch, download);
	            row = gtk_clist_find_row_from_data(GTK_CLIST(clist), download);
	            gtk_clist_remove(GTK_CLIST(clist), row);
	            free_FileInfo(download);
	         }
	      }
	      gtk_clist_thaw(GTK_CLIST(clist));
	   }
	}

	//Client<-->Daemon configuration
	input_response = gdk_input_add(fd, GDK_INPUT_READ, get_data, NULL);

	sprintf(buffer, "NotifyOnEvent Exit\n");
	write(fd, buffer, strlen(buffer));
	sprintf(buffer, "NotifyOnEvent Error\n");
	write(fd, buffer, strlen(buffer));
	sprintf(buffer, "NotifyOnEvent ConfigChange\n");
	write(fd, buffer, strlen(buffer));
	sprintf(buffer, "NotifyOnEvent NewFile\n");
	write(fd, buffer, strlen(buffer));
	sprintf(buffer, "NotifyOnEvent FileCompletion\n");
	write(fd, buffer, strlen(buffer));
	sprintf(buffer, "NotifyOnEvent Redirection\n");
	write(fd, buffer, strlen(buffer));

	if (local)
	{
	   if (file_count_local)
	   {
	      file_count_cb(NULL);
	      file_count_timeout = gtk_timeout_add
			(file_count_timeout_local*1000, file_count_cb, NULL);
	   }
	   if (file_status_local)
	   {
	      sprintf(buffer, "FileStatus\n");
	      write(fd, buffer, strlen(buffer));
	      first_file_status_sent = TRUE;

	      file_status_timeout = gtk_timeout_add
	      		(file_status_timeout_local*1000, file_status_cb, NULL);
	   }	
	}
	else
	{
	   if (file_count_remote)
	   {
	      file_count_cb(NULL);
	      file_count_timeout = gtk_timeout_add
			(file_count_timeout_remote*1000, file_count_cb, NULL);
	   }
	   if (file_status_remote)
	   {
	      sprintf(buffer, "FileStatus\n");
	      write(fd, buffer, strlen(buffer));
	      first_file_status_sent = TRUE;
	      
	      file_status_timeout = gtk_timeout_add
	      		(file_status_timeout_remote*1000, file_status_cb, NULL);
	   }	
	}

	//Application PostConnection configuration...
	update_menus();
	gtk_progress_set_format_string(GTK_PROGRESS(control->progress),
		"Connected");
//        gtk_label_set(GTK_LABEL(control->files_label), "Trans. ? of ? files");
}

void configure_disconnection()
// should be ...isconnection(gboolean *is_a_crash);
{
//FIXME: This is for safety, should be removed when we don't use SIGPIPE.
	connected = FALSE;

	gtk_timeout_remove(file_count_timeout);
	file_count_timeout = 0;
	gtk_timeout_remove(file_status_timeout);
	file_status_timeout = 0;

	update_menus();
	gtk_progress_set_format_string(GTK_PROGRESS(control->progress),
		"Not connected");
        gtk_label_set(GTK_LABEL(control->files_label), "Trans. - of - files");
	first_file_status_sent = FALSE;


//FIXME: If it's a crash check the "retry_connection_{local,remote}" values ...
}

gint 
retry_connect_cb(gpointer data)
{
	if (connected)
	   return FALSE;

	if (local)
	{
	   //connect to local daemon!
	   if (local_connection())
	   {
	      gnome_app_flash(mdi->active_window,
	            "Can't connect to the daemon! Is the daemon running?");
	      if (auto_start_local)
	      {
	         //Autostart the local daemon
	         if(do_autostart_daemon())
	            local_connection();
	      }
	   }
	}
	else //local == FALSE ==> remote :)
	{
	   //connect to remote daemon!
	      if (remote_connection(host, port, password))
	         gnome_app_flash(mdi->active_window,
	            "Remote daemon connection failed!");
	}

	if (!connected)
	   return TRUE;
	else
	   return FALSE;
}

void update_menus(void)
{
        GnomeApp *app;
        GnomeUIInfo *uiinfo_menubar;
        GnomeUIInfo *uiinfo_file;
        GnomeUIInfo *uiinfo_programs;
        GnomeUIInfo *uiinfo_child;
        GnomeUIInfo *uiinfo_toolbar;

        if(mdi->active_view == NULL)
                return;

        app = gnome_mdi_get_app_from_view(mdi->active_view);
 
        uiinfo_menubar = gnome_mdi_get_menubar_info(app);
        uiinfo_file = (GnomeUIInfo *)uiinfo_menubar[0].moreinfo;
        uiinfo_programs = (GnomeUIInfo *)uiinfo_menubar[2].moreinfo;
        uiinfo_child = gnome_mdi_get_child_menu_info(app);
        uiinfo_child = (GnomeUIInfo *)uiinfo_child[0].moreinfo;
        uiinfo_toolbar = gnome_mdi_get_toolbar_info(app);
	
	if (connected)
	{
	   GSList *children;
	   gint i;
	   
	   if (batch)
	   {
	      children = (GSList *)GTK_MENU_SHELL(batch_popup_menu)->children;
	      for (i = 0; i < 9; i++)
	      {
	         gtk_widget_set_sensitive (GTK_WIDGET(children->data), TRUE);
	         children = children->next;
	      }
	   }

	   if (flogs)
	   {
	      children = (GSList *)GTK_MENU_SHELL(filelog_popup_menu)->children;
	      for (i = 0; i < 3; i++)
	      {
	         gtk_widget_set_sensitive (GTK_WIDGET(children->data), TRUE);
	         children = children->next;
	      }
	   }

	   gtk_widget_hide(pixmap_red);	
	   gtk_widget_show(pixmap_green);

//	   gtk_widget_set_sensitive(uiinfo_file[2].widget, TRUE);
//	   gtk_widget_set_sensitive(uiinfo_file[3].widget, TRUE);
//	   gtk_widget_set_sensitive(uiinfo_file[4].widget, TRUE);

	   gtk_widget_hide(uiinfo_programs[6].widget);	
	   gtk_widget_show(uiinfo_programs[7].widget);
	   
//	   gtk_widget_set_sensitive(uiinfo_toolbar[ICON_NEW].widget, TRUE);
	   gtk_widget_set_sensitive(uiinfo_toolbar[ICON_REGET].widget, TRUE);

	   if (CONTROL_PAGE(mdi->active_child)->type == CONTROL_PAGE_BATCH)
	   {
	      gtk_widget_set_sensitive(uiinfo_child[0].widget, TRUE);
	      gtk_widget_set_sensitive(uiinfo_child[1].widget, TRUE);
	      gtk_widget_set_sensitive(uiinfo_child[2].widget, TRUE);
	      gtk_widget_set_sensitive(uiinfo_child[4].widget, TRUE);
	      gtk_widget_set_sensitive(uiinfo_child[6].widget, TRUE);

	      gtk_widget_set_sensitive(uiinfo_toolbar[ICON_PLAY].widget, TRUE);
	      gtk_widget_set_sensitive(uiinfo_toolbar[ICON_PAUSE].widget, TRUE);
	      gtk_widget_set_sensitive(uiinfo_toolbar[ICON_CANCEL].widget, TRUE);
	      gtk_widget_set_sensitive(uiinfo_toolbar[ICON_CLEAR].widget, TRUE);
	   }
	   if (CONTROL_PAGE(mdi->active_child)->type == CONTROL_PAGE_FILELOG)
	   {
	      gtk_widget_set_sensitive(uiinfo_toolbar[ICON_PLAY].widget, FALSE);
	      gtk_widget_set_sensitive(uiinfo_toolbar[ICON_PAUSE].widget, FALSE);
	      gtk_widget_set_sensitive(uiinfo_toolbar[ICON_CANCEL].widget, FALSE);
	      gtk_widget_set_sensitive(uiinfo_toolbar[ICON_CLEAR].widget, FALSE);
	   }
	}
	else	   
	{
	   GSList *children;
	   gint i;

	   if (batch)
	   {	   
	      children = (GSList *)GTK_MENU_SHELL(batch_popup_menu)->children;
	      for (i = 0; i < 9; i++)
	      {
	         gtk_widget_set_sensitive (GTK_WIDGET(children->data), FALSE);
	         children = children->next;
	      }
	   }
	   
	   if (flogs)
	   {
	      children = (GSList *)GTK_MENU_SHELL(filelog_popup_menu)->children;
	      for (i = 0; i < 3; i++)
	      {
	         gtk_widget_set_sensitive (GTK_WIDGET(children->data), FALSE);
	         children = children->next;
	      }
	   }
	   
	   gtk_widget_hide(pixmap_green);	
	   gtk_widget_show(pixmap_red);

//	   gtk_widget_set_sensitive(uiinfo_file[2].widget, FALSE);
//	   gtk_widget_set_sensitive(uiinfo_file[3].widget, FALSE);
//	   gtk_widget_set_sensitive(uiinfo_file[4].widget, FALSE);

	   gtk_widget_hide(uiinfo_programs[7].widget);
	   gtk_widget_show(uiinfo_programs[6].widget);	

	   if (CONTROL_PAGE(mdi->active_child)->type == CONTROL_PAGE_BATCH)
	   {
	      gtk_widget_set_sensitive(uiinfo_child[0].widget, FALSE);
	      gtk_widget_set_sensitive(uiinfo_child[1].widget, FALSE);
	      gtk_widget_set_sensitive(uiinfo_child[2].widget, FALSE);
	      gtk_widget_set_sensitive(uiinfo_child[4].widget, FALSE);
	      gtk_widget_set_sensitive(uiinfo_child[6].widget, FALSE);
	   }
	   if (CONTROL_PAGE(mdi->active_child)->type == CONTROL_PAGE_FILELOG)
	   {
	      gtk_widget_set_sensitive(uiinfo_child[0].widget, FALSE);
	   }

	   /*Set Toolbar*/
//	   gtk_widget_set_sensitive(uiinfo_toolbar[ICON_NEW].widget, FALSE);
	   gtk_widget_set_sensitive(uiinfo_toolbar[ICON_PLAY].widget, FALSE);
	   gtk_widget_set_sensitive(uiinfo_toolbar[ICON_PAUSE].widget, FALSE);
	   gtk_widget_set_sensitive(uiinfo_toolbar[ICON_CANCEL].widget, FALSE);
	   gtk_widget_set_sensitive(uiinfo_toolbar[ICON_REGET].widget, FALSE);
	   gtk_widget_set_sensitive(uiinfo_toolbar[ICON_CLEAR].widget, FALSE);
	}
}

FileInfo *
FindIdInBatch(gchar *id)
{
	GList *glist;
	FileInfo *pointer = {NULL};
	gboolean found;

	glist = g_list_first(batch);
	found = FALSE;

	while ((glist) && (!found))
	{
	   pointer = glist->data;
	   if (strcmp(pointer->id, id) == 0)
	   {
	      found = TRUE;
	   }
	   else
	      glist = glist->next;
	}
	
	if (!found)
	   return NULL;
	else
	   return pointer;
}

gint UpdateBatchWithLine(gchar *line)
{
	gchar id[4];
	gint current_size,		total_size;
	gint current_time,		rate_overall;
	gchar activity[256],	activ[256];
	gint percent;

	GList *glist;
	FileInfo *pointer = {NULL};
	gboolean found;

	DX_ParseFastFileStatus(line, id, &current_size, &total_size,
					&current_time, &rate_overall, activ);

	sprintf(activity, "%s", DX_ActivityFromCode(activ));
	
	if (total_size > 0)
	   percent = ((current_size*100)/total_size);
	else
	   percent = 0;
	
	glist = g_list_first(batch);
	found = FALSE;

	while ((glist) && (!found))
	{
	   pointer = glist->data;
	   if (strcmp(pointer->id, id) == 0)
	   {
	      if (strcmp(pointer->activity, activity) == 0)
	      {
	         pointer->activity_ch = FALSE;
	      }
	      else
	      {
	         g_free(pointer->activity);
	         pointer->activity = strdup(activity);
	         pointer->activity_ch = TRUE;
	      }
	      if (pointer->percent == percent)
	      {
	         pointer->percent_ch = FALSE;
	      }
	      else
	      {
	         pointer->percent = percent;
	         g_free(pointer->percent_str);
	         pointer->percent_str = g_strdup_printf("%i %%", percent);
	         pointer->percent_ch = TRUE;
	      }
	      if (pointer->current_size == current_size)
	      {
	         pointer->current_size_ch = FALSE;
	      }
	      else
	      {
	         pointer->current_size = current_size;
	         pointer->current_size_ch = TRUE;
	      }
	      if (pointer->total_size == total_size)
	      {
	         pointer->total_size_ch = FALSE;
	      }
	      else
	      {
	         pointer->total_size = total_size;
	         pointer->total_size_ch = TRUE;
	      }
	      if (pointer->rate_overall == rate_overall)
	      {
	         pointer->rate_overall_ch = FALSE;
	      }
	      else
	      {
	         pointer->rate_overall = rate_overall;
	         pointer->rate_overall_ch = TRUE;
	      }
	      if (pointer->current_time == current_time)
	      {
	         pointer->current_time_ch = FALSE;
	      }
	      else
	      {
	         pointer->current_time = current_time;
	         pointer->current_time_ch = TRUE;
	      }
	      found = TRUE;
	   }
	   else
	      glist = glist->next;
	}
	
	if (!found)
	   return 1;
	
	return 0;
}

FileInfo *
LineToFileInfo(gchar *line)
{
	gchar protocol[5],		server[256];
	gchar path[256],		local_path[256];
	gchar activity[256],	id[4]; // added by Ashley

	FileInfo *data = {NULL};

	data = (FileInfo *) g_malloc (sizeof (FileInfo));

	DX_ParseFileStatus(line, protocol, server, sizeof(server), path,
		sizeof(path), local_path, sizeof(local_path),
		&data->current_size,	&data->total_size,
		&data->current_time,	&data->rate_overall,
		activity, sizeof(activity), id); // added by Ashley
	
	data->id = g_strdup(id);
	data->type = NORMAL;
	data->filename = g_strdup(strrchr(path,'/')+1);
	data->local_path = g_strdup(local_path);
	data->activity = g_strdup(activity);
	if (data->total_size > 0)
	   data->percent = ((data->current_size*100)/data->total_size);
	else
	   data->percent = 0;
//This should not be used... remove in the next optimization pass :)
	data->percent_str = g_strdup_printf("%i %%", data->percent);

	data->url = g_strdup_printf("%s://%s%s", protocol, server, path);

	return data;
}

void get_data (gpointer func_data, gint source, GdkInputCondition condition)
{
        char buffer[8192];
	gint timeout = 10;
	gint code = -1;
	gint rc;

        char *line;

	gboolean fast_file_status_end = FALSE;
	gboolean file_status_end = FALSE;

//do {
    // we need to set the buffer to 0 to make sure it ends with a null char
//    memset(buffer, 0, sizeof(buffer));

	//And here we go..	
	rc = DX_GetResponse(fd, buffer, sizeof(buffer) - 1, timeout);

#ifdef DEBUG_MESSAGES
	g_print("DX_GetResponse: rc = %i\n", rc);
#endif

#ifdef EXTRA_DEBUG_MESSAGES
        g_print("%s", buffer);
#endif

	if ((rc == DX_LIB_TIMEOUT) || (rc == DX_LIB_ERROR))
	   return;
	else if (rc == DX_LIB_DISCONNECTED)
	   DisconnectClient();

    /* instead of simply reading the response and processing it, we need to
       read it line-by-line, because we may have more than one response,
       eg. if there are a lot of responses very quickly - Ashley */
	line = strtok(buffer, "\n");
        while (line)
        {
           sscanf(line, "%i", &code);

//FILE_COUNT
	   if (code == DX_FILE_COUNT)
	   {
	      gint transfer_size;
	      gint total_batch_size;
	      gint transfer_count;
	      gint total_count;
	      gfloat total_percent = 0;
	      gchar aux_buffer[64];
		
//FIXME: What about these... umh...
	gboolean inverse_percent = TRUE;
	gboolean show_percent_button = TRUE;
	gboolean show_files_button = TRUE;
		
	      DX_ParseFileCount(line+4, &transfer_size, &total_batch_size,
	   					&transfer_count, &total_count);

	      if (show_percent_button)
	      {
	         if (total_count)
	         {
//FIXME: Don't do this every time ...
		    gtk_progress_set_format_string(GTK_PROGRESS(control->progress),
		    	"%p%%");		    

                    if (total_batch_size > 0)
                    {
                       total_percent = ((float)transfer_size)/
                       					(float)total_batch_size;
                    }
		    else
		    {
                       total_percent = 1;
                    }
                    if (inverse_percent)
                       total_percent = 1 - total_percent;
	         }
	         else
	         {
	            gtk_progress_set_format_string(GTK_PROGRESS(control->progress),
		    	"No files in batch");		    
		 }
		 
	         if (connected)
		    gnome_appbar_set_progress(GNOME_APPBAR(control->appbar), total_percent);

	      }
	      if (show_files_button && connected)
	      {
	         sprintf(aux_buffer, " Trans. %i of %i files ",
	            transfer_count, total_count);
	         gtk_label_set(GTK_LABEL(control->files_label), aux_buffer);
	      }
	      
	   }
//FAST_FILE_STATUS
	   else if (code == DX_FAST_FILE_STATUS)
	   {
              if (strncmp(line + 3, "-", 1) != 0)
                 fast_file_status_end = TRUE;
              else
                 fast_file_status_end = FALSE;

	      if (UpdateBatchWithLine(line+4))
	      {
#ifdef DEBUG_MESSAGES	      
	         show_warning(line);
#endif
	      }
	      if (fast_file_status_end)
	      {
	         update_batch_s(NULL, NULL);
	         fast_file_status_end = FALSE;
	      }
	   }
//FILE_COMPLETION_EVENT
	   else if (code == DX_FILE_COMPLETION)
	   {
	      FileInfo *new_fi = {NULL};
	      FileInfo *old_fi = {NULL};

	      new_fi = LineToFileInfo(line + 4);

	      if (strcmp(new_fi->activity, "File complete") == 0)
	         new_fi->type = COMPLETION;
	      else
	         if (strcmp(new_fi->activity, "File cancelled") == 0)
	      	    new_fi->type = CANCELATION;
	      	 else
	      	    new_fi->type = ERROR;

	      old_fi = FindIdInBatch(new_fi->id);
	      
	      if (old_fi == NULL)
	      {
	         //add
	         update_batch_s(new_fi, NULL);
	      }
	      else
	      {
	         //modify
	         batch = g_list_remove(batch, old_fi);
	         update_batch_s(new_fi, old_fi);
	         free_FileInfo(old_fi);
	      }
	      
	      update_flogs(new_fi);
	      completions = g_list_prepend(completions, new_fi);
	   }
//FILE_STATUS & NEW_FILE_EVENT
	   else if ((code == DX_FILE_STATUS)
	   	 || (code == DX_NEW_FILE_EVENT))
           {
	      FileInfo *new_fi = {NULL};
	
              if (strncmp(line + 3, "-", 1) != 0)
                 file_status_end = TRUE;
              else
                 file_status_end = FALSE;

	      //This function also alocates the memory.
	      new_fi = LineToFileInfo(line + 4);

	      new_fi->new = TRUE;
	      batch = g_list_prepend(batch, new_fi);

	      if (file_status_end)
	      {
	         update_batch_s(NULL, NULL);
	         file_status_end = FALSE;
	      }
           }
//OK
           else if (code == DX_OK)
           {
#ifdef DEBUG_MESSAGES
                g_print("OK: %s\n", line);
#endif
           }
//ERROR
           else if (code == DX_ERROR)
           {
#ifdef DEBUG_MESSAGES
                g_print("Error: \"%s\"\n", line);
#endif
           }
//CONFIG_RELOADED
           else if (code == DX_CONFIG_RELOADED)
           {
                DX_ReadConfigFiles();
	        gnome_app_flash(mdi->active_window, "Darxite configuration has changed, reloading configuration.");

#ifdef DEBUG_MESSAGES
                g_print("Received Event Code %i - Configuration has been"
                        " reloaded!\n", code);
#endif
           }
//EXIT_EVENT
           else if (code == DX_EXIT_EVENT)
           {
#ifdef DEBUG_MESSAGES
	      g_print("Received Event Code %i - EXIT Event!\n", code);
              g_print("%s\n", line);
#endif
	      DisconnectClient();
           }
//ERROR_EVENT
           else if (code == DX_ERROR_EVENT)
           {
#ifdef DEBUG_MESSAGES
              g_print("Received Event Code %i - Error Event!\n", code);
              g_print("%s\n", line);
#endif
	      show_warning(line);
	   }

	   line = strtok(NULL, "\n");
	}

//} while (rc == DX_LIB_MORE_DATA);

}

gint
remove_child_handler(GnomeMDI *mdi, GnomeMDIChild *child)
{
//FIXME: Should I free the only used by this child memory (FileInfo pointers) ???
        switch (CONTROL_PAGE (child)->type) {
        case CONTROL_PAGE_BATCH:
	     clists = g_list_remove(clists, CONTROL_PAGE(child)->main_widget);
	     FileStatus -= 1;
             break;
        case CONTROL_PAGE_FILELOG:
	     flogs = g_list_remove(flogs, CONTROL_PAGE(child)->main_widget);
             break;
        }
//FIXME: g_free the memory of the "unused" pointers.

	return TRUE; /* TRUE = remove the child */
}

/* Callback functions */

void
about_cb (GtkWidget *widget, void *data)
{
	const gchar *authors[] = {"Manuel Clos", NULL};
	GtkWidget *href;
	GtkWidget *about;

	about = gnome_about_new ( _("Gnome Darxite Control"), GDCONTROL_VERSION,
        		/* copyright notice */
                        "",
                        authors,
                        /* another comments */
                        _("If you find some bug/question mail me at:\n"
			  "mclos000@correu.udg.es"),
                        NULL);
	href = gnome_href_new("http://darxite.cjb.net/", NULL);
        gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(about)->vbox), href,
        	FALSE, FALSE, 0);
        gtk_widget_show(href);
	gtk_widget_show (about);
}

void
cleanup_cb(GnomeMDI *mdi)
{
        /* on destruction of GnomeMDI we call gtk_main_quit(), since we have opened
           no windows on our own and therefore our GUI is gone.
        */
        gtk_main_quit();
}

void
quit_cb (GtkWidget *widget)
{
        /* when the user wants to quit we try to remove all children and if we
           succeed destroy the MDI. if TRUE was passed as the second (force)
           argument, remove_child signal wouldn't be emmited.
        */
	shutdown_app = TRUE;
	save_configuration();
        if(gnome_mdi_remove_all(mdi, FALSE))
                gtk_object_destroy(GTK_OBJECT(mdi));
}

void select_all_cb(void)
{
	GtkWidget *clist;

	if ( (CONTROL_PAGE(mdi->active_child)->type == CONTROL_PAGE_BATCH)
	   ||(CONTROL_PAGE(mdi->active_child)->type == CONTROL_PAGE_FILELOG))
	{
	clist = CONTROL_PAGE(mdi->active_child)->main_widget;
	if ((GTK_CLIST(clist)->rows))
		gtk_clist_select_all((GtkCList *)clist);
	}
}

void help_cb(void)
{

}

void run_darxite_monitor_cb()
{
//Show how to run it until I can start it through corba. 
	GtkWidget *message_box;
	gchar *message;

	message = "To start darxite-monitor, right click\n
		on the panel, select add applet, then\n
		select Network, and finaly select darxite-monitor.\n
		It will restart automatically in next sessions.";
	message_box = gnome_message_box_new(_(message),
		GNOME_MESSAGE_BOX_INFO, GNOME_STOCK_BUTTON_CLOSE,NULL); 
	gtk_widget_show(message_box);

}

/*
void run_darxite_monitor_cb()
{
  CORBA_ORB orb;
  
  GoadServer *serv;
  char *iorstr;  
  CORBA_Environment ev;
  CORBA_Object obj;

  CORBA_exception_init(&ev);

  serv->type = GOAD_SERVER_EXE;
  serv->flags = GOAD_ACTIVATE_NEW_ONLY;
  serv->server_id = "darxite-monitor_applet";

  obj = goad_server_activate(serv, 0, NULL);

  if(!CORBA_Object_is_nil(obj, &ev)) {
    iorstr = CORBA_ORB_object_to_string(orb, obj, &ev);
    g_print("%s\n", iorstr);
    CORBA_free(iorstr);
  }
  CORBA_exception_free(&ev);
}
*/

void remote_connection_cb()
{
	remote_dialog(GTK_WINDOW(control->app));
}

