/*
 * Copyright (C) 1998  Mark Baysinger (mbaysing@ucsd.edu)
 * Copyright (C) 1998,1999  Ross Combs (rocombs@cs.nmsu.edu)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef INCLUDED_EVENTLOG_TYPES
#define INCLUDED_EVENTLOG_TYPES

typedef enum
{
    eventlog_level_none =0,
    eventlog_level_debug=1,
    eventlog_level_info =2,
    eventlog_level_warn =4,
    eventlog_level_error=8
} t_eventlog_level;

#endif


#ifndef JUST_NEED_TYPES
#ifndef INCLUDED_EVENTLOG_PROTOS
#define INCLUDED_EVENTLOG_PROTOS

#include <stdio.h>

extern void eventlog_set(FILE * fp);
extern int eventlog_open(char const * filename);
extern void eventlog_clear_level(void);
extern int eventlog_add_level(char const * levelname);
extern int eventlog_del_level(char const * levelname);
#ifdef __GNUC__
/* the __attribute__ will give proper format warnings with -Wall */
extern void eventlog(t_eventlog_level level, char const * module, char const * fmt, ...) __attribute__ ((format (printf, 3, 4)));
#else
extern void eventlog(t_eventlog_level level, char const * module, char const * fmt, ...);
#endif

#endif
#endif
