/* Written by Dan Heller and Paula Ferguson.  
 * Copyright 1994, O'Reilly & Associates, Inc.
 * Permission to use, copy, and modify this program without
 * restriction is hereby granted, as long as this copyright
 * notice appears in each copy of the program source code.
 * This program is freely distributable without licensing fees and
 * is provided without guarantee or warrantee expressed or implied.
 * This program is -not- in the public domain.
 */

/* Modified by Rob Clark on Nov 26, 1995
 *   Changes made: reorginization of code, and addition choice of initial 
 *   option menu selection
 *                    - moved the creation of cascade buttion for 
 *                      option and pulldown menu till after the 
 *                      items in the menu are created... this way 
 *                      I can specify a widget (item in menu) to 
 *                      be the inital choice for option menues!
 *                    - Added argument (int)initial to 
 *                      facilitate choice of initial choice.
 *                    - modified the for loop which adds menu items.
 *                      If the menu item number (0,1,2,..) of the
 *                      menu item being created corresponds to the
 *                      (int)initial specified by the caller of 
 *                      the function, then make note of the widget 
 *                      id of menu item so we can use it to set 
 *                      initial menu choice.  If the menu item 
 *                      created is the first menu item, make note
 *                      of it's widget id, in case (int)initial 
 *                      specified by user is bigger than the number 
 *                      of menu items.
 *                    - Added check to see if initial_choice was set
 *                      equal to a widget id.  If (int)initial is 
 *                      bigger than number of menu items, then  set
 *                      initial_choice to = first menu item's widget
 *                      id, to prevent bad things from happening.
 */

#ifndef _BUILDMENU_H
#define _BUILDMENU_H

#include <Xm/PushB.h>
#include <Xm/Separator.h>

#include "config.h"


typedef struct _menu_item {
    char        *label;         /* the label for the item             */
    WidgetClass *wclass;        /* pushbutton, label, separator...    */
    char         mnemonic;      /* mnemonic; NULL if none             */
    char        *accelerator;   /* accelerator; NULL if none          */
    char        *accel_text;    /* to be converted to compound string */
    Boolean      sensitive;     /* is menu entry greyed out?          */
#if __cplusplus
    void       (*callback)(_WidgetRec *, void *, void *);
#else
    void       (*callback)();   /* routine to call; NULL if none      */
#endif
    XtPointer    callback_data; /* client_data for callback()         */
    struct _menu_item *subitems; /* pullright menu items, if not NULL */
    Widget       widget;        /* ignored on input, returned value   */
} MenuItem;

/* Build popup, option and pulldown menus, depending on the menu_type.
 * It may be XmMENU_PULLDOWN, XmMENU_OPTION or  XmMENU_POPUP.  Pulldowns
 * return the CascadeButton that pops up the menu.  Popups return the menu.
 * Option menus are created, but the RowColumn that acts as the option
 * "area" is returned unmanaged. (The user must manage it.)
 * Pulldown menus are built from cascade buttons, so this function
 * also builds pullright menus.  The function also adds the right
 * callback for PushButton or ToggleButton menu items.
 */
Widget BuildMenu( Widget parent, int menu_type, char *menu_title, 
		 char menu_mnemonic, Boolean tear_off, int initial, 
		  MenuItem *items);

#endif
