/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */

#include "gstalker.h"
#include <dirent.h>


/**************************************************************************************
This routine verifies a selection was made before we edit the group.
*************************************************************************************/
void
edit_group_check()
{
  gchar *text;
  gint tint;
  GList *list;
  GtkWidget *dialog;
  extern GtkWidget *workwith_groups_clist, *main_window;
  extern gchar *mess_nothing_selected;


  list = GTK_CLIST (workwith_groups_clist)->selection;
  if (!list)
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_selected);
	gtk_widget_show(dialog);
  }
  else
  {
	tint = (int) list->data;
      	gtk_clist_get_text (GTK_CLIST (workwith_groups_clist), tint, 0, &text);
  	ok_edit_group(text);
  }
}
/*************************************************************************************/
void 
rename_group ()
{
  gint tint;
  GList *list = NULL;
  GString *tstring;
  gchar *tstringp;
  GtkWidget *dialog;
  extern GtkWidget *workwith_groups_clist, *main_window;
  extern gchar *mess_nothing_selected, *label_new_group_name;



  list = GTK_CLIST (workwith_groups_clist)->selection;
  if (!list)
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_selected);
	gtk_widget_show(dialog);
	return;
  }

  tstring = g_string_new(NULL);
  tint = (int) list->data;
  gtk_clist_get_text (GTK_CLIST (workwith_groups_clist), tint, 0, &tstringp);
     
  g_string_sprintf (tstring, "%s %s.", label_new_group_name, tstringp);
  
  dialog = gnome_request_dialog (FALSE,
  						 tstring->str,
  						 NULL,
  						 50,
  						 ok_rename_group,
  						 NULL,
  						 NULL);
  gtk_widget_show (dialog);
  g_string_free(tstring, TRUE);
}
/******************************************************************************************/
void 
edit_group_insert_button ()
{
  GtkWidget *dialog;
  gint tint=0, tint2=0;
  GList *list = NULL, *list2 = NULL;
  GString *tstring, *tstring2, *tstring3, *tstring4;
  gchar *line[4], *text;
  extern GtkWidget *edit_group_clist, *edit_group_clist2, *main_window;
  extern gchar *mess_nothing_selected_edit;


  list2 = GTK_CLIST (edit_group_clist2)->selection;
  list = GTK_CLIST (edit_group_clist)->selection;
  if (list)
  {
	gtk_clist_freeze (GTK_CLIST (edit_group_clist2));
	tstring = g_string_new(NULL);
	tstring2 = g_string_new(NULL);
	tstring3 = g_string_new(NULL);
	tstring4 = g_string_new(NULL);
	while (list)
	{
	      tint = (int) list->data;
	      if (list2)
  	      	     tint2 = (int) list2->data;
	      gtk_clist_get_text (GTK_CLIST (edit_group_clist), tint, 0, &text);
	      g_string_assign (tstring, text);
	      line[0] = tstring->str;
	      gtk_clist_get_text (GTK_CLIST (edit_group_clist), tint, 1, &text);
	      g_string_assign (tstring2, text);
	      line[1] = tstring2->str;
	      gtk_clist_get_text (GTK_CLIST (edit_group_clist), tint, 2, &text);
	      g_string_assign (tstring3, text);
	      line[2] = tstring3->str;
	      gtk_clist_get_text (GTK_CLIST (edit_group_clist), tint, 3, &text);
	      g_string_assign (tstring4, text);
	      g_string_append (tstring4, "\n");
	      line[3] = tstring4->str;
	      if (list2)
	      		gtk_clist_insert (GTK_CLIST (edit_group_clist2), tint2, line);
	      else
	      		gtk_clist_append (GTK_CLIST (edit_group_clist2), line);
	      list = list->next;
	}
	gtk_clist_thaw (GTK_CLIST (edit_group_clist2));
	g_string_free(tstring, TRUE);
	g_string_free(tstring2, TRUE);
	g_string_free(tstring3, TRUE);
	g_string_free(tstring4, TRUE);
  }
  else
  {
	dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_selected_edit);
	gtk_widget_show(dialog);
	return;
  }
}
/******************************************************************************************/
void 
edit_group_delete_button ()
{
  GtkWidget *dialog;
  gint tint;
  GList *list = NULL;
  extern GtkWidget *edit_group_clist2, *main_window;
  extern gchar *mess_nothing_selected;



  list = GTK_CLIST (edit_group_clist2)->selection;
  if (list)
    {
      gtk_clist_freeze (GTK_CLIST (edit_group_clist2));
      tint = (int) list->data;
      gtk_clist_remove (GTK_CLIST (edit_group_clist2), tint);
      gtk_clist_thaw (GTK_CLIST (edit_group_clist2));
    }
  else
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_selected);
	gtk_widget_show(dialog);
	return;
  }
}
/****************************************************************************************/
void 
ok_edit_group (gchar *data)
{
  FILE *infile;
  gchar buffer[1024];
  GtkWidget *vbox, *ok_button, *cancel_button, *insert_button, *delete_button;
  GtkWidget *hbox, *swindow, *swindow2;
  extern GtkWidget *edit_group_window,*edit_group_clist,*edit_group_clist2,*workwith_groups_window;
  extern GString *edit_groupfilename;
  extern struct record config;
  extern gchar *label_start, *label_end, *label_symbol, *label_name, *label_edit_group;
  extern gchar *label_insert, *label_delete, *label_ok, *label_cancel;



  if (edit_group_window)
    return;
    
  g_string_assign (edit_groupfilename, data);

  edit_group_window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_signal_connect (GTK_OBJECT (edit_group_window), "destroy",
		GTK_SIGNAL_FUNC (gtk_widget_destroyed), &edit_group_window);
  gtk_window_position (GTK_WINDOW (edit_group_window), GTK_WIN_POS_CENTER);
  sprintf (buffer, "%s - [%s]", label_edit_group, data);
  gtk_window_set_title (GTK_WINDOW (edit_group_window), buffer);
  gtk_widget_set_usize (GTK_WIDGET (edit_group_window), 0, 0);

  if (workwith_groups_window)
    gtk_widget_destroy (workwith_groups_window);

  hbox = gtk_hbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (hbox), 10);
  gtk_container_add (GTK_CONTAINER (edit_group_window), hbox);
  gtk_widget_show (hbox);
  
  swindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_box_pack_start (GTK_BOX (hbox), swindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swindow),
  				 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show(swindow);

  edit_group_clist = gtk_clist_new_with_titles (4, NULL);
  gtk_clist_set_column_width (GTK_CLIST (edit_group_clist), 0, 70);
  gtk_clist_set_column_width (GTK_CLIST (edit_group_clist), 1, 200);
  gtk_clist_set_column_width (GTK_CLIST (edit_group_clist), 2, 70);
  gtk_clist_set_column_width (GTK_CLIST (edit_group_clist), 3, 70);
  gtk_clist_set_selection_mode (GTK_CLIST (edit_group_clist), GTK_SELECTION_MULTIPLE);
  gtk_container_add (GTK_CONTAINER (swindow), edit_group_clist);
  gtk_container_border_width (GTK_CONTAINER (edit_group_clist), 0);
  gtk_widget_set_usize (GTK_WIDGET (edit_group_clist), 200, 0);
  gtk_clist_set_column_title (GTK_CLIST(edit_group_clist), 0, label_symbol);
  gtk_clist_set_column_title (GTK_CLIST(edit_group_clist), 1, label_name);
  gtk_clist_set_column_title (GTK_CLIST(edit_group_clist), 2, label_start);
  gtk_clist_set_column_title (GTK_CLIST(edit_group_clist), 3, label_end);
  gtk_clist_column_titles_show (GTK_CLIST(edit_group_clist));
  gtk_widget_show (edit_group_clist);

  vbox = gtk_vbutton_box_new ();
  gtk_container_border_width (GTK_CONTAINER (vbox), 0);
  gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, TRUE, 0);
  gtk_vbutton_box_set_spacing_default (5);
  gtk_vbutton_box_set_layout_default (GTK_BUTTONBOX_START);
  gtk_widget_show (vbox);
  
  swindow2 = gtk_scrolled_window_new(NULL, NULL);
  gtk_box_pack_start (GTK_BOX (hbox), swindow2, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swindow),
  				 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show(swindow2);

  edit_group_clist2 = gtk_clist_new_with_titles (4, NULL);
  gtk_clist_set_column_width (GTK_CLIST (edit_group_clist2), 0, 70);
  gtk_clist_set_column_width (GTK_CLIST (edit_group_clist2), 1, 200);
  gtk_clist_set_column_width (GTK_CLIST (edit_group_clist2), 2, 70);
  gtk_clist_set_column_width (GTK_CLIST (edit_group_clist2), 3, 70);
  gtk_clist_set_selection_mode (GTK_CLIST (edit_group_clist2), GTK_SELECTION_MULTIPLE);
  gtk_container_add (GTK_CONTAINER (swindow2), edit_group_clist2);
  gtk_container_border_width (GTK_CONTAINER (edit_group_clist2), 0);
  gtk_widget_set_usize (GTK_WIDGET (edit_group_clist2), 200, 0);
  gtk_clist_set_column_title (GTK_CLIST(edit_group_clist2), 0, label_symbol);
  gtk_clist_set_column_title (GTK_CLIST(edit_group_clist2), 1, label_name);
  gtk_clist_set_column_title (GTK_CLIST(edit_group_clist2), 2, label_start);
  gtk_clist_set_column_title (GTK_CLIST(edit_group_clist2), 3, label_end);
  gtk_clist_column_titles_show (GTK_CLIST(edit_group_clist2));
  gtk_widget_show (edit_group_clist2);

  insert_button = gtk_button_new_with_label (label_insert);
  gtk_box_pack_start (GTK_BOX (vbox), insert_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (insert_button), "clicked",
		      GTK_SIGNAL_FUNC (edit_group_insert_button), NULL);
  gtk_widget_show (insert_button);

  delete_button = gtk_button_new_with_label (label_delete);
  gtk_box_pack_start (GTK_BOX (vbox), delete_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (delete_button), "clicked",
		      GTK_SIGNAL_FUNC (edit_group_delete_button), NULL);
  gtk_widget_show (delete_button);

  ok_button = gtk_button_new_with_label (label_ok);
  gtk_box_pack_start (GTK_BOX (vbox), ok_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
		      GTK_SIGNAL_FUNC (edit_group_ok_button), NULL);
  gtk_widget_show (ok_button);

  cancel_button = gtk_button_new_with_label (label_cancel);
  gtk_box_pack_start (GTK_BOX (vbox), cancel_button, FALSE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (edit_group_window));
  gtk_widget_show (cancel_button);

  strcpy (buffer, config.grouppath);
  strcat (buffer, edit_groupfilename->str);
  infile = fopen (buffer, "r");
  if (infile)
    {
      while (fgets (buffer, sizeof(buffer), infile) != NULL)
      {
      	  g_strstrip(buffer);
	  display_chart_details (buffer, edit_group_clist2);
      }
      fclose(infile);
    }
  
  show_chart_list (edit_group_clist);
  gtk_widget_show (edit_group_window);
}
/*****************************************************************************************/
void 
ok_delete_group ()
{
  GtkWidget *dialog;
  GList *list = NULL;
  gint tint;
  gchar *tstringp;
  GString *tstring;
  extern GtkWidget *workwith_groups_clist, *main_window;
  extern gchar *mess_nothing_selected, *mess_delete_confirm;


  list = GTK_CLIST (workwith_groups_clist)->selection;
  if (!list)
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_selected);
	gtk_widget_show(dialog);
	return;
  }

  tstring = g_string_new(NULL);

  tint = (int) list->data;
  gtk_clist_get_text (GTK_CLIST (workwith_groups_clist), tint, 0, &tstringp);
  g_string_sprintf (tstring, "%s %s ?", mess_delete_confirm, tstringp);
  
  dialog = gnome_app_question_modal (GNOME_APP(main_window),
  							 tstring->str,
  							 yes_delete_group,
  							 (gpointer) tstringp);
  gtk_widget_show(dialog);
  g_string_free(tstring, TRUE);
}
/***********************************************************************************/
void 
new_group ()
{
  GtkWidget *dialog;
  extern gchar *label_new_group;
  
  dialog = gnome_request_dialog (FALSE,
  						 label_new_group,
  						 NULL,
  						 50,
  						 create_group,
  						 NULL,
  						 NULL);
  gtk_widget_show (dialog);
}
/****************************************************************************************/
void 
workwith_groups ()
{
  struct dirent **dirlist;
  gint tint, tint2;
  gchar *line[1];
  GString *tstring;
  GtkWidget *vbox, *hbox, *open_button, *edit_button, *rename_button, *delete_button;
  GtkWidget *cancel_button, *swindow, *dialog, *new_button;
  extern GtkWidget *workwith_groups_window, *workwith_groups_clist, *workwith_charts_window;
  extern GtkWidget *main_window;
  extern gchar *mess_group_missing, *label_workwith_groups, *label_group_name, *label_new;
  extern gchar *label_edit, *label_rename, *label_open, *label_delete, *label_cancel;
  extern struct record config;



  if (workwith_groups_window)
    return;
  if (workwith_charts_window)
    return;

  tstring = g_string_new(NULL);

  workwith_groups_window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_signal_connect (GTK_OBJECT (workwith_groups_window), "destroy",
	   GTK_SIGNAL_FUNC (gtk_widget_destroyed), &workwith_groups_window);
  gtk_window_position (GTK_WINDOW (workwith_groups_window), GTK_WIN_POS_CENTER);
  gtk_window_set_title (GTK_WINDOW (workwith_groups_window), label_workwith_groups);
  gtk_container_border_width (GTK_CONTAINER (workwith_groups_window), 0);

  hbox = gtk_hbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (hbox), 10);
  gtk_container_add (GTK_CONTAINER (workwith_groups_window), hbox);
  gtk_widget_show (hbox);
  
  swindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_box_pack_start (GTK_BOX (hbox), swindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swindow),
  				 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show(swindow);

  workwith_groups_clist = gtk_clist_new_with_titles (1, NULL);
  gtk_clist_set_selection_mode (GTK_CLIST (workwith_groups_clist), GTK_SELECTION_SINGLE);
  gtk_container_add (GTK_CONTAINER (swindow), workwith_groups_clist);
  gtk_container_border_width (GTK_CONTAINER (workwith_groups_clist), 0);
  gtk_widget_set_usize (GTK_WIDGET (workwith_groups_clist), 350, 0);
  gtk_clist_set_column_title (GTK_CLIST(workwith_groups_clist), 0, label_group_name);
  gtk_clist_column_titles_show (GTK_CLIST(workwith_groups_clist));
  gtk_widget_show (workwith_groups_clist);

  vbox = gtk_vbutton_box_new ();
  gtk_container_border_width (GTK_CONTAINER (vbox), 0);
  gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, TRUE, 0);
  gtk_vbutton_box_set_spacing_default (5);
  gtk_vbutton_box_set_layout_default (GTK_BUTTONBOX_START);
  gtk_widget_show (vbox);
  
  new_button = gtk_button_new_with_label (label_new);
  gtk_box_pack_start (GTK_BOX (vbox), new_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (new_button), "clicked",
		      GTK_SIGNAL_FUNC (new_group), NULL);
  gtk_widget_show (new_button);

  open_button = gtk_button_new_with_label (label_open);
  gtk_box_pack_start (GTK_BOX (vbox), open_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (open_button), "clicked",
		      GTK_SIGNAL_FUNC (load_group), NULL);
  gtk_widget_show (open_button);

  edit_button = gtk_button_new_with_label (label_edit);
  gtk_box_pack_start (GTK_BOX (vbox), edit_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (edit_button), "clicked",
		      GTK_SIGNAL_FUNC (edit_group_check), NULL);
  gtk_widget_show (edit_button);

  rename_button = gtk_button_new_with_label (label_rename);
  gtk_box_pack_start (GTK_BOX (vbox), rename_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (rename_button), "clicked",
		      GTK_SIGNAL_FUNC (rename_group), NULL);
  gtk_widget_show (rename_button);

  delete_button = gtk_button_new_with_label (label_delete);
  gtk_box_pack_start (GTK_BOX (vbox), delete_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (delete_button), "clicked",
		      GTK_SIGNAL_FUNC (ok_delete_group), NULL);
  gtk_widget_show (delete_button);

  cancel_button = gtk_button_new_with_label (label_cancel);
  gtk_box_pack_start (GTK_BOX (vbox), cancel_button, FALSE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (workwith_groups_window));
  gtk_widget_show (cancel_button);

  gtk_clist_freeze (GTK_CLIST (workwith_groups_clist));
  tint = scandir (config.grouppath, &dirlist, NULL, alphasort);
  if (tint < 0)
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_group_missing);
	gtk_widget_show(dialog);
	return;
  }

  tint2 = tint;
  for (tint = 2; tint < tint2; tint++)
    {
      g_string_assign (tstring, dirlist[tint]->d_name);
      line[0] = tstring->str;
      gtk_clist_append (GTK_CLIST (workwith_groups_clist), line);
    }
  gtk_clist_thaw (GTK_CLIST (workwith_groups_clist));

  gtk_widget_show (workwith_groups_window);
  g_string_free(tstring, TRUE);
}
/****************************************************************************************
This routine is called only on gstalker startup and attempts to load the previously
active group.
****************************************************************************************/
void 
load_first_group ()
{
  GString *tstring;
  gint tint;
  FILE *infile;
  gchar buffer[1024], *text;
  extern gint open_file_flag;
  extern struct record config;
  extern GPtrArray *group_array;


  if (strlen (config.groupfile) < 1)
  	return;
  	
  /* build the path */
  strcpy (buffer, config.grouppath);
  strcat (buffer, config.groupfile);
  
  if (group_array)
  	g_ptr_array_free (group_array, TRUE);
  group_array = g_ptr_array_new();
  
  infile = fopen(buffer, "r");
  if (! infile)
  	return;
  	
  tint = -1;
  while (fgets (buffer, sizeof(buffer), infile) != NULL)
  {
  	g_strstrip (buffer);
  	tstring = g_string_new (NULL);
  	g_string_assign (tstring, buffer);
  	g_ptr_array_add (group_array, (gpointer) tstring->str);
  	tint++;
  }
  fclose(infile);
  
  /* display the chart */
  config.group_pointer = 0;
  config.group_pointer_size = tint;
  text = g_ptr_array_index (group_array, 0);
  load_file (text);
  
  /* update the open file flag */
  open_file_flag = 0;
}
/****************************************************************************************
Loads a group into memory by creating a list of charts from a group file and
displays the first chart in the group.
******************************************************************************************/
void 
load_group ()
{
  GString *tstring;
  FILE *infile;
  gchar buffer[1024], *text;
  gint tint = 0;
  GList *list = NULL;
  GtkWidget *dialog;
  extern GtkWidget *workwith_groups_clist, *workwith_groups_window, *main_window;
  extern gchar *mess_nothing_selected;
  extern gint open_file_flag;
  extern struct record config;
  extern GPtrArray *group_array;


  /* check if a group has been selected */
  list = GTK_CLIST (workwith_groups_clist)->selection;
  if (!list)
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_selected);
	gtk_widget_show(dialog);
	return;
  }

  /* get the clist position of selection */
  tint = (int) list->data;
  
  /* get the text */
  gtk_clist_get_text (GTK_CLIST (workwith_groups_clist), tint, 0, &text);
  
  /* build the path */
  strcpy (buffer, config.grouppath);
  strcat (buffer, text);
  
  /* save the active group */
  strcpy (config.groupfile, text);
  
  /* update the open file flag */
  open_file_flag = 0;
  
  if (group_array)
  	g_ptr_array_free (group_array, TRUE);
  group_array = g_ptr_array_new();
  infile = fopen(buffer, "r");
  tint = -1;
  while (fgets (buffer, sizeof(buffer), infile) != NULL)
  {
  	g_strstrip (buffer);
  	tstring = g_string_new (NULL);
  	g_string_assign (tstring, buffer);
  	g_ptr_array_add (group_array, (gpointer) tstring->str);
  	tint++;
  }
  fclose(infile);
  
  /* display the chart */
  config.group_pointer = 0;
  config.group_pointer_size = tint;
  text = g_ptr_array_index (group_array, 0);
  load_file (text);
  
  /* close the dialog */
  if (workwith_groups_window)
    gtk_widget_destroy (workwith_groups_window);
}
/****************************************************************************************
Create a new group file.
****************************************************************************************/
void 
create_group (gchar *data)
{
  GtkWidget *dialog;
  FILE *infile;
  GString *tstring;
  extern gchar *mess_already_exists, *mess_nothing_entered;
  extern GtkWidget *main_window;
  extern struct record config;


  if (data == 0)
  	return;
  else
  {
  	if (strlen(data) < 1)
  	{
  		dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_entered);
		gtk_widget_show(dialog);
		return;
	}
  }
  
  tstring = g_string_new(NULL);
  
  /* build the path */
  g_string_sprintf (tstring, "%s%s", config.grouppath , data);
      
  /* check if it already exists */
  infile = fopen (tstring->str, "r");
  if (infile)
  {
	fclose (infile);
	dialog = gnome_app_error (GNOME_APP(main_window), mess_already_exists);
	gtk_widget_show(dialog);
	g_string_free(tstring, TRUE);
	return;
  }
  else
  {
        /* launch the group editor dialog */
        g_string_free(tstring, TRUE);
	ok_edit_group (data);
  }
}
/*************************************************************************************
Delete a group file
************************************************************************************/
void 
yes_delete_group (gint reply, gchar *data)
{
  gint tint;
  GList *list = NULL;
  GString *tstring;
  extern GtkWidget *workwith_groups_clist;
  extern struct record config;
  extern gint open_file_flag;


  if (reply)
  	return;
  	
  tstring = g_string_new(NULL);

  /* get the selection row number from the clist box */
  list = GTK_CLIST (workwith_groups_clist)->selection;
  tint = (int) list->data;
  
  /* build the path */
  g_string_sprintf (tstring, "%s%s", config.grouppath , data);
  
  /* check if we are going to delete an active group file */
  if (!strcmp (data, config.groupfile))
  {
  	config.groupfile[0] = 0;
  	open_file_flag = 1;
  }
    
  /* delete it */
  unlink (tstring->str);
  
  /* update the clist box */
  gtk_clist_remove (GTK_CLIST (workwith_groups_clist), tint);
  g_string_free(tstring, TRUE);
}
/*************************************************************************************
Renames an existing group file name and closes the dialog
**************************************************************************************/
void 
ok_rename_group (gchar *data, gint reply)
{
  GtkWidget *dialog;
  GList *list;
  struct dirent **dirlist;
  gint tint=0, tint2;
  FILE *infile;
  GString *oldname, *newname, *tstring, *tstring2;
  gchar *tstringp, *line[1];
  extern GtkWidget *workwith_groups_clist, *main_window;
  extern gchar *mess_nothing_entered, *mess_invalid_entry, *mess_already_exists;
  extern struct record config;

  
  if (data == 0)
  	return;
  else
  {
  	/* check if there is any data */
  	if (strlen(data) < 1)
  	{
  		dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_entered);
		gtk_widget_show(dialog);
		return;
  	}
  }
  
  tstring = g_string_new(NULL);
  g_string_assign (tstring, data);
  g_strstrip(tstring->str);
  
  /* check for invalid characters */
  if ((strchr(tstring->str, '/')) || (strchr(tstring->str, '.')))
  {
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_invalid_entry);
	gtk_widget_show(dialog);
	g_string_free(tstring, TRUE);
	return;
  }

  newname = g_string_new(NULL);

  
  /* build the path for newname and check for an existing group */
  g_string_sprintf (newname, "%s%s", config.grouppath , tstring->str);
  infile = fopen (newname->str, "r");
  if (infile)
    {
      fclose (infile);
      dialog = gnome_app_error (GNOME_APP(main_window), mess_already_exists);
      gtk_widget_show(dialog);
      g_string_free(tstring, TRUE);
      g_string_free(newname, TRUE);
      return;
    }
    
  oldname = g_string_new(NULL);
    
  /* build the path for the old name */
  list = GTK_CLIST (workwith_groups_clist)->selection;
  tint = (int) list->data;
  gtk_clist_get_text (GTK_CLIST (workwith_groups_clist), tint, 0, &tstringp);
  g_string_sprintf (oldname, "%s%s", config.grouppath , tstringp);
  tstring2 = g_string_new(NULL);
  g_string_assign (tstring2, tstringp);
  
  /* rename it */
  rename (oldname->str, newname->str);

  /* refresh the file list to show newname */
  gtk_clist_freeze (GTK_CLIST (workwith_groups_clist));
  gtk_clist_clear (GTK_CLIST (workwith_groups_clist));
  
  /* get the list of files */
  tint = scandir (config.grouppath, &dirlist, NULL, alphasort);
  
  /* skip . and .. entries */
  tint2 = tint;
  
  /* loop through and append them to the clist */
  for (tint = 2; tint < tint2; tint++)
    {
      line[0] = dirlist[tint]->d_name;
      gtk_clist_append (GTK_CLIST (workwith_groups_clist), line);
    }
  gtk_clist_thaw (GTK_CLIST (workwith_groups_clist));
    
  if (! strcmp(config.groupfile, tstring2->str))
  {
  	strcpy(config.groupfile, tstring->str);
  	update_name_display ();
  }  	
  	
  g_string_free(tstring, TRUE);
  g_string_free(tstring2, TRUE);
  g_string_free(oldname, TRUE);
  g_string_free(newname, TRUE);
}
/****************************************************************************************
Callback from the edit group dialog ok button. This saves the group data and
closes the dialog.
****************************************************************************************/
void 
edit_group_ok_button ()
{
  GString *tstring;
  FILE *outfile;
  gint tint = 0, flag = 0;
  gchar *text;
  extern GtkWidget *edit_group_clist2, *edit_group_window;
  extern GString *edit_groupfilename;
  extern struct record config;


  tstring = g_string_new(NULL);
  gtk_clist_get_text (GTK_CLIST (edit_group_clist2), 0, 0, &text);
  
  /* check for any text in the first line of the clist box */
  if (strlen (text) > 0)
    {
      /* check for an active group displayed */
      g_string_sprintf (tstring, "%s%s", config.grouppath , edit_groupfilename->str);
      if (config.groupfile != NULL)
	{
	  /* check if the active group is being edited */
	  if (strcmp (edit_groupfilename->str, config.groupfile))
	    {
	      /* create a new one */
	      outfile = fopen(tstring->str, "w");
	    }
	  else
	    {
	      /* create a new one */
	      /* set this flag to remind me to load the active group again */
	      flag++;
	      outfile = fopen (tstring->str, "w");
	    }
	}
      else
	  outfile = fopen(edit_groupfilename->str, "w");

      /* loop through the clist line by line and write it to the group file */
      text = edit_groupfilename->str;
      while (text != NULL)
	{
	  text = NULL;
	  gtk_clist_get_text (GTK_CLIST (edit_group_clist2), tint, 0, &text);
	  
	  /* check for end of data in the clist box and exit loop */
	  if (text == NULL)
	    break;
	  fputs (text, outfile);
	  fputs ("\n", outfile);
	  tint++;
	}

      fclose(outfile);
      if (edit_group_window)
	gtk_widget_destroy (edit_group_window);
      
      if (flag)
      	load_first_group();
      g_string_free (tstring, TRUE);
    }
}


