#!--PERL--

## Copyright 1999 Comit Rseaux des Universts
## web interface to Sympa mailing lists manager
## Sympa: http://listes.cru.fr/sympa/

## Authors :
##           Serge Aumont <sa@cru.fr>
##           Olivier Salan <os@cru.fr>

## Change this to point to your Sympa bin directory
use lib '--SYMPADIR--';
use lib '--INSTALLDIR--';

# this is a beta version. 
$version = '0.6.4';
$required_sympa_version = '2.6.1';

## Template parser
require "--SYMPADIR--/parser.pl";

## Sympa API
use List;
use smtp;
use Conf;
use Commands;
use Log;
require "--SYMPADIR--/mail.pl";
require "--SYMPADIR--/msg.pl";
require "--SYMPADIR--/tools.pl";

## WWSympa librairies
require "--INSTALLDIR--/wws-lib.pl";

## Configuration
$wwsconf = {};

## Change to your wwsympa.conf location
$conf_file = '--CONFIG--';

## Load config 
unless ($wwsconf = &load_config($conf_file)) {
    &message('unable to load config file');
    return undef;
}


$mime_types = &load_mime_types();

if ($wwsconf->{'use_fast_cgi'}) {
    require CGI::Fast;
}else {
    require CGI;
}


%in, $list;
$param = {};
$loop = 0;

## subroutines
%comm = ('home' => 'do_home',
	 'logout' => 'do_logout',
	 'loginrequest' => 'do_loginrequest',
	 'login' => 'do_login',
	 'subscribe' => 'do_subscribe',
	 'subrequest' => 'do_subrequest',
	 'signoff' => 'do_signoff',
	 'sigrequest' => 'do_sigrequest',
	 'which' => 'do_which',
	 'lists' => 'do_lists',
	 'info' => 'do_info',
	 'review' => 'do_review',
	 'search' => 'do_search',
	 'pref', => 'do_pref',
	 'setpref' => 'do_setpref',
	 'setpasswd' => 'do_setpasswd',
	 'remindpasswd' => 'do_remindpasswd',
	 'sendpasswd' => 'do_sendpasswd',
	 'choosepasswd' => 'do_choosepasswd',	
	 'viewfile' => 'do_viewfile',
	 'set' => 'do_set',
	 'admin' => 'do_admin',
	 'add_request' => 'do_add_request',
	 'add' => 'do_add',
	 'del' => 'do_del',
	 'modindex' => 'do_modindex',
	 'reject' => 'do_reject',
	 'distribute' => 'do_distribute',
	 'viewmod' => 'do_viewmod',
	 'editfile' => 'do_editfile',
	 'savefile' => 'do_savefile',
	 'arc' => 'do_arc',
	 'remove_arc' => 'do_remove_arc',
	 'arcsearch_form' => 'do_arcsearch_form',
	 'arcsearch' => 'do_arcsearch',
	 'rebuildarc' => 'do_rebuildarc',
	 'serveradmin' => 'do_serveradmin',
	 'help' => 'do_help',
	 'edit_list' => 'do_edit_list',
	 'submit_list' => 'do_submit_list',
	 'editsubscriber' => 'do_editsubscriber',
	 'viewbounce' => 'do_viewbounce',
 	 'reviewbouncing' => 'do_reviewbouncing',
 	 'resetbounce' => 'do_resetbounce',
 	 'scenario_test' => 'do_scenario_test'
	 );

## What arguments may an action get in the PATH_INFO
%action_args = ('editfile' => ['list','file'],
		'viewfile' => ['list','file'],
		'sendpasswd' => ['email'],
		'choosepasswd' => ['email','passwd'],
		'login' => ['email','passwd','previous_action','previous_list'],
		'loginrequest' => ['previous_action','previous_list'],
		'logout' => ['previous_action','previous_list'],
		'reject' => ['list','id'],
		'distribute' => ['list','id'],
		'modindex' => ['list'],
		'viewmod' => ['list','id'],
		'viewfile' => ['list','file'],
		'add' => ['list','email'],
		'add_request' => ['list'],
		'del' => ['list','email'],
		'editsubscriber' => ['list','email','previous_action'],
		'viewbounce' => ['list','email'],
		'resetbounce' => ['list','email'],
		'review' => ['list','page','size'],
		'reviewbouncing' => ['list','page','size'],
		'arc' => ['list','month','arc_file'],
		'arcsearch_form' => ['list','archive_name'],
		'rebuildarc' => ['list','month'],
		'home' => [],
		'help' => ['help_topic'],
		'subscribe' => ['list','email','passwd'],
		'subrequest' => ['list','email'],
		'signoff' => ['list','email','passwd'],
		'sigrequest' => ['list','email'],
		'set' => ['list','email','reception'],
		'serveradmin' => [],
		'default' => ['list']
		);

## subtitles
%title = ('home' => {'fr' => '',
		     'es' => '',
		     'us' => ''},
	  'logout' => {'fr' => 'Logout',
		       'es' => 'Logout',
		       'us' => 'Logout'},
	  'loginrequest' => {'fr' => 'Login',
			     'es' => 'Login',
			     'us' => 'Login'},
	  'login' => {'fr' => 'Login',
		      'es' => 'Login',
		      'us' => 'Login'},
	  'subscribe' => {'fr' => 'Abonnement',
			  'es' => 'Subscripcin',
			  'us' => 'Subscription'},
	  'subrequest' => {'fr' => 'Demande d\'abonnement',
			   'es' => 'Solicitud de Subscripcin',
			   'us' => 'Subscription request'},
	  'signoff' => {'fr' => 'Dsabonnement',
			'es' => 'Anulacin subscripcin',
			'us' => 'Unsubscription'},
	  'sigrequest' => {'fr' => 'Demande de dsabonnement',
			   'es' => 'Anulacin Subscripcin',
			   'us' => 'Unsubscription request'},
	  'which' => {'fr' => 'Vos abonnements',
		      'es' => 'Sus subscripciones',
		      'us' => 'Your subscriptions'},
	  'lists' => {'fr' => 'Les listes publiques',
		      'es' => 'Listas pblicas',
		      'us' => 'Public lists'},
	  'info' => {'fr' => '',
		     'es' => '',
		     'us' => ''},
	  'review' => {'fr' => 'La liste des abonns',
		       'es' => 'Lista de subscriptores',
		       'us' => 'Subscribers list'},
	  'search' => {'fr' => 'Recherche parmi les abonns',
		       'es' => 'Buscar subscriptores',
		       'us' => 'Search subscribers'},
	  'pref' => {'fr' => 'Prfrences utilisateur',
		     'es' => 'Preferencias de usuario',
		     'en' => 'User preferences'},
	  'setpref' => {'fr' => 'Mise  jour des prfrences utilisateur',
			'es' => 'Preferencias de usuario actualizadas',
			'us' => 'User preferences update'},
	  'setpasswd' => {'fr' => 'Changement de mot de passe',
			  'es' => 'Cambio de contrasea',
			  'us' => 'Password update'},
	  'remindpasswd' => {'fr' => 'Rappel du mot de passe',
			     'es' => 'Recordar la contrasea',
			     'us' => 'Remind of the password'},
	  'sendpasswd' => {'fr' => 'Choix du mot de passe',
			   'es' => 'Enviar la contrasea',
			   'us' => 'Choosing your password'},
	  'choosepasswd' => {'fr' => 'Chosissez un mot de passe',
			     'es' => 'Elegir una contrasea',
			   'us' => 'Choose a password'},
	  'set' => {'fr' => 'Option d\'abonnement',
		    'es' => 'Opciones de subscripcin',
		    'us' => 'Subscription option'},
	  'admin' => {'fr' => 'Administration de la liste',
		      'es' => 'Administracin de la lista',
		      'us' => 'List administration'},
	  'add_request' => {'fr' => 'Ajout d\'abonns',
			    'es' => 'Aadir unos subscriptores',
			    'us' => 'Add subscribers'},
	  'add' => {'fr' => 'Ajout d\'un abonn',
		    'es' => 'Aadir un subscriptor',
		    'us' => 'Add a subscriber'},
	  'del' => {'fr' => 'Suppression d\'un abonn',
		    'es' => 'Borrar un subscriptor',
		    'us' => 'Delete a subscriber'},
	  'modindex' => {'fr' => 'Modration',
			 'es' => 'Moderacin',
			 'us' => 'Moderating'},
	  'reject' => {'fr' => 'Rejeter le message',
		       'es' => 'Rechazar el mensaje',
		       'us' => 'Reject message'},
	  'distribute' => {'fr' => 'Distribuer le message',
			   'es' => 'Distribuir el mensaje',
			   'us' => 'Distribute message'},
	  'viewmod' => {'fr' => 'Voir le message',
			'es' => 'Ver el mensaje',
			'us' => 'View message'},
	  'editfile' => {'fr' => 'Editer le fichier %s',
			 'es' => 'Editar el fichero %s',
			 'us' => 'Edit file %s'},
	  'viewfile' => {'fr' => '%s',
			 'es' => '%s',
			 'us' => '%s'},
	  'savefile' => {'fr' => 'Sauver le fichier %s',
			 'es' => 'Guardar el fichero %s',
			 'us' => 'Save file %s'},
	  'arc' => {'fr' => 'Archives',
		    'es' => 'Archivos',
		    'us' => 'Archives'},
	  'arcsearch_form' => {'fr' => 'Recherche dans les archives',
			       'us' => 'Search in the archives'},
	  'arcsearch' => {'fr' => 'Rsultats des recherches dans les archives',
			  'us' => 'Search results in the archives'},
	  'rebuildarc' => {'fr' => 'Reconstruction des archives',
			   'es' => 'Reconstruir los archivos',
			   'us' => 'Rebuild archives'},
	  'serveradmin' => {'fr' => 'Administration du serveur',
			    'es' => 'Administrador del Servidor',
			    'us' => 'Server administration'},
	  'help' => {'fr' => 'Aide',
		     'es' => 'Ayuda',
		     'us' => 'Help'},
	  'edit_list' => {'fr' => 'Edition de la liste',
			  'es' => 'Edicin de la lista',
			  'us' => 'Edit list'},
	  'submit_list' => {'fr' => 'Mise  jour de la liste',
			    'es' => 'Actualizar la lista',
			    'us' => 'Update list'},
 	  'editsubscriber' => {'fr' => 'Edition d\'un abonn',
			       'es' => 'Modificar un subscriptor',
			       'us' => 'Subscriber edition'},
 	  'viewbounce' => {'fr' => 'Le dernier rapport de non-remise',
			   'es' => 'El ltimo error al enviar',
			   'us' => 'Last bounce'},
	  'reviewbouncing' => {'fr' => 'Les adresses en erreur',
			       'es' => 'Las direcciones con errores',
			       'us' => 'Bouncing addresses'},
	  'resetbounce' => {'fr' => 'Effacer les erreurs',
			    'es' => 'Inicializar los errores de envo',
			    'us' => 'Reset bounces'},
	  'scenario_test' => {'fr' => 'test en situation des scnarios',
			      'es' => 'Comprobando escenario instalado',
			      'us' => 'testing installed scenari'}
	  );

## Open log
&Log::do_openlog($wwsconf->{'log_facility'}, 'unix');
&do_log('info', 'WWSympa started');

## Load sympa config
unless (&Conf::load( $wwsconf->{'sympa_conf_file'} )) {
    &message('config_error');
    &do_log('info','unable to load sympa config file');
    exit (-1);
}

## Set locale configuration
Language::SetLang($Conf{'lang'});

unless ($List::use_db = &List::probe_db()) {
    &message('no_database');
    &do_log('info','WWSympa requires a RDBMS to run');
}

## Catch SIGTERM, in order to exit cleanly, whenever possible.
$SIG{'HUP'} = 'sighup';


## Main loop
while (&new_loop()) {

    ## Parse CGI parameters
    &CGI::ReadParse();

    ## Get PATH_INFO parameters
    &get_parameters();

    &check_sympa_version();

    ## Sympa parameters in $param->{'conf'}
    $param->{'conf'} = \%Conf;

    $param->{'path_cgi'} = $ENV{'SCRIPT_NAME'};
    $param->{'version'} = $version;
    $param->{'date'} = &POSIX::strftime("%a %H:%M:%S", localtime(time));

    ## Change to list root
    unless (chdir($Conf{'home'})) {
	&message('chdir_error');
	&wwslog('info','unable to change directory');
	exit (-1);
    }

    ## Authentication
    $param->{'user'} = &get_cookie('user');
    
    ## Action
    my $action = $in{'action'} || 'home';
    $param->{'lang'} = $param->{'user'}{'lang'} || $Conf{'lang'};

    ## Session loop
    while ($action) {

	unless (&check_param()) {
	    &message('wrong_param');
	    &wwslog('info','Wrong parameters');
	    last;
	}

	$param->{'host'} = $list->{'admin'}{'host'} || $Conf{'host'};
	
	## language
#	my @http_lang;
#	foreach my $l (split /,/, $ENV{'HTTP_ACCEPT_LANGUAGE'}) {
#	    push @http_lang, $lang_equiv{$l} || $l;
#	}	    
	    
	$param->{'lang'} = $param->{'user'}{'lang'} || $list->{'admin'}{'lang'} 
	|| $Conf{'lang'};
	&POSIX::setlocale(&POSIX::LC_ALL, $locale_equiv{$param->{'lang'}});

	if ($comm{$action}) {
	    
	    $param->{'subtitle'} = $title{$action}{$param->{'lang'}};
	    $param->{'action'} = $action;
	    
            my $old_action = $action;

	    if ($action = &{$comm{$action}}() ) {
		$param->{'active'} = 1;
	    }
	    
            unless ($action ne $old_action) {
		&wwslog('info','Stopping loop with %s action', $action);
		undef $action;
	    }

	    undef $action if ($action == 1);
	    
	    ## Reload from database if another action follows
	    $param->{'user'} = &List::get_user_db($param->{'user'}{'email'})
		if $action;

	}elsif ($action) {
	    $param->{'error'}{'action'} = $action;
	    &message('unknown_action');
	    &wwslog('info','unknown action %s', $action);
	    last;
	}
    }
    
    ## Params 
    if ($param->{'list'}) {
	$param->{'title'} = "$param->{'list'}\@$param->{'host'}";
    }else {
	$param->{'title'} = $wwsconf->{'title'};
    }
    $param->{'site_url'} = $wwsconf->{'site_url'};
	$param->{'site_anchor'} = $wwsconf->{'site_anchor'};
    
    
    ## Set cookies
    if ($param->{'user'}{'email'}) {
	&set_cookie($param->{'user'}{'email'}, 'set') || exit;
    }
    
    if ($param->{'bypass'}) {
	unless ($mime_types->{$param->{'file_extension'}}) {
	    &do_log('debug', 'unknown MIME extension %s', $param->{'file_extension'});
	    exit (-1);
	}
	print "Cache-control: no-cache\n";
	printf "Content-Type: %s\n\n", $mime_types->{$param->{'file_extension'}};

	print $param->{'archive'};

    }else {
	## Send HTML
	print "Cache-control: no-cache\n";
	print "Content-Type: text/html\n\n";
	
	## Change to templates dir
	unless (chdir "$wwsconf->{'wws_path'}/templates") {
	    &message('chdir_error');
	    &wwslog('info','unable to change directory');
	    exit (-1);
	}
	
	## Action template
	if (-f "$param->{'action'}.tpl") {
	    $param->{'action_template'} = "$param->{'action'}.tpl";
	}elsif (-f "$param->{'action'}.$param->{'lang'}.tpl") {
	    $param->{'action_template'} = "$param->{'action'}.$param->{'lang'}.tpl";
	}else {
	    $param->{'action_template'} = "$param->{'action'}.default.tpl";
	}

	## Menu template
	if (-f "menu.$param->{'lang'}.tpl") {
	    $param->{'menu_template'} = "menu.$param->{'lang'}.tpl";
	}else {
	    $param->{'menu_template'} = "menu.default.tpl";
	}

	## Error template
	if (-f "error.$param->{'lang'}.tpl") {
	    $param->{'error_template'} = "error.$param->{'lang'}.tpl";
	}else {
	    $param->{'error_template'} = "error.default.tpl";
	}

	## Help template
	if (-f "help/$param->{'help_topic'}.$param->{'lang'}.tpl") {
	    $param->{'help_template'} = "help/$param->{'help_topic'}.$param->{'lang'}.tpl";
	}else {
	    $param->{'help_template'} = "help/$param->{'help_topic'}.default.tpl";
	}
	
	&parse_tpl($param, "main.tpl", STDOUT);
    }    

    # At the end of this loop reset variables is important to use this cgi as a CGI::fast 
    undef $param ; 
    
}

##############################################################
#-#\#|#/#-#\#|#/#-#\#|#/#-#\#|#/#-#\#|#/#-#\#|#/#-#\#|#/#-#\#|#/
##############################################################


sub new_loop {
    $loop++;

    if ($wwsconf->{'use_fast_cgi'}) {
	return (new CGI::Fast);
    }else {	
	return 1 unless ($loop > 1);
    }

    return undef;
}

sub get_parameters {
#    &wwslog('debug', 'get_parameters');

    ## CGI URL
    $param->{'base_url'} = sprintf 'http://%s', $ENV{'HTTP_HOST'};

    if ($ENV{'REQUEST_METHOD'} eq 'GET') {
	my $path_info = $ENV{'PATH_INFO'};
	$path_info =~ s+^/++;
	my @params = split /\//, $path_info;
	
	if ($#params >= 0) {
	    $in{'action'} = $params[0];
	    
	    my $args;
	    if ($action_args{$in{'action'}}) {
		$args = $action_args{$in{'action'}};
	    }else {
		$args = $action_args{'default'};
	    }
	    
	    my $i = 1;
	    foreach my $p (@$args) {
		$in{$p} = $params[$i];
		$i++;
	    }	    
	}
    }elsif ($ENV{'REQUEST_METHOD'} eq 'POST') {
	## POST
	foreach my $p (keys %in) {
	    if ($p =~ /^action_(\w+)$/) {
		$in{'action'} = $1;
		undef $in{$p};
	    }
	}
    }	
    
#    foreach $p (@params) {
#	&wwslog('debug', 'param: %s', $p);
#    }
    
    ## Lowercase email addresses
    $in{'email'} = lc ($in{'email'});

    return 1;
}

## Check Sympa version
sub check_sympa_version {

    my @version = split /\./, $Version::Version;
    my @required_version = split /\./, $required_sympa_version;

    foreach my $i (0..$#version) {
	next if ($version[$i] >= $required_version[$i]);
	
	&message('You_Need_To_Upgrade_Sympa');
	&do_log('info', 'You *MUST* upgrade to sympa %s or higher', $required_sympa_version);
    }

    return 1;
}

## Analysis of parameters
sub check_param {
#    &wwslog('debug', 'check_param');

    ## Lowercase list name
    $in{'list'} =~ tr/A-Z/a-z/;

    if ($in{'list'}) {
	unless($list = new List ($in{'list'})) {
	    $param->{'error'}{'list'} = $in{'list'};
	    &message('unknown_list');
	    &wwslog('info','check_param: unknown list %s', $in{'list'});
	    return undef;
	}

	$param->{'list'} = $in{'list'};

	## privileges
	$param->{'is_subscriber'} = $list->is_user($param->{'user'}{'email'});
	$param->{'is_owner'} = $list->am_i('owner', $param->{'user'}{'email'});
	$param->{'is_editor'} = $list->am_i('editor', $param->{'user'}{'email'});
	$param->{'is_privileged_owner'} = $list->am_i('privileged_owner', $param->{'user'}{'email'});
	$param->{'is_priv'} = $param->{'is_owner'} || $param->{'is_editor'} || $param->{'is_listmaster'};
    }

    if ($param->{'user'}{'email'} && (&List::get_action ('create_list',$param->{'user'}{'email'}, 'md5') =~ /do_it|listmaster/)) {
	$param->{'may_create_list'} = 1;
    }else{
	undef ($param->{'may_create_list'});
    }

    ## listmaster has owner and editor privileges for the list
    if (&List::is_listmaster($param->{'user'}{'email'})) {
	$param->{'is_listmaster'} = 1;
	$param->{'is_owner'} = 1;
	$param->{'is_priv'} = 1;
    }

    ## Traces
#    foreach $role ('is_owner','is_editor','is_listmaster','is_priv') {
#	&wwslog('debug', "%s %s", $param->{'user'}{'email'}, $role) if $param->{$role} ;
#    }

    return 1;

}
## Login WWSympa
sub do_login {
    &wwslog('debug', 'do_login(%s)', $in{'email'});
    my $user;
    my $next_action;
    
    if ($param->{'user'}{'email'}) {
	$param->{'error'}{'email'} = $param->{'user'}{'email'};
	&message('already_login');
	&wwslog('info','do_login: user %s already logged in', $param->{'user'}{'email'});
	return undef;
    }
    
    unless ($in{'email'}) {
	&message('no_email');
	&wwslog('info','do_login: no email');
	return undef;
    }
    
    unless (&valid_email($in{'email'})) {
	$param->{'error'}{'email'} = $in{'email'};
	&message('incorrect_email');
	&wwslog('info','do_login: incorrect email %s', $in{'email'});
	return undef;
    }
    
    
    unless ($in{'passwd'}) {
	&message('no_passwd');
	&wwslog('info','do_login: no passwd for user %s', $in{'email'});
	return undef;
    }
    
    unless ($user = &List::get_user_db($in{'email'})) {
	$param->{'error'}{'email'} = $in{'email'};
	&message('user_not_found');
	&wwslog('info','do_login: user %s not found', $in{'email'});
	return undef;
    }
    
    unless ($user->{'password'}) {
	$param->{'error'}{'email'} = $in{'email'};
	&message('passwd_not_found');
	&wwslog('info','do_login: password for user %s not found', $in{'email'});
	return undef;
    }
    
    unless ($in{'passwd'} eq $user->{'password'}) {
	&message('incorrect_passwd');
	&wwslog('info','do_login: incorrect password for user %s', $in{'email'});
	return undef;
    }
    
    $param->{'user'} = $user;
    
#    if ($in{'passwd'} =~ /^INIT/) {
#	$next_action = 'choosepasswd';
#	$param->{'previous_action'} = $in{'previous_action'};
#	$param->{'previous_list'} = $in{'previous_list'};
#    }els
    if ($in{'previous_action'}) {
	$next_action = $in{'previous_action'};
	$in{'list'} = $in{'previous_list'};
    }else {
	$next_action = 'home';
    }
    
    return $next_action;
}

## send back login form
sub do_loginrequest {
    &wwslog('debug','do_loginrequest');
    
    if ($param->{'user'}{'email'}) {
	$param->{'error'}{'email'} = $param->{'user'}{'email'};
	&message('already_login');
	&wwslog('info','do_loginrequest: already logged in as %s', $param->{'user'}{'email'});
	return undef;
    }
    
    $param->{'previous_action'} = $in{'previous_action'};
    $param->{'previous_list'} = $in{'previous_list'};
    
    return 1;
}

## Help / about WWSympa
sub do_help {
    &wwslog('debug','do_help(%s)', $in{'help_topic'});
    
    if ($in{'help_topic'}) {
	$param->{'no_menu'} = 1;
	$param->{'help_topic'} = $in{'help_topic'};
    }

    return 1;
}

## Logout from WWSympa
sub do_logout {
    &wwslog('debug','do_logout(%s)', $param->{'user'}{'email'});
    
    my $next_action;
    
    unless ($param->{'user'}{'email'}) {
	&message('no_user');
	&wwslog('info','do_logout: user not logged in');
	return undef;
    }
    
    &set_cookie($param->{'user'}{'email'}, 'reset')
	if $param->{'user'}{'email'};
    
    delete $param->{'user'};
    
    &wwslog('info','do_logout: logout performed');
    
    return 'home';
}

## Remind the password
sub do_remindpasswd {
    &wwslog('debug', 'do_remindpasswd(%s)', $in{'email'}); 
    
    if ($in{'email'} and ! &valid_email($in{'email'})) {
	$param->{'error'}{'email'} = $in{'email'};
	&message('incorrect_email');
	&wwslog('info','do_remindpasswd: incorrect email %s', $in{'email'});
	return undef;
    }
    
    $param->{'email'} = $in{'email'};
    
    return 1;
}

sub do_sendpasswd {
    &wwslog('debug', 'do_sendpasswd(%s)', $in{'email'}); 
    my ($passwd, $user);
    
    unless ($in{'email'}) {
	&message('no_email');
	&wwslog('info','do_sendpasswd: no email');
	return undef;
    }
    
    unless (&valid_email($in{'email'})) {
	$param->{'error'}{'email'} = $in{'email'};
	&message('incorrect_email');
	&wwslog('info','do_sendpasswd: incorrect email %s', $in{'email'});
	return undef;
    }
    
    ## Init passwd if needed
    &init_passwd ($in{'email'}, {'lang' => $param->{'lang'}});

    $param->{'newuser'} =  &List::get_user_db($in{'email'});
    
    $param->{'newuser'}{'escaped_email'} =  &escape_chars($param->{'newuser'}{'email'});

    $param->{'init_passwd'} = 1 
	if ($param->{'newuser'}{'password'} =~ /^INIT/);

    unless (open MAIL, "|$Conf{'sendmail'} $in{'email'}") {
	&message('mail_error');
	&wwslog('info','do_sendpasswd: mail error');
	return undef;
    }    
        
    &parse_tpl ($param, "$wwsconf->{'wws_path'}/templates/msg_sendpasswd.$param->{'lang'}.tpl", MAIL);
    close MAIL;
    
    if ($in{action} eq 'sendpasswd') {
	return 'loginrequest';
    }
    
    return 1;
}

## Which list the user is subscribed to 
## TODO (pour listmaster, toutes les listes)
sub do_which {
    my $which = {};
    my @lists;
    &wwslog('debug', 'do_which');
    
    unless ($param->{'user'}{'email'}) {
	&message('no_user');
	&wwslog('info','do_which: no user');
	return undef;
    }

    foreach $role ('member','owner','editor') {
	foreach $l ( &List::get_which($param->{'user'}{'email'}, $role) ) {
	    my $list = new List ($l);
	    
	    $param->{$role}{$l}{'subject'} = $list->{'admin'}{'subject'};
	    $param->{$role}{$l}{'host'} = $list->{'admin'}{'host'};
	}
    }

    return 1;
}

## The list of list
sub do_lists {
    my @lists;
    &wwslog('debug', 'do_lists');
    
    foreach $l ( &List::get_lists() ) {
	my $list = new List ($l);
	my $sender = $param->{'user'}{'email'} || 'nobody';
	my $action = &List::get_action ('visibility', $l, $sender, 'smtp');
	
	next unless ($action eq 'do_it');
	$param->{'lists'}{$l}{'subject'} = $list->{'admin'}{'subject'};
	$param->{'lists'}{$l}{'host'} = $list->{'admin'}{'host'};
    }

    return 1;
}

## List information page
sub do_info {
    &wwslog('debug', 'do_info');

    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_info: no list');
	return undef;
    }

    $param->{'subtitle'} = $list->{'admin'}{'subject'};
    $param->{'subscribe'} = $list->{'admin'}{'subscribe'}{'name'};
    $param->{'send'} = $list->{'admin'}{'send'}{'title'}{$param->{'lang'}};
    $param->{'total'} = $list->get_total();

    ## May review
    my $action = &List::get_action ('review', $param->{'list'}, $param->{'user'}{'email'}||'nobody', 'smtp');
    
    if ($action eq 'request_auth') {
	$action = &List::get_action ('review', $param->{'list'}, $param->{'user'}{'email'}||'nobody', 'md5');
    }
    
    $param->{'may_review'} = 1 if ($action =~ /do_it/);
    

    ## may subscribe
    $action = &List::get_action ('subscribe', $param->{'list'}, $param->{'user'}{'email'}||'nobody', 'smtp');
    
    if ($action eq 'request_auth') {
	$action = &List::get_action ('subscribe', $param->{'list'}, $param->{'user'}{'email'}||'nobody', 'md5');
    }
    
    $param->{'may_subscribe'} = 1 if ($action =~ /do_it|owner/);
    
    ## May signoff
    $action = &List::get_action ('unsubscribe', $param->{'list'}, $param->{'user'}{'email'}||'nobody', $param->{'user'}{'email'}||'nobody', 'smtp');
    
    if ($action =~ /request_auth/) {
	$action = &List::get_action ('unsubscribe', $param->{'list'}, $param->{'user'}{'email'}||'nobody', $param->{'user'}{'email'}||'nobody', 'md5');
    }

    $param->{'may_signoff'} = 1 if ($action =~ /do_it|owner/);
    
    ## Digest frequency
    if ($list->{'admin'}{'digest'} =~ /^([\d\,]+)\s+([\d\:]+)/m) {
	my (@days, $d);
	my $hour = $2;
	foreach $d (split /\,/, $1) {
	    push @days, $week{'fr'}[$d];
	}
	$param->{'digest'} = sprintf '%s - %s', (join ', ', @days), $hour;
    }
 
    ## Is_user
    if ($param->{'is_subscriber'}) {
	my ($s, $m);

	unless($s = $list->get_subscriber($param->{'user'}{'email'})) {
	    $param->{'error'}{'email'} = $param->{'user'}{'email'};
	    &message('subscriber_not_found');
	    &wwslog('info', 'do_info: subscriber %s not found', $param->{'user'}{'email'});
	    return undef;
	}

#	foreach my $key (keys %{$s}) {
#	    &wwslog('debug', 'do_info: get_subscriber : %s => %s', $key, $s->{$key});
#	}

	$s->{'reception'} ||= 'mail';
	$s->{'visibility'} ||= 'noconceal';
#	&wwslog('debug', 'do_info: date : %d', $s->{'date'});
	$s->{'date'} = &POSIX::strftime("%d %b %Y", localtime($s->{'date'}));
	
	foreach $m (keys %reception_mode) {
	    $param->{'reception'}{$m}{'description'} = $reception_mode{$m};
	    if ($s->{'reception'} eq $m) {
		$param->{'reception'}{$m}{'selected'} = 'SELECTED';
	    }else {
		$param->{'reception'}{$m}{'selected'} = '';
	    }
	}

	$param->{'subscriber'} = $s;
    }

    ## Get List Description
    $param->{'info_file'} = "$Conf{'home'}/$param->{'list'}/info";

    ## Owners
    foreach $o (@{$list->{'admin'}{'owner'}}) {
	$param->{'owner'}{$o->{'email'}}{'gecos'} = $o->{'gecos'} || $o->{'email'};
    }

    ## Editors
    $param->{'is_moderated'} = $list->is_moderated();
    foreach $e (@{$list->{'admin'}{'editor'}}) {
	$param->{'editor'}{$e->{'email'}}{'gecos'} = $e->{'gecos'} || $e->{'email'};
    }  

    ## Archives Access control
    $param->{'arc_access'} =  $list->may_do('access_web_archive', $param->{'user'}{'email'});

    return 1;
}

## Subscribers' list
sub do_review {
    &wwslog('debug', 'do_review(%d)', $in{'page'});
    my $record;
    my @users;
    my $size = $in{'size'} || $wwsconf->{'review_page_size'};

    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_review: no list');
	return undef;
    }

    ## May review
    my $action = &List::get_action ('review', $param->{'list'}, $param->{'user'}{'email'}||'nobody', 'smtp');

    if ($action eq 'request_auth') {
	$action = &List::get_action ('review', $param->{'list'}, $param->{'user'}{'email'}||'nobody', 'md5');
    }

    unless ($action =~ /do_it/) {
	$param->{'error'}{'action'} = 'review';
	&message('may_not');
	&wwslog('info','do_review: may not review');
	return undef;
    }

    unless ($list->get_total()) {
	&message('no_subscriber');
	&wwslog('info','do_review: no subscriber');
	return undef;
    }

    ## Owner
    $param->{'total'} = $list->get_total();
    $param->{'page'} = $in{'page'} || 1;
    $param->{'total_page'} = int ($param->{'total'} / $size);
    $param->{'total_page'} ++
	if ($param->{'total'} % $size);

    if ($param->{'page'} > $param->{'total_page'}) {
	$param->{'error'}{'page'} = $param->{'page'};
	&message('no_page');
	&wwslog('info','do_review: no page %d', $param->{'page'});
	return undef;
    }

    ## Sort members
#    for ($i = $list->get_first_user(); $i; $i = $list->get_next_user()) {
#	push @users, $i;
#    }

    ## Members list
    for ($i = $list->get_first_user(); $i; $i = $list->get_next_user()) {
	$record++;
	
	if ($record > ( $size * ($param->{'page'} ) ) ) {
	    $param->{'next_page'} = $param->{'page'} + 1;
	    last;
	}
	
	next if ($record <= ( ($param->{'page'} - 1) *  $size));
	
	next if (($i->{'visibility'} eq 'conceal')
		 and (! $param->{'is_owner'}) );
	
	## Add user
	$i->{'date'} = &POSIX::strftime("%d %b %Y", localtime($i->{'date'}));

#	foreach my $k (keys %{$i}) {
#	    &do_log('debug', '%s: %s', $k, $i->{$k});
#	}	

	$i->{'reception'} ||= 'mail';

	## Escape some wierd chars
	$i->{'escaped_email'} = &escape_chars($i->{'email'});

#	$param->{'members'}{$i->{'email'}} = $i;
	push @{$param->{'members'}}, $i;
    }

    if ($param->{'page'} > 1) {
	$param->{'prev_page'} = $param->{'page'} - 1;
    }
    $param->{'size'} = $size;

    return 1;
}

## Search in subscribers
sub do_search {
    &wwslog('debug', 'do_search(%s)', $in{'filter'});
    my $record;

    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_search: no list');
	return undef;
    }

    unless ($in{'filter'}) {
	&message('no_filter');
	&wwslog('info','do_search: no filter');
	return undef;
    }
    
    unless ($param->{'user'}{'email'}) {
	&message('no_user');
	&wwslog('info','do_search: no user');
	return undef;
    }

    ## May review
    my $action = &List::get_action ('review', $param->{'list'}, $param->{'user'}{'email'}, 'smtp');

    if ($action eq 'request_auth') {
	$action = &List::get_action ('review', $param->{'list'}, $param->{'user'}{'email'}, 'md5');
    }

    unless ($action =~ /do_it/) {
	$param->{'error'}{'action'} = 'review';
	&message('may_not');
	&wwslog('info','do_review: may not review');
	return undef;
    }

    ## Regexp
    $param->{'filter'} = $in{'filter'};
    $param->{'regexp'} = $param->{'filter'};
    $param->{'regexp'} =~ s/\\/\\\\/g;
    $param->{'regexp'} =~ s/\./\\\./g;
    $param->{'regexp'} =~ s/\*/\.\*/g;
    $param->{'regexp'} =~ s/\+/\\\+/g;
    $param->{'regexp'} =~ s/\?/\\\?/g;
#    &do_log('debug', 'do_search: regexp = %s', $param->{'regexp'});

    ## Members list
    for ($i = $list->get_first_user(); $i; $i = $list->get_next_user()) {

	## Search filter
	next if ($i->{'email'} !~ /$param->{'regexp'}/i);

	$record++;

	next if (($i->{'visibility'} eq 'conceal')
		 and (! $param->{'is_owner'}) );
	
	## Add user
	$i->{'date'} = &POSIX::strftime("%d %b %Y", localtime($i->{'date'}));

	$i->{'reception'} ||= 'mail';

	## Escape some weird chars
	$i->{'escaped_email'} = &escape_chars($i->{'email'});

#	$param->{'members'}{$i->{'email'}} = $i;
	push @{$param->{'members'}}, $i;
    }

    return 1;
}

## Access to user preferences
sub do_pref {
    &wwslog('debug', 'do_pref');

    unless ($param->{'user'}{'email'}) {
	&message('no_user');
	&wwslog('info','do_pref: no user');
	return undef;
    }

    $param->{'user'}{'cookie_delay'} ||= $wwsconf->{'cookie_expire'};

    ## Available languages
    foreach $l (keys %languages) {
	$param->{'languages'}{$l}{'complete'} = $languages{$l};
	if ($param->{'lang'} eq $l) {
	    $param->{'languages'}{$l}{'selected'} = 'SELECTED';
	}else {
	    $param->{'languages'}{$l}{'selected'} = '';
	}
    }
    
    return 1;
}

## Set the initial password
sub do_choosepasswd {
    &wwslog('debug', 'do_choosepasswd');

    unless ($param->{'user'}{'email'}) {
	unless ($in{'email'} && $in{'passwd'}) {
	    &message('no_user');
	    &wwslog('info','do_pref: no user');
	    return undef;
	}

	$in{'previous_action'} = 'choosepasswd';
	return 'login';
    }

    $param->{'init_passwd'} = 1 if ($param->{'user'}{'password'} =~ /^INIT/);

    return 1;
}

## Update of user preferences
## TODO: Verif password
sub do_setpref {
    &wwslog('debug', 'do_setpref');
    my $changes = {};

    unless ($param->{'user'}{'email'}) {
	&message('no_user');
	&wwslog('info','do_pref: no user');
	return undef;
    }

    foreach $p ('gecos','lang','cookie_delay') {
	$changes->{$p} = $in{$p};
    }

    unless (&List::update_user_db($param->{'user'}{'email'}, $changes)) {
	&message('update_failed');
	&wwslog('info','do_pref: update failed');
	return undef;
    }

    return 'pref';
}

## Prendre en compte les dfauts
sub do_viewfile {
    &wwslog('debug', 'do_viewfile');

    unless ($in{'file'}) {
	$param->{'error'}{'argument'} = 'file';
	&message('missing_arg');
	&wwslog('info','do_viewfile: no file');
	return undef;
    }

    unless (defined $filenames{$in{'file'}}) {
	$param->{'error'}{'file'} = $in{'file'};
	&message('file_not_editable');
	&wwslog('info','do_viewfile: file %s not editable', $in{'file'});
	return undef;
    }

   unless ($param->{'list'}) {
       $param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_viewfile: no list');
	return undef;
    }

    $param->{'file'} = $in{'file'};
    $param->{'subtitle'} = sprintf $param->{'subtitle'}, $filenames{$in{'file'}}{$param->{'lang'}};

    $param->{'filepath'} = "$Conf{'home'}/$list->{'name'}/$in{'file'}";

    if ((-e $param->{'filepath'}) and (! -r $param->{'filepath'})) {
	&message('read_error');
	&wwslog('info','do_viewfile: cannot read %s', $param->{'filepath'});
	return undef;
    }

    return 1;
}

## Subscribe to the list
## TOTO: accepter nouveaux users
sub do_subscribe {
    &wwslog('debug', 'do_subscribe(%s)', $in{'email'});

    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_subscribe: no list');
	return undef;
    }

    unless ($param->{'user'}{'email'}) {
	unless ($in{'email'}) {
	    &message('no_user');
	    &wwslog('info','do_subscribe: no user');
	    return undef;
	}

	## Perform login
	if ($in{'passwd'}) {
	    $in{'previous_action'} = 'subscribe';
	    $in{'previous_list'} = $param->{'list'};
	    return 'login';
	}

	if ( &List::is_user_db($in{'email'}) ) {
	    &message('no_user');
	    &wwslog('info','do_subscribe: need auth for user %s', $in{'email'});
	    return undef;
	}
	
	## Here is a brand new user
	&init_passwd($in{'email'},{'lang' => $param->{'lang'},
				   'gecos' => $in{'gecos'}});
	
	$param->{'user'}{'email'} = $in{'email'};
    }

    if ( $list->is_user($param->{'user'}{'email'}) ) {
	$param->{'error'}{'list'} = $list->{'name'};
	&message('already_subscriber');
	&wwslog('info','do_subscribe: %s already subscriber', $param->{'user'}{'email'});
	return undef;
    }
	
    my $sub_is = &List::get_action('subscribe', $param->{'list'}, $param->{'user'}{'email'}, 'smtp');

    if ($sub_is eq 'request_auth') {
	$sub_is = &List::get_action('subscribe', $param->{'list'}, $param->{'user'}{'email'}, 'md5');
    }

    if ($sub_is eq 'closed') {
	$param->{'error'}{'action'} = 'subscribe';
       	&message('may_not');
	&wwslog('info', 'do_subscribe: subscribe closed');
	return undef;
    }

    $param->{'may_subscribe'} = 1;
    
    if ($sub_is eq 'owner') {
	$list->send_sub_to_owner($param->{'user'}{'email'}, $param->{'user'}{'gecos'});
	&message('sent_to_owner');
	&wwslog('info', 'do_subscribe: subscribe sent to owner');

	return 'info';
    }elsif ($sub_is =~ /do_it/) {
	my $u = $list->get_default_user_options();
	$u->{'email'} = $param->{'user'}{'email'};
	$u->{'gecos'} = $param->{'user'}{'gecos'};
	$u->{'date'} = time;
	
	unless ($list->add_user($u)) {
	    &message('failed');
	    &wwslog('info', 'do_subscribe: subscribe failed');
	    return undef;
	}

	$list->save();

	$list->send_file('welcome', $param->{'user'}{'email'});
	if ($sub_is =~ /notify/) {
	    $list->send_notify_to_owner($param->{'user'}{'email'}, $param->{'user'}{'gecos'}, 'subscribe');
	}
    }
    
    $param->{'error'}{'action'} = 'subscribe';
    &message('performed');

    return 'info';
}

## Subscription request (user not authentified)
sub do_subrequest {
    &wwslog('debug', 'do_subrequest(%s)', $in{'email'});
    
    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_subrequest: no list');
	return undef;
    }
    
    ## Not auth & no email
    unless ($param->{'user'}{'email'} or $in{'email'}) {
	&message('no_email');
	&wwslog('info','do_subrequest: no email');
	return undef;
    }
    
    ## Basic check of email if provided
    if ($in{'email'}) {
	unless (&valid_email($in{'email'})) {
	    &message('incorrect_email');
	    &wwslog('info','do_subrequest: incorrect email %s'
		    , $in{'email'});
	    return undef;
	}
    }
    
    ## Subscriber (auth or not)
    if ($param->{'is_subscriber'} ) {
	&message('already_subscriber');
	&wwslog('info','do_subrequest: user %s is already subscriber', $param->{'user'}{'email'} || $in{'email'});
	return undef;
    } 
    
    unless ($param->{'user'}{'email'}) {
	if ($list->is_user($in{'email'})) {
	    $param->{'subscriber_not_auth'} = 1;
	}else {
   	    unless (&init_passwd ($in{'email'}, {'lang' => $param->{'lang'},
						 'gecos' => $in{'gecos'}})) {
	 	&message('failed');
         	&wwslog('info','subrequest: password initialization for user %s failed', $in{'email'});
         	return undef;
    	    }

	    my $user = &List::get_user_db($in{'email'});

	    if ($user->{'password'} =~ /^INIT/) {
		&do_sendpasswd() if ($user->{'password'} =~ /^INIT/);
		$param->{'init_passwd'} = 1;
	    }
	}
    }
    
    $param->{'subscriber_not_auth'} = 1 
	if (!$param->{'user'}{'email'} && $list->is_user($in{'email'}));
    
    $param->{'email'} = $in{'email'};

    return 1;
}

## Unsubscribe from list
sub do_signoff {
    &wwslog('debug', 'do_signoff');

    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_signoff: no list');
	return undef;
    }

    unless ($param->{'user'}{'email'}) {
	unless ($in{'email'}) {
	    &message('no_user');
	    &wwslog('info','do_signoff: no user');
	    return undef;
	}

	## Perform login first
	if ($in{'passwd'}) {
	    $in{'previous_action'} = 'signoff';
	    $in{'previous_list'} = $param->{'list'};
	    return 'login';
	}
	
	if ( &List::is_user_db($in{'email'}) ) {
	    &message('no_user');
	    &wwslog('info','do_signoff: need auth for user %s', $in{'email'});
	    return undef;
	}
	
	## No passwd
	&init_passwd($in{'email'}, {'lang' => $param->{'lang'} });
	
	$param->{'user'}{'email'} = $in{'email'};
    }
    
    unless ($list->is_user($param->{'user'}{'email'})) {
	$param->{'error'}{'list'} = $list->{'name'};
	&message('not_subscribed');
	&wwslog('info','do_signoff: %s not subscribed to %s',$param->{'user'}{'email'}, $param->{'list'} );
	return undef;
    }

    my $sig_is = &List::get_action ('unsubscribe', $param->{'list'}, $param->{'user'}{'email'}, $param->{'user'}{'email'}, 'smtp');

    if ($sig_is eq 'request_auth') {
	$sig_is = &List::get_action ('unsubscribe', $param->{'list'}, $param->{'user'}{'email'}, $param->{'user'}{'email'}, 'md5');
    }

    $param->{'may_signoff'} = 1 if ($sig_is =~ /do_it|owner/);
    
    if ($sig_is =~ /reject/) {
	$param->{'error'}{'action'} = 'unsubscribe';
	&message('may_not');
	&wwslog('info', 'do_signoff: %s may not signoff from %s'
		, $param->{'user'}{'email'}, $param->{'list'});
	return undef;
    }elsif ($sig_is =~ /owner/) {
	$list->send_sig_to_owner($param->{'user'}{'email'});
	&message('sent_to_owner');
	&wwslog('info', 'do_signoff: signoff sent to owner');
	return undef;
    }else {
	unless ($list->delete_user($param->{'user'}{'email'})) {
	    &message('failed');
	    &wwslog('info', 'do_signoff: signoff failed');
	    return undef;
	}

	$list->save();

	if ($sig_is =~ /notify/) {
	    $list->send_notify_to_owner($param->{'user'}{'email'}, '', 'signoff');
	}
	
	$list->send_file('bye', $param->{'user'}{'email'});
    }

    $param->{'error'}{'action'} = 'unsubscribe';
    &message('performed');

    return 'info';
}

## Unsubscription request (user not authentified)
sub do_sigrequest {
    &wwslog('debug', 'do_sigrequest(%s)', $in{'email'});
    
    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_sigrequest: no list');
	return undef;
    }

    ## Do it
    if ($param->{'user'}{'email'}) {
	return 'signoff';
    }
    
    ## Not auth & no email
    unless ($in{'email'}) {
	&message('no_email');
	&wwslog('info','do_sigrequest: no email');
	return undef;
    }
    
    ## Basic check of email if provided
    if ($in{'email'}) {
	unless (&valid_email($in{'email'})) {
	    &message('incorrect_email');
	    &wwslog('info','do_sigrequest: incorrect email %s'
		    , $in{'email'});
	    return undef;
	}
    }
    
    if ($list->is_user($in{'email'})) {
	unless (&init_passwd ($in{'email'}, {'lang' => $param->{'lang'} })) {
	    &message('failed');
	    &wwslog('info','sigrequest: password initialization for user %s failed', $in{'email'});
	    return undef;
	}
	
	my $user = &List::get_user_db($in{'email'});
	
	if ($user->{'password'} =~ /^INIT/) {
	    &do_sendpasswd() if ($user->{'password'} =~ /^INIT/);
	    $param->{'init_passwd'} = 1;
	}
    }else {
	$param->{'not_subscriber'} = 1;
    }
    
    $param->{'email'} = $in{'email'};
    
    return 1;
}

## Change subscription parameter
sub do_set {
    &wwslog('debug', 'do_set(%s)', $in{'reception'});

    my $reception;
    my $email;

    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_set: no list');
	return undef;
    }
    
    unless ($reception = $in{'reception'}) {
	&message('no_reception');
	&wwslog('info','do_set: no reception');
	return undef;
    }

    if ($in{'email'}) {
    	unless ($param->{'is_owner'}) {
	    $param->{'error'}{'action'} = 'set';
	    &message('may_not');
	    &wwslog('info','do_set: not owner');
	    return undef;
        }

	$email = &unescape_chars($in{'email'});
    }else {
    	unless ($param->{'user'}{'email'}) {
	   &message('no_user');
	   &wwslog('info','do_set: no user');
	   return undef;
        }
	$email = $param->{'user'}{'email'};
    } 
  
    unless ($list->is_user($email)) {
	&message('not_subscriber');
	&wwslog('info','do_set: %s not subscriber of list %s', $email, $param->{'list'});
	return undef;
    }
    
    $reception = '' if $reception eq 'mail';

    unless ( $list->update_user($email, 
				{'reception'=> $reception,
				 'gecos' => $in{'gecos'}}) ) {
	&message('failed');
	&wwslog('info', 'do_set: set failed');
	return undef;
    }

    $param->{'error'}{'action'} = 'set';
    &message('performed');

    return 'info';
}

## Update of password
sub do_setpasswd {
    &wwslog('debug', 'do_setpasswd');
    my $user;

    unless ($param->{'user'}{'email'}) {
	&message('no_user');
	&wwslog('info','do_setpasswd: no user');
	return undef;
    }

    unless ($user = &List::get_user_db($param->{'user'}{'email'})) {
	$param{'error'}{'email'} = $param->{'user'}{'email'};
	&message('user_not_found');
	&wwslog('info','setpasswd: user %s not found', $param->{'user'}{'email'});
	return undef;
    }

    unless ($in{'passwd'}) {
	&message('no_passwd');
	&wwslog('info','do_setpasswd: no passwd');
	return undef;
    }
  
    unless ($in{'newpasswd1'}) {
	&message('no_passwd');
	&wwslog('info','do_setpasswd: no newpasswd1');
	return undef;
    }
  
    unless ($in{'newpasswd2'}) {
	&message('no_passwd');
	&wwslog('info','do_setpasswd: no newpasswd2');
	return undef;
    }

    unless ($in{'newpasswd1'} eq $in{'newpasswd2'}) {
	&message('diff_passwd');
	&wwslog('info','do_setpasswd: different newpasswds');
	return undef;
    }
  
    unless ( $in{'passwd'} eq $user->{'password'}) {
	&message('incorrect_passwd');
	&wwslog('info','setpasswd: incorrect password for user %s', $param->{'user'}{'email'});
	return undef;
    }

    unless ( &List::update_user_db($param->{'user'}{'email'}, {'password' => $in{'newpasswd1'}} )) {
	&message('failed');
	&wwslog('info','do_setpasswd: update failed');
	return undef;
    }

    $param->{'error'}{'action'} = 'setpassword';
    &message('performed');

    if ($in{'previous_action'}) {
	$in{'list'} = $in{'previous_list'};
	return $in{'previous_action'};
    }else {
	return 'pref';
    }
}

## List admin page
sub do_admin {
    &wwslog('debug', 'do_admin');

    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_admin: no list');
	return undef;
    }
    
    unless ($param->{'user'}{'email'}) {
	&message('no_user');
	&wwslog('info','do_admin: no user');
	return undef;
    }
 
    unless ($param->{'is_owner'} or $param->{'is_editor'}) {
	$param->{'error'}{'action'} = 'admin';
	&message('may_not');
	&wwslog('info','do_admin: %s not priv user', $param->{'user'}{'email'});
	return undef;
    }
 
    ## Messages edition
    foreach $f ('info','welcome.tpl','bye.tpl','removed.tpl','message.footer','message.header','remind.tpl','invite.tpl') {
	next unless ($list->may_edit($f, $param->{'user'}{'email'}) eq 'write');
	$param->{'files'}{$f}{'complete'} = $filenames{$f}{$param->{'lang'}};
	$param->{'files'}{$f}{'selected'} = '';
    }
    $param->{'files'}{'info'}{'selected'} = 'SELECTED';
   
    $param->{'total'} = $list->get_total();
    $param->{'mod_total'} = $list->get_mod_spool_size();
    
    my $total = $param->{'total'};
    if ($total > 0) {
	$param->{'bounce_rate'} = $list->get_total_bouncing() * 100 / $total;
	$param->{'bounce_rate'} = int ($param->{'bounce_rate'} * 10) / 10;
    }
    return 1;
}

## Server admin page
sub do_serveradmin {
    &wwslog('debug', 'do_serveradmin');
    my $f;

    unless ($param->{'user'}{'email'}) {
	&message('no_user');
	&wwslog('info','do_serveradmin: no user');
	return undef;
    }
 
    unless ($param->{'is_listmaster'}) {
	$param->{'error'}{'action'} = 'serveradmin';
	&message('may_not');
	&wwslog('info','do_admin: %s not listmaster', $param->{'user'}{'email'});
	return undef;
    }
 
    $param->{'conf'} = \%Conf;

    ## Lists Default files
    foreach $f ('welcome.tpl','bye.tpl','removed.tpl','message.footer','message.header','remind.tpl') {
	$param->{'lists_default_files'}{$f}{'complete'} = $filenames{$f}{$param->{'lang'}};
	$param->{'lists_default_files'}{$f}{'selected'} = '';
    }
#    $param->{'lists_default_files'}{'welcome.tpl'}{'selected'} = 'SELECTED';
    
    ## Server files
    foreach $f ('helpfile','helpfile.advanced','lists.header','lists.footer') {
	$param->{'server_files'}{$f}{'complete'} = $filenames{$f}{$param->{'lang'}};
	$param->{'server_files'}{$f}{'selected'} = '';
    }
    $param->{'server_files'}{'helpfile'}{'selected'} = 'SELECTED';
    

    return 1;
}

## Multiple add
sub do_add_request {
    &wwslog('debug', 'do_add(%s)', $in{'email'});

    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_add: no list');
	return undef;
    }
 
    unless ($param->{'user'}{'email'}) {
	&message('no_user');
	&wwslog('info','do_add: no user');
	return undef;
    }

    my $add_is = &List::get_action ('add', $param->{'list'}, $param->{'user'}{'email'}, $param->{'user'}{'email'}, 'smtp');

    if ($add_is eq 'request_auth') {
	$add_is = &List::get_action ('add', $param->{'list'}, $param->{'user'}{'email'}, $param->{'user'}{'email'}, 'md5');
    }

    unless ($add_is =~ /do_it/) {
	$param->{'error'}{'action'} = 'add';
	&message('may_not');
	&wwslog('info','do_add: %s may not add', $param->{'user'}{'email'});
	return undef;
    }

    return 1;
}
## Add a user to a list
## TODO: vrifier validit email
sub do_add {
    &wwslog('debug', 'do_add(%s)', $in{'email'});

    my %user;

    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_add: no list');
	return undef;
    }
    
    unless ($param->{'user'}{'email'}) {
	&message('no_user');
	&wwslog('info','do_add: no user');
	return undef;
    }
 
    my $add_is = &List::get_action ('add', $param->{'list'}, $param->{'user'}{'email'}, $param->{'user'}{'email'}, 'smtp');

    if ($add_is eq 'request_auth') {
	$add_is = &List::get_action ('add', $param->{'list'}, $param->{'user'}{'email'}, $param->{'user'}{'email'}, 'md5');
    }

    unless ($add_is =~ /do_it/) {
	$param->{'error'}{'action'} = 'add';
	&message('may_not');
	&wwslog('info','do_add: %s may not add', $param->{'user'}{'email'});
	return undef;
    }
    
    if ($in{'dump'}) {
	foreach (split /\n/, $in{'dump'}) {
	    if (/^(\S+|\".*\"@\S+)(\s+(.*))?\s*$/) {
		$user{$1} = $3;
	    }
	}
    }elsif ($in{'email'}) {
	$user{$in{'email'}} = $in{'gecos'};
    }else {
	&message('no_email');
	&wwslog('info','do_add: no email');
	return undef;
    }

    foreach my $email (keys %user) {

	unless (&valid_email($email)) {
	    $param->{'error'}{'email'} = $email;
	    &message('incorrect_email');
	    &wwslog('info','do_add: incorrect email %s', $email);
	    return undef;
	}

	if ( $list->is_user($email) ) {
	    $param->{'error'}{'email'} = $email;
	    $param->{'error'}{'list'} = $list->{'name'};
	    &message('user_already_subscriber');
	    &wwslog('info','do_add: %s already subscriber', $email);
	    return undef;
	}
    
	my $u = $list->get_default_user_options();
	$u->{'email'} = $email;
	$u->{'gecos'} = $user{$email};
	$u->{'date'} = time;
	unless( $list->add_user($u)) {
	    $param->{'error'}{'action'} = 'add';
	    &message('failed');
	    &wwslog('info','do_add: failed');
	    return undef;
	}
	
	$list->save();
	
	$list->send_file('welcome', $email) unless ($in{'quiet'});
    }
    
    $param->{'error'}{'action'} = 'add';
    &message('performed');

    return $in{'previous_action'} || 'admin';
}

## Del a user to a list
## TODO: vrifier validit email
sub do_del {
    &wwslog('debug', 'do_del(%s)', $in{'email'});

    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_del: no list');
	return undef;
    }
    
    unless ($in{'email'}) {
	&message('no_email');
	&wwslog('info','do_del: no email');
	return undef;
    }

    $in{'email'} = &unescape_chars($in{'email'});

    unless ($param->{'user'}{'email'}) {
	&message('no_user');
	&wwslog('info','do_del: no user');
	return undef;
    }
 
    my $del_is = &List::get_action ('del', $param->{'list'}, $param->{'user'}{'email'}, 'smtp');

    if ($del_is eq 'request_auth') {
	$del_is = &List::get_action ('del', $param->{'list'}, $param->{'user'}{'email'}, 'md5');
    }

    unless ( $del_is =~ /do_it/) {
	$param->{'error'}{'action'} = 'del';
	&message('may_not');
	&wwslog('info','do_del: %s may not del', $param->{'user'}{'email'});
	return undef;
    }

    my @emails = split /\0/, $in{'email'};

    foreach my $email (@emails) {
    
	unless ( $list->is_user($email) ) {
	    &message('not_subscribed');
	    &wwslog('info','do_del: %s not subscribed', $email);
	    return undef;
	}
	
	unless( $list->delete_user($email)) {
	    $param->{'error'}{'action'} = 'del';
	    &message('failed');
	    &wwslog('info','do_del: failed for %s', $email);
	    return undef;
	}

	&wwslog('info','do_del: subscriber %s deleted from list %s', $email, $param->{'list'});
	
	$list->save();

	$list->send_file('removed', $email) unless ($in{'quiet'});	
    }

    $param->{'error'}{'action'} = 'del';
    &message('performed');
    
    return $in{'previous_action'} || 'review';
}

sub do_modindex {
    &wwslog('debug', 'do_modindex');
    my $msg;

    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_modindex: no list');
	return undef;
    }
    
    unless ($param->{'user'}{'email'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_modindex: no user');
	return undef;
    }
 
    unless ($list->am_i('editor', $param->{'user'}{'email'})) {
	$param->{'error'}{'action'} = 'modindex';
	&message('may_not');
	&wwslog('info','do_modindex: %s not editor', $param->{'user'}{'email'});
	return undef;
    }

    ## Loads message list
    unless (opendir SPOOL, $Conf{'queuemod'}) {
	&message('spool_error');
	&wwslog('info','do_modindex: unable to read spool');
	return undef;
    }
    
    foreach $msg ( sort grep(!/^\./, readdir SPOOL )) {
	next
	    unless ($msg =~ /^$list->{'name'}\_(\w+)$/);
	
	my $id = $1;

	## Load msg
	unless (open MSG, "$Conf{'queuemod'}/$msg") {
	    &message('msg_error');
	    &wwslog('info','do_modindex: unable to read msg %s', $msg);
	    return undef;
	}

	my $mail = new Mail::Internet [<MSG>];
	close MSG;

	$param->{'spool'}{$id}{'size'} = int( (-s "$Conf{'queuemod'}/$msg") / 1024 + 0.5);
	$param->{'spool'}{$id}{'subject'} =  &tools::decode_string($mail->head->get('Subject'));
	$param->{'spool'}{$id}{'date'} = $mail->head->get('Date');
	$param->{'spool'}{$id}{'from'} = &tools::decode_string($mail->head->get('From'));
	$param->{'spool'}{$id}{'from'} =~ s/</&lt;/;
	$param->{'spool'}{$id}{'from'} =~ s/>/&gt;/;
    }

    unless ($param->{'spool'}) {
	&message('no_msg');
	&wwslog('info','do_modindex: no message');
	return undef;
    }


    return 1;
}

sub do_reject {
    &wwslog('debug', 'do_reject(%s)', $in{'id'});
    my ($msg, $file);

    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_reject: no list');
	return undef;
    }
    
    unless ($param->{'user'}{'email'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_reject: no user');
	return undef;
    }
 
    unless ($list->am_i('editor', $param->{'user'}{'email'})) {
	$param->{'error'}{'action'} = 'reject';
	&message('may_not');
	&wwslog('info','do_reject: %s not editor', $param->{'user'}{'email'});
	return undef;
    }

    unless ($in{'id'}) {
	$param->{'error'}{'argument'} = 'msgid';
	&message('missing_arg');
	&wwslog('info','do_reject: no msgid');
	return undef;
    }
   
    foreach my $id (split /\0/, $in{'id'}) {

	$file = "$Conf{'queuemod'}/$list->{'name'}_$id";

	unless (unlink($file)) {
	    $param->{'error'}{'action'} = 'reject';
	    &message('failed');
	    &wwslog('info','do_reject: failed to erase %s', $file);
	    return undef;
	}
	
    }

    $param->{'error'}{'action'} = 'reject';
    &message('performed');
    
    return 'modindex';
}

## TODO: supprimer le msg
sub do_distribute {
    &wwslog('debug', 'do_distribute(%s)', $in{'id'});
    my ($msg, $file);

    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_distribute: no list');
	return undef;
    }
    
    unless ($param->{'user'}{'email'}) {
	&message('no_user');
	&wwslog('info','do_distribute: no user');
	return undef;
    }
    
    unless ($list->am_i('editor', $param->{'user'}{'email'})) {
	$param->{'error'}{'action'} = 'distribute';
	&message('may_not');
	&wwslog('info','do_distribute: %s not editor', $param->{'user'}{'email'});
	return undef;
    }

    unless ($in{'id'}) {
	$param->{'error'}{'argument'} = 'msgid';
	&message('missing_arg');
	&wwslog('info','do_distribute: no msgid');
	return undef;
    }
   
    foreach my $id (split /\0/, $in{'id'}) {
	
	$file = "$Conf{'queuemod'}/$list->{'name'}_$id";

	## Load msg
	unless (open MSG, $file) {
	    $param->{'error'}{'action'} = 'distribute';
	    &message('failed');
	    &wwslog('info','do_distribute: unable to read msg %s', $file);
	    return undef;
	}

	my $mail = new Mail::Internet [<MSG>];
	close MSG;
	
	my $size = -s "$Conf{'queuemod'}/$file";
	
	## distribute the msg
	unless ($list->distribute_msg($mail, $size)) {
	    $param->{'error'}{'action'} = 'distribute';
	    &message('failed');
	    &wwslog('info','do_distribute: failed to send %s', $file);
	    return undef;
	}
	
	unless (unlink($file)) {
	    $param->{'error'}{'action'} = 'distribute';
	    &message('failed');
	    &wwslog('info','do_distribute: failed to erase %s', $file);
	    return undef;
	}
    }
	
    $param->{'error'}{'action'} = 'distribute';
    &message('performed');
    
    return 'modindex';
}

sub do_viewmod {
    &wwslog('debug', 'do_viewmod(%s)', $in{'id'});
    my $msg;

    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_viewmod: no list');
	return undef;
    }
    
    unless ($param->{'user'}{'email'}) {
	&message('no_user');
	&wwslog('info','do_viewmod: no user');
	return undef;
    }
 
    unless ($in{'id'}) {
	$param->{'error'}{'argument'} = 'msgid';
	&message('missing_arg');
	&wwslog('info','do_viewmod: no msgid');
	return undef;
    }
   
    unless ($list->am_i('editor', $param->{'user'}{'email'})) {
	$param->{'error'}{'action'} = 'viewmod';
	&message('may_not');
	&wwslog('info','do_viewmod: %s not editor', $param->{'user'}{'email'});
	return undef;
    }

    ## Load msg
    unless (open MSG, "$Conf{'queuemod'}/$list->{'name'}_$in{'id'}") {
	$param->{'error'}{'action'} = 'viewmod';
	&message('failed');
	&wwslog('info','do_viewmod: unable to read msg %s', $msg);
	return undef;
    }

    my $mail = new Mail::Internet [<MSG>];
    close MSG;

    foreach $field ('from','date','to','subject') {
	$param->{'msg'}{$field} = &tools::decode_string($mail->head->get($field));
    }
    
    foreach $line (@{$mail->body()}) {
	$param->{'msg'}{'body'} .= $line; 
    }
    
    $param->{'id'} = $in{'id'};

    return 1;
}


## Edition of list/sympa files
## No list -> sympa files (helpfile,...)
## TODO : upload
sub do_editfile {
    &wwslog('debug', 'do_editfile(%s)', $in{'file'});
    
    $param->{'subtitle'} = sprintf $param->{'subtitle'}, $in{'file'};

    unless ($in{'file'}) {
	$param->{'error'}{'argument'} = 'file';
	&message('missing_arg');
	&wwslog('info','do_editfile: no file');
	return undef;
    }

    unless (defined $filenames{$in{'file'}}) {
	$param->{'error'}{'file'} = $in{'file'};
	&message('file_not_editable');
	&wwslog('info','do_editfile: file %s not editable', $in{'file'});
	return undef;
    }

    $param->{'file'} = $in{'file'};

    unless ($param->{'user'}{'email'}) {
	&message('no_user');
	&wwslog('info','do_editfile: no user');
	return undef;
    }

    if ($param->{'list'}) {
	unless ($list->may_edit($in{'file'}, $param->{'user'}{'email'}) eq 'write') {
	    $param->{'error'}{'action'} = 'editfile';
	    &message('may_not');
	    &wwslog('info','do_editfile: not allowed');
	    return undef;
	}

	$param->{'filepath'} = "$Conf{'home'}/$list->{'name'}/$in{'file'}";
    }else {
	unless (&List::is_listmaster($param->{'user'}{'email'})) {
	    $param->{'error'}{'argument'} = 'list';
	    &message('missing_arg');
	    &wwslog('info','do_editfile: no list');
	    return undef;
	}

	$param->{'filepath'} = "$Conf{'etc'}/templates/$in{'file'}";
    }

    if ((-e $param->{'filepath'}) and (! -r $param->{'filepath'})) {
	$param->{'error'}{'action'} = 'editfile';
	&message('failed');
	&wwslog('info','do_editfile: cannot read %s', $param->{'filepath'});
	return undef;
    }
    
    return 1;
}

## Saving of list files
sub do_savefile {
    &wwslog('debug', 'do_savefile(%s)', $in{'file'});
    
    $param->{'subtitle'} = sprintf $param->{'subtitle'}, $in{'file'};

    unless ($in{'file'}) {
	$param->{'error'}{'argument'} = 'file';
	&message('missing_arg');
	&wwslog('info','do_savefile: no file');
	return undef;
    }

    unless ($param->{'user'}{'email'}) {
	&message('no_user');
	&wwslog('info','do_savefile: no user');
	return undef;
    }

    if ($param->{'list'}) {
	unless ($list->am_i('owner', $param->{'user'}{'email'})) {
	    $param->{'error'}{'action'} = 'savefile';
	    &message('may_not');
	    &wwslog('info','do_savefile: not allowed');
	    return undef;
	}

	$param->{'filepath'} = "$Conf{'home'}/$list->{'name'}/$in{'file'}";
    }else {
	unless (&List::is_listmaster($param->{'user'}{'email'})) {
	    $param->{'error'}{'argument'} = 'list';
	    &message('missing_arg');
	    &wwslog('info','do_savefile: no list');
	    return undef;
	}

	$param->{'filepath'} = "$Conf{'etc'}/templates/$in{'file'}";
    }

    unless ((! -e $param->{'filepath'}) or (-w $param->{'filepath'})) {
	$param->{'error'}{'action'} = 'savefile';
	&message('failed');
	&wwslog('info','do_savefile: cannot write %s', $param->{'filepath'});
	return undef;
    }

    ## Keep the old file
    if (-e $param->{'filepath'}) {
	rename($param->{'filepath'}, "$param->{'filepath'}.orig");
    }

    if ($in{'content'} or ($in{'content'} =~ /^\s*$/)) {
	## Save new file
	open FILE, ">$param->{'filepath'}";
	print FILE $in{'content'};
	close FILE;
    }else {
	&wwslog('info', 'do_savefile: deleting %s', $param->{'filepath'});
	unlink $param->{'filepath'};
    }

    $param->{'error'}{'action'} = 'savefile';
    &message('performed');

    return 1;
}

## Access to web archives
sub do_arc {
    &wwslog('debug', 'do_arc(%s, %s)', $in{'month'}, $in{'arc_file'});
    my $latest;
    my $index = $wwsconf->{'archive_default_index'};

    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_arc: no list');
	return undef;
    }

    ## Access control
    my $arc_access = $list->{'admin'}{'web_archive'}{'access'};
    unless ( $list->may_do('access_web_archive', $param->{'user'}{'email'})) {
	$param->{'error'}{'action'} = 'arc';
	&message('may_not');
	&wwslog('info','do_arc: access denied for %s', $param->{'user'}{'email'});
	return undef;
    }
 
    ## Calendar
    opendir ARC, "$wwsconf->{'arc_path'}/$param->{'list'}\@$param->{'host'}";
    foreach $dir (sort grep(!/^\./,readdir ARC)) {
	if ($dir =~ /^(\d{4})-(\d{2})$/) {
	    $param->{'calendar'}{$1}{$2} = 1;
	    $latest = $dir;
	}
    }
    closedir ARC;

    ## Read html file
    $in{'month'} ||= $latest;
    
    unless ($in{'arc_file'}) {
	undef $latest;
	unless (opendir ARC, "$wwsconf->{'arc_path'}/$param->{'list'}\@$param->{'host'}/$in{'month'}") {
	    &wwslog('info',"unable to readdir $wwsconf->{'arc_path'}/$param->{'list'}\@$param->{'host'}/$in{'month'}");
	}
	foreach $file (grep(/^$index/,readdir ARC)) {
	    if ($file =~ /^$index(\d+)\.html$/) {
		$latest = $1 if ($latest < $1);
	    }
	}

	$in{'arc_file'} = $index.$latest.".html";
    }

    ## File type
    if ($in{'arc_file'} =~ /\.(\w+)$/) {
	$param->{'file_extension'} = $1;
	
	if ($param->{'file_extension'} !~ /^html$/i) {
	    $param->{'bypass'} = 1;
	}
    }

    $param->{'file'} = "$wwsconf->{'arc_path'}/$param->{'list'}\@$param->{'host'}/$in{'month'}/$in{'arc_file'}";
   
#    unless (open FILE, $file) {
#	$param->{'error'}{'action'} = 'arc';
#	&message('failed');
#	&wwslog('info','do_arc: file %s not found', $file);
#	return undef;
#    }
#    while (<FILE>) {
#	$param->{'archive'} .= $_;
#    }

#    $param->{'base'} = sprintf "%s%s/arc/%s/%s/", $param->{'base_url'}, $param->{'path_cgi'}, $param->{'list'}, $in{'month'};

    $param->{'base'} = sprintf "%s%s/arc/%s/%s/", $param->{'base_url'}, $param->{'path_cgi'}, $param->{'list'}, $in{'month'};

    $param->{'archive_name'} = $in{'month'};

#    close FILE;

    return 1;
}

## Access to web archives
sub do_remove_arc {
    &wwslog('info', 'do_remove_arc : list %s, yyyy %s, mm %s, msgid %s', $in{'list'}, $in{'yyyy'}, $in{'month'}, $in{'msgid'});

    ## Access control
    my $arc_access = $list->{'admin'}{'web_archive'}{'access'};
    unless ( $param->{'is_owner'}) {
	$param->{'error'}{'action'} = 'remove_arc';
	&message('may_not_remove_arc');
	&wwslog('info','remove_arc: access denied for %s', $param->{'user'}{'email'});
	return undef;
    }

    if ($in{'msgid'} =~ /NO-ID-FOUND\.mhonarc\.org/) {
	$param->{'error'}{'action'} = 'remove_arc';
	&message('may_not_remove_arc');
	&wwslog('info','remove_arc: no message id found');
	$param->{'status'} = 'no_msgid';
	return undef;
    } 
    ## 
    my $arcpath = "$wwsconf->{'arc_path'}/$param->{'list'}\@$param->{'host'}/$in{'yyyy'}-$in{'month'}";
    &wwslog('info','remove_arc: looking for %s in %s',$in{'msgid'},"$arcpath/arctxt");

    opendir ARC, "$arcpath/arctxt";
    my $message;
    foreach $file (grep (!/\./,readdir ARC)) {
	## &wwslog('info','remove_arc: scanning %s', $file);
	next unless (open MAIL,"$arcpath/arctxt/$file") ;
	while (<MAIL>) {
	    last if /^$/ ;
	    if ( /^Message-id:\s?<?$in{'msgid'}>?\s?/i ) {
		$message = $file ;
		last ;
	    }
	}
	close MAIL ;
	if ($message) {
	    unless (-d "$arcpath/deleted"){
		unless (mkdir ("$arcpath/deleted",0777)) {
		    &message('may_not_create_deleted_dir');
		    &wwslog('info',"remove_arc: unable to create $arcpath/deleted : $!");
		    $param->{'status'} = 'error';
		    last;
		}
	    }
	    unless (rename ("$arcpath/arctxt/$message","$arcpath/deleted/$message")) {
		&message('may_not_rename_deleted_message');
		&wwslog('info',"remove_arc: unable to rename message $arcpath/arctxt/$message");
		$param->{'status'} = 'error';
		last;
	    }
	    system "cd $arcpath ; $conf->{'mhonarc'} -rmm $in{'msgid'}";

	    &wwslog('info', 'do_remove_arc message removed %s', $message);
	    $param->{'status'} = 'done';

	    last;
	}else{
	    &wwslog('info', 'do_remove_arc : file %s do not match msgid', $file);
	}	    
    }
    unless ($message) {
	&wwslog('info', 'do_remove_arc : no file match msgid');
	$param->{'status'} = 'not_found';
    }

    closedir ARC;
    return 1;
}

## Output an initial form to search in web archives
sub do_arcsearch_form {
    &wwslog('debug', 'do_arcsearch_form(%s)', $param->{'list'});

    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
        &message('missing_arg');
        &wwslog('info','do_arcsearch_form: no list');
        return undef;
    }

    ## Access control
    my $arcsearch_form_access = $list->{'admin'}{'web_archive'}{'access'};
    unless ($list->may_do('access_web_archive', $param->{'user'}{'email'})) {
	$param->{'error'}{'action'} = 'arcsearch_form';
        &message('may_not');
        &wwslog('info','do_arcsearch_form: access denied for %s', $param->{'user'}{'email'});
        return undef;
    }

    my $search_base = "$wwsconf->{'arc_path'}/$param->{'list'}\@$param->{'host'}";
    opendir ARC, "$search_base";
    foreach my $dir (sort {$b cmp $a} grep(!/^\./,readdir ARC)) {
        if ($dir =~ /^(\d{4})-(\d{2})$/) {
            push @{$param->{'yyyymm'}}, $dir;
        }
    }
    closedir ARC;

    $param->{'key_word'} = $in{'key_word'};
    $param->{'archive_name'} = $in{'archive_name'};
    
    return 1;
}

## Search in web archives
sub do_arcsearch {
    &wwslog('debug', 'do_arcsearch(%s)', $param->{'list'});

    unless ($param->{'list'}) {
        $param->{'error'}{'argument'} = 'list';
	&message('missing_argument');
        &wwslog('info','do_arcsearch: no list');
        return undef;
    }

    ## Access control
    my $arcsearch_access = $list->{'admin'}{'web_archive'}{'access'};
    unless ( $list->may_do('access_web_archive', $param->{'user'}{'email'})) {
        $param->{'error'}{'action'} = 'arcsearch';
	&message('may_not');
        &wwslog('info','do_arcsearch: access denied for %s', $param->{'user'}{'email'});
        return undef;
    }

    use Marc::Search;

    my $search = new Marc::Search;
    $search->search_base ($wwsconf->{'arc_path'} . '/' . $param->{'list'} . '@' . $param->{'host'});
    $search->base_href ($Conf{'wwsympa_url'} . '/arc/' . $param->{'list'});
    
    $search->archive_name ($in{'archive_name'});
    
    if (defined($in{'directories'})) {
	$search->directories ($in{'directories'});
	foreach my $dir (split/\0/, $in{'directories'})	{
	    push @{$param->{'directories'}}, $dir;
	}
    }else {
	$search->directories ($search->archive_name);
	push @{$param->{'directories'}}, $search->archive_name;
    }
    
    if (defined $in{'previous'}) {
	$search->body_count ($in{'body_count'});
	$search->date_count ($in{'date_count'});
	$search->from_count ($in{'from_count'});
	$search->subj_count ($in{'subj_count'});
	$search->previous ($in{'previous'});
    }
    
    ## User didn't enter any search terms
    if ($in{'key_word'} =~ /^\s*$/) {
        $param->{'error'}{'argument'} = 'key_word';
	&message('missing_argument');
        &wwslog('info','do_arcsearch: no search term');
	return undef;
    }
    
    $param->{'key_word'} = $in{'key_word'};
    $in{'key_word'} =~ s/\@/\\\@/g;
    
    $search->limit ($in{'limit'});
    
    $search->age (1) 
	if (($in{'age'} eq 'new') or ($in{'age'} eq '1'));
    
    $search->match (1) 
	if (($in{'match'} eq 'partial') or ($in{'match'} eq '1'));
    
    my @words = split(/\s+/,$in{'key_word'});
    $search->words (\@words);
    $search->clean_words ($in{'key_word'});
    my @clean_words = @words;

    for my $i (0 .. $#words) {
        $words[$i] =~ s,/,\\/,g;
        $words[$i] = '\b' . $words[$i] . '\b' if ($in{'match'} eq 'exact');
    }
    $search->key_word (join('|',@words));
    
    if ($in{'case'} eq 'off') {
        $search->case(1);
        $search->key_word ('(?i)' . $search->key_word);
    }
    if ($in{'how'} eq 'any') {
        $search->function2 ($search->match_any(@words));
        $search->how ('any');
    }elsif ($in{'how'} eq 'all') {
        $search->function1 ($search->body_match_all(@clean_words,@words));
        $search->function2 ($search->match_all(@words));
        $search->how       ('all');
    }else {
        $search->function2 ($search->match_this(@words));
        $search->how       ('phrase');
    }

    $search->subj (defined($in{'subj'}));
    $search->from (defined($in{'from'}));
    $search->date (defined($in{'date'}));
    $search->body (defined($in{'body'}));
    
    $search->body (1) 
	if ( not ($search->subj)
	     and not ($search->from)
	     and not ($search->body)
	     and not ($search->date));

    my $searched = $search->search;
    
    if (defined($search->error)) {
	&wwslog('info','do_arcsearch_search_error : %s', $search->error);
    }
    
    $search->searched($searched);

    if ($searched < $search->file_count) {
	$param->{'continue'} = 1;
    }

    foreach my $field ('list','archive_name','age','body','case','date','from','how','limit','match','subj') {
	$param->{$field} = $in{$field};
    }

    $param->{'body_count'} = $search->body_count;
    $param->{'clean_words'} = $search->clean_words;
    $param->{'date_count'} = $search->date_count;
    $param->{'from_count'} = $search->from_count;
    $param->{'subj_count'} = $search->subj_count;
    
    $param->{'num'} = $search->file_count + 1;
    $param->{'searched'} = $search->searched;
    
    $param->{'res'} = $search->res;
    
    return 1;
}

sub do_edit_list{
    &wwslog('debug', 'do_edit_list(%s)', $in{'list'});

    unless ($param->{'user'}{'email'}) {
	&message('no_user');
	&wwslog('info','do_create_list_request:  no user');
	return undef;
    }

    my $lang = $param->{'lang'};

    if ( $in{'list'}) {
	$param->{'edit_action'} = &list::get_action('edit_list', $param->{'user'}{'email'}, 'md5');
    }else {
	$param->{'edit_action'} = &List::get_action('create_list',$param->{'user'}{'email'}, 'md5');
    }	    
    &wwslog('info',"do_edit_list, get action : $param->{'edit_action'} ");

    if ($param->{'edit_action'} =~ /reject/) {
	$param->{'error'}{'action'} = 'edit_list';
	&message('may_not');
	&wwslog('info','do_edit_list: not allowed');
	return undef;
    }

    foreach my $parameter (@list_parameters){
	if ( $in{'list'}) {
	    $param->{"edit_$parameter"} = $list->may_edit($parameter, $param->{'user'}{'email'});
	}else{
	    $param->{"edit_$parameter"} = &List::may_create_parameter($parameter, $param->{'user'}{'email'});
	}
    }

    ## Initial values
    if ( $in{'list'}) {
	$param->{'list'} = $in{'list'};

        ## Simple parameters 
        foreach my $parameter ('visibility','subject','max_size', 'custom_header',
			       'anonynous_sender', 'custom_subject','footer_type',
			       'host','user_data_source','welcome_return_path',
			       'reminder_return_path','priority','owner','editor',
			       'topics','account') {
	    $param->{"init_$parameter"} =  $list->{'admin'}{$parameter};
	}

	## Add a new custom header
	push @{$param->{'init_custom_header'}}, '';
  
        ## Special parameters
        $param->{'init_archive_period'} = $list->{'admin'}{'archive'}{'period'};
        $param->{'init_archive_access'} = $list->{'admin'}{'archive'}{'access'};
        $param->{'init_web_archive_access'} = $list->{'admin'}{'web_archive'}{'access'};
        $param->{'init_default_user_options_reception'} = $list->{'admin'}{'default_user_options'}{'reception'};
        $param->{'init_default_user_options_visibility'} = $list->{'admin'}{'default_user_options'}{'visibility'};

	$param->{'init_creation_date'} = $list->{'admin'}{'creation'}{'date'};
	$param->{'init_creation_by'} = $list->{'admin'}{'creation'}{'by'};

	$param->{'init_update_date'} = $list->{'admin'}{'update'}{'date'};
	$param->{'init_update_by'} = $list->{'admin'}{'update'}{'by'};
	$param->{'init_update_serial'} = $list->{'admin'}{'update'}{'serial'};

        if ($list->{'admin'}{'reply_to'} =~ /^(sender|list)$/ ) {
            $param->{'init_reply_to'} = $1;
	}else{
	    $param->{'init_reply_to_email'} = $1 ;
	}

	## Params with predefined values
	## Web Archive Access
	foreach my $access (@web_archive_access) {
	    $param->{'web_archive_access'}{$access} = 1 
		unless ($access eq $param->{'init_web_archive_access'});
	}

	## Archive Period
	foreach my $period (@archive_period) {
	    $param->{'archive_period'}{$period} = 1 
		unless ($period eq $param->{'init_archive_period'});
	}

	## Archive Access
	foreach my $access (@archive_access) {
	    $param->{'archive_access'}{$access} = 1 
		unless ($access eq $param->{'init_archive_access'});
	}

	## User data sources
	foreach my $source (@data_sources) {
	    $param->{'data_sources'}{$source} = 1
		unless ($source eq $param->{'init_user_data_source'});
	}

	## User options
	foreach my $visibility (@visibilities) {
	    $param->{'user_visibilities'}{$visibility} = 1 
		unless ($visibility eq $param->{'init_default_user_options_visibility'});
	}
	foreach my $reception (@receptions) {
	    $param->{'user_receptions'}{$reception} = 1 
		unless ($reception eq $param->{'init_default_user_options_reception'});
	}

	## Digest
	$param->{'digest_hour'} = $list->{'admin'}{'digest'}{'hour'};
	$param->{'digest_minute'} = $list->{'admin'}{'digest'}{'minute'};
	for my $i (0..6) {
	    $param->{'digest_days'}[$i]->{'name'} = $week{$lang}[$i];
	    foreach my $day (@{$list->{'admin'}{'digest'}{'days'}}){
		if ($day == $i) {
		    $param->{'digest_days'}[$i]->{'selected'} = 1;
		}
	    }
	}

        ## Scenarized parameters
        foreach my $parameter  ('visibility','send','subscribe','unsubscribe','review','remind','add','del') {
	    $param->{"init_$parameter"} = $list->{'admin'}{$parameter}{'name'} ;
	    $param->{"inittitle_$parameter"} = $list->{'admin'}{$parameter}{'title'}{$lang} ;
        }
        
        ## Owners
        foreach my $owner ( @{$param->{'init_owner'}}) {
            ## you may modify a owner email if
            ##    you are listmaster
            ##    the owner you edit is NOT privileged and you are priviliged
            ##    the owner you edit is NOT privileged and you are the owner you want to edit
	    $owner->{'edit_email'} = ($param->{'is_listmaster'} ||
				      (($owner{'profile'} ne 'privileged') &&
				       (($list->am_i('privileged_owner',$param->{'user'}{'email'})) || 
					($owner->{'email'} eq $param->{'user'}{'email'} )))) ;
	    $owner->{'edit_profile'} = $param->{'is_listmaster'};
	    
	    $owner->{'edit_gecos'} = $param->{'is_listmaster'} || 
		( $list->am_i('privileged_owner',$param->{'user'}{'email'})) ||
		    ($param->{'user'}{'email'} eq $owner{'email'});
	    $owner->{'edit_info'} = $param->{'is_listmaster'} || 
		($list->am_i('privileged_owner',$param->{'user'}{'email'})) ||
		    ($param->{'user'}{'email'} eq $owner{'email'});
	    
	}
        my $owner ;
        $owner->{'edit_email'} =  $param->{'is_listmaster'} || $list->am_i('privileged_owner',$param->{'user'}{'email'}) ;
        $owner->{'edit_gecos'} =  $owner->{'edit_reception'} = $owner->{'edit_info'} = $owner->{'edit_email'};
        $owner->{'profile'} = 'normal';
        push @{$param->{'init_owner'}}, $owner ;

	## Editors
        my $editor;
        $editor->{'init_email'} = '';
        push @{$param->{'init_editor'}}, $editor ;
    }else{
	$param->{'init_owner'}[0]{'email'} = $param->{'user'}{'email'};
	$param->{'init_editor'}[0]{'email'} = $param->{'user'}{'email'};
	$param->{'init_owner'}[0]{'edit_email'} = 1;
	$param->{'init_owner'}[0]{'gecos'} = $param->{'user'}{'gecos'};
	$param->{'init_owner'}[0]{'edit_gecos'} = 1;
	$param->{'init_owner'}[0]{'reception'} = 'mail';
	$param->{'init_owner'}[0]{'edit_reception'} = 1;
	$param->{'init_owner'}[0]{'profile'} = 'privileged';
	$param->{'init_owner'}[0]{'edit_profile'} = $param->{'is_listmaster'};
	$param->{'init_owner'}[0]{'edit_info'} = 1;
    }

    ## Parameters with defaults set in sympa.conf
    $param->{'default_max_size'} ||= $Conf{'max_size'};
    $param->{'default_host'} ||= $Conf{'host'};
    $param->{'default_priority'} ||= $Conf{'default_list_priority'};
 

    ## List available scenarii
    unless (opendir SCENARI, "--SYMPADIR--/scenari"){
	&wwslog('info',"do_edit_list: unable to open --SYMPADIR--/scenari");
	$param->{'error'}{'action'} = 'edit_list';
	&message('failed');
	return undef;
    }

    foreach $scfile (readdir SCENARI) {
	if ($scfile =~ /^(\w+)\.(\w+)/ ) {
            my $parameter = $1;
	    my $sc = $1."_scenari" ;
            my $value = $2;
            my $scenari = &List::_load_scenario_file ($parameter,$value);

	    if (($value eq 'default') && (!$in{'list'})) {
		$param->{"init_$parameter"} = 'default';
		$param->{"inittitle_$parameter"} = $scenari->{'title'}{$lang};
	    }
            unless ( $param->{"init_$parameter"} eq $value){
		$param->{$sc}{$value}{$value} = 1 ;
		$param->{$sc}{$value}{'title'} = $scenari->{'title'}{$lang};
	    }
	}
    }
    closedir SCENARI;
    return 1;
}

sub do_submit_list {
    &wwslog('debug', 'submit_list');

    unless ($param->{'user'}{'email'}) {
	&message('no_user');
	&wwslog('info','do_submit_list:  no user');
	return undef;
    }

    unless ( $Conf{'create_list'})  {
	$param->{'error'}{'action'} = 'submit_list';
	&message('may_not');
	&wwslog('notice','do_create_list_post: unable to load creli parameter');
        return undef;
    }

    my $lang = $param->{'lang'};

    ## Initialization 
    #################
    &do_edit_list();

    ## Create new list config structure 
    ###################################
    my $admin = {};

    ## Check if parameters have been changed
    ########################################
    ## Digest
    if ($param->{'edit_digest'}) {
	foreach my $day (split "\0", $in{'digest_days'}) {
	    push @{$admin->{'digest'}{'days'}}, $day;
	} 
	$admin->{'digest'}{'hour'} = $in{'digest_hour'};
	$admin->{'digest'}{'minute'} = $in{'digest_minute'};
    }else {
	$admin->{'digest'} = $list->{'admin'}{'digest'};
    }

    ## Archives and Web_archives
    foreach my $parameter ('archive','web_archive') {
	if ($param->{"edit_$parameter"}) {
	    foreach my $key (keys %in) {
		if ($key =~ /^$parameter\_(\w+)$/) {
		    $admin->{$parameter}{$1} = $in{$key};
		}
	    }
	}else {
	    $admin->{$parameter} = $list->{'admin'}{$parameter};
	}
    }

    ## User default options
    if ($param->{'edit_default_user_options'}) {
	foreach my $key (@user_options) {
	    if ($in{"default_user_options_$key"}) {
		$admin->{'default_user_options'}{$key} = $in{"default_user_options_$key"};
	    }
	}
    }else {
	$admin->{'default_user_options'} = $list->{'admin'}{'default_user_options'};
    }

    ## Arrays
    foreach my $parameter ('edit_custom_header','topics') {
	if ($param->{$parameter}) {
	    foreach my $key (keys %in) {
		next unless ($key =~ /^$parameter/ and $in{$key}); 
		
		push @{$admin->{$parameter}}, $in{$key};
	    }
	}else {
	    $admin->{$parameter} = $list->{'admin'}{$parameter};
	}
    }

    ## Reply-to
    if ($param->{'edit_reply_to'}) {
	$admin->{'reply_to'} = $in{'reply_to_email'} || $in{'reply_to'};
    }else {
	$admin->{'reply_to'} = $list->{'admin'}{'reply_to'};
    }

    ## Owners and Editors
    foreach my $role ('owner','editor') {
	foreach my $k (keys %in) {
	    next unless $k =~ /^$role(\d+)_(\w+)$/;

	    my ($i, $attr) = ($1, $2);
	    
	    if ($in{$k} ne $param->{"init_$k"}
		&& (! $param->{"edit_$role"})) {
		&wwslog('notice', "Not allowed to change $role parameter");
	    }
	}
    }

    if ( $param->{'list'}) {
	$admin->{'listname'} = $param->{'list'};
    }elsif ( $in{'listname'} =~ /^([a-zA-Z0-9_\-]+)$/ ) {
	$admin->{'listname'} = lc($in->{'listname'});
    }else{
	$param->{'error'}{'listname'} = $in{'listname'};
	&message('incorrect_listname');
    }

    ## Simple parameters
    foreach my $parameter ('subject','max_size','custom_subject','account','anonymous_sender',
			   'welcome_return_path','remind_return_path','footer_type','host',
                           'user_data_source','priority') {
	if ($param->{"edit_$parameter"}) {
	    $admin->{$parameter} = $in{$parameter};
	}else{
	    $admin->{$parameter} = $list->{'admin'}{$parameter};
	}
    }

    ## Scenarii
    foreach my $parameter ('visibility','send','subscribe','unsubscribe','review','remind',
			   'add','del') {
	if ($param->{"edit_$parameter"}) {
	    $admin->{$parameter} = &List::_load_scenario_file ($parameter, $in{$parameter});
	}else{
	    $admin->{$parameter} = &List::_load_scenario_file ($parameter, $param->{"init_$parameter"});
	}
    }

    ## Owners and Editors
    foreach my $role ('owner','editor') {
	my @array;
	foreach my $k (keys %in) {
	    next unless $k =~ /^$role(\d+)_(\w+)$/;
	    
	    $array[$1]{$2} = $in{$k} if $in{$k};
	}
	foreach my $entry (@array) {
	    push @{$admin->{$role}}, $entry
		if $entry->{'email'};
	}
    }
	    
    ## Save config to file
    ######################
    &List::_save_admin_file('/tmp/config', $admin);
   
    return 1;
}

## WWSympa Home-Page
sub do_home {
    &wwslog('debug', 'do_home');

    return 1;
}

sub do_editsubscriber {
    &wwslog('debug', 'do_editsubscriber(%s)', $in{'email'});

    my $user;

    unless ($param->{'is_owner'}) {
	$param->{'error'}{'action'} = 'editsubscriber';
	&message('may_not');
	&wwslog('info','do_editsubscriber: may not edit');
	return undef;
    }

    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_editsubscriber: no list');
	return undef;
    }

    unless ($in{'email'}) {
	&message('no_email');
	&wwslog('info','do_editsubscriber: no email');
	return undef;
    }

    $in{'email'} = &unescape_chars($in{'email'});

    unless($user = $list->get_subscriber($in{'email'})) {
	$param->{'error'}{'email'} = $in{'email'};
	&message('subscriber_not_found');
	&wwslog('info','do_editsubscriber: subscriber %s not found', $in{'email'});
	return undef;
    }

    $param->{'subscriber'} = $user;
    $param->{'subscriber'}{'escaped_email'} = &escape_chars($param->{'subscriber'}{'email'});
    $param->{'subscriber'}{'date'} = &POSIX::strftime("%d %b %Y", localtime($user->{'date'}));

    ## Prefs
    $param->{'subscriber'}{'reception'} ||= 'mail';
    $param->{'subscriber'}{'visibility'} ||= 'noconceal';
    foreach my $m (keys %reception_mode) {		
	$param->{'reception'}{$m}{'description'} = $reception_mode{$m};
	if ($param->{'subscriber'}{'reception'} eq $m) {
	    $param->{'reception'}{$m}{'selected'} = 'SELECTED';
	}else {
	    $param->{'reception'}{$m}{'selected'} = '';
	}
    }

    ## Bounces
    if ($user->{'bounce'} =~ /^(\d+)\s+(\d+)\s+(\d+)(\s+(.*))?$/) {
	my @bounce = ($1, $2, $3, $5);
    	$param->{'subscriber'}{'first_bounce'} = &POSIX::strftime("%d %b %Y", localtime($bounce[0]));
    	$param->{'subscriber'}{'last_bounce'} = &POSIX::strftime("%d %b %Y", localtime($bounce[1]));
    	$param->{'subscriber'}{'bounce_count'} = $bounce[2];
	if ($bounce[3] =~ /^(\d+\.(\d+\.\d+))$/) {
	   $user->{'bounce_code'} = $1;
	   $user->{'bounce_status'} = $bounce_status{$2};
 	}	

	$param->{'previous_action'} = $in{'previous_action'};
    }

    return 1;
}

sub do_viewbounce {
    &wwslog('debug', 'do_viewbounce(%s)', $in{'email'});

    unless ($param->{'is_owner'}) {
	$param->{'error'}{'action'} = 'viewbounce';
	&message('may_not');
	&wwslog('info','do_viewbounce: may not view');
	return undef;
    }

    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_viewbounce: no list');
	return undef;
    }

    unless ($in{'email'}) {
	&message('no_email');
	&wwslog('info','do_viewbounce: no email');
	return undef;
    }

    my $escaped_email = &escape_chars($in{'email'});

    $param->{'lastbounce_path'} = "$wwsconf->{'bounce_path'}/$param->{'list'}/$escaped_email";

    unless (-r $param->{'lastbounce_path'}) {
	$param->{'error'}{'email'} = $in{'email'};
	&message('no_bounce');
	&wwslog('info','do_viewbounce: no bounce %s', $param->{'lastbounce_path'});
	return undef;
    }

    return 1;
}

## some help for listmaster and developpers
sub do_scenario_test {
    &wwslog('debug', 'do_scenario_test');

    ## List available scenarii
    unless (opendir SCENARI, "--SYMPADIR--/scenari/"){
	&wwslog('info',"do_scenario_test : unable to open --SYMPADIR--/scenari");
	&message('scenari_wrong_access');
	return undef;
    }

    foreach $scfile (readdir SCENARI) {
	if ($scfile =~ /^(\w+)\.(\w+)/ ) {
	    $param->{'scenario'}{$1}{'defined'}=1 ;
	}
    }
    closedir SCENARI;
    foreach $l ( &List::get_lists() ) {
	$param->{'listname'}{$l}{'defined'}=1 ;
    }
    foreach $a ('smtp','md5','s/mime') {
	$param->{'auth_method'}{$a}{'define'}=1 ;
    }

    $param->{'scenario'}{$in{'scenario'}}{'selected'} = 'SELECTED' if $in{'scenario'};

    $param->{'listname'}{$in{'listname'}}{'selected'} = 'SELECTED' if $in{'listname'};
    
    $param->{'authmethod'}{$in{'auth_method'}}{'selected'} = 'SELECTED' if $in{'auth_method'};

    $param->{'email'} = $in{'email'};

    if ($in{'scenario'}) {
        my $operation = $in{'scenario'};
	&wwslog('debug', 'do_scenario_test: perform scenario_test');
	if ($operation =~ /^(subscribe|remind|review|del|info|visibility)/) {
	    ($param->{'scenario_condition'},$param->{'scenario_auth_method'},$param->{'scenario_action'}) = &List::get_action ($operation, $in{'listname'},$in{'email'},$in{'auth_method'});
	}elsif ($operation =~ /^(unsubscribe|add|set)/) {
	    ($param->{'scenario_condition'},$param->{'scenario_auth_method'},$param->{'scenario_action'}) = &List::get_action ($operation,$in{'listname'},$in{'email'},$in{'email'},$in{'auth_method'});
	}elsif ($operation =~ /^send/) {
	    ($param->{'scenario_condition'},$param->{'scenario_auth_method'},$param->{'scenario_action'}) = "unable to test send scenario, I need a message"; 
	}elsif($operation =~ /^edit_list|create_list/) {
	    ($param->{'scenario_condition'},$param->{'scenario_auth_method'},$param->{'scenario_action'}) = &List::get_action ($operation,$in{'email'},$in{'auth_method'});
	}elsif($operation =~ /^global_remind/) {
	    ($param->{'scenario_condition'},$param->{'scenario_auth_method'},$param->{'scenario_action'}) = &List::get_action ($operation,$in{'auth_method'});
	}
    }
    return 1;
}

## Bouncing addresses review
sub do_reviewbouncing {
    &wwslog('debug', 'do_reviewbouncing(%d)', $in{'page'});
    my $record;
    my @users;
    my $size = $in{'size'} || $wwsconf->{'review_page_size'};

    unless ($in{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_reviewbouncing: no list');
	return undef;
    }

    unless ($param->{'is_owner'}) {
	$param->{'error'}{'action'} = 'reviewbouncing';
	&message('may_not');
	&wwslog('info','do_reviewbouncing: may not review');
	return undef;
    }

    unless ($param->{'total'} = $list->get_total_bouncing()) {
	&message('no_subscriber');
	&wwslog('info','do_reviewbouncing: no subscriber');
	return undef;
    }

    ## Owner
    $param->{'page'} = $in{'page'} || 1;
    $param->{'total_page'} = int ($param->{'total'} / $size);
    $param->{'total_page'} ++
	if ($param->{'total'} % $size);

    if ($param->{'page'} > $param->{'total_page'}) {
	$param->{'error'}{'page'} = $param->{'page'};
	&message('no_page');
	&wwslog('info','do_reviewbouncing: no page %d', $param->{'page'});
	return undef;
    }

    ## Members list
    for ($i = $list->get_first_bouncing_user(); $i; $i = $list->get_next_bouncing_user()) {
	$record++;
	
	if ($record > ( $size * ($param->{'page'} ) ) ) {
	    $param->{'next_page'} = $param->{'page'} + 1;
	    last;
	}
	
	next if ($record <= ( ($param->{'page'} - 1) *  $size));
	
	$i->{'bounce'} =~ /^(\d+)\s+(\d+)\s+(\d+)(\s+(.*))?$/;
    	my @bounce = ($1, $2, $3, $5);
    	$i->{'first_bounce'} = &POSIX::strftime("%d %b %Y", localtime($bounce[0]));
    	$i->{'last_bounce'} = &POSIX::strftime("%d %b %Y", localtime($bounce[1]));
    	$i->{'bounce_count'} = $bounce[2];
	if ($bounce[3] =~ /^(\d+)\.\d+\.\d+$/) {
	    $i->{'bounce_class'} = $1;
 	}		

	## Escape some weird chars
	$i->{'escaped_email'} = &escape_chars($i->{'email'});
	
	push @{$param->{'members'}}, $i;
    }
    
    if ($param->{'page'} > 1) {
	$param->{'prev_page'} = $param->{'page'} - 1;
    }

    $param->{'size'} = $in{'size'};
    
    return 1;
}

sub do_resetbounce {
    &wwslog('debug', 'do_resetbounce(%s)', $in{'email'});

    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_resetbounce: no list');
	return undef;
    }
    
    unless ($in{'email'}) {
	&message('no_email');
	&wwslog('info','do_resetbounce: no email');
	return undef;
    }

    $in{'email'} = &unescape_chars($in{'email'});

    unless ($param->{'user'}{'email'}) {
	&message('no_user');
	&wwslog('info','do_resetbounce: no user');
	return undef;
    }
 
    ## Require DEL privilege
    my $del_is = &List::get_action ('del', $param->{'list'}, $param->{'user'}{'email'}, 'smtp');
    
    if ($del_is eq 'request_auth') {
	$del_is = &List::get_action ('del', $param->{'list'}, $param->{'user'}{'email'}, 'md5');
    }
    
    unless ( $del_is =~ /do_it/) {
	$param->{'error'}{'action'} = 'del';
	&message('may_not');
	&wwslog('info','do_resetbounce: %s may not reset', $param->{'user'}{'email'});
	return undef;
    }

    my @emails = split /\0/, $in{'email'};

    foreach my $email (@emails) {
    
	unless ( $list->is_user($email) ) {
	    $param->{'error'}{'email'} = $email;
	    &message('not_subscribed');
	    &wwslog('info','do_del: %s not subscribed', $email);
	    return undef;
	}
	
	unless( $list->update_user($email, {'bounce' => 'NULL'})) {
	    $param->{'error'}{'action'} = 'del';
	    &message('failed');
	    &wwslog('info','do_resetbounce: failed update database for %s', $email);
	    return undef;
	}

	unless (unlink "$wwsconf->{'arc_path'}/$param->{'list'}/$email") {
	    &wwslog('info','do_resetbounce: failed deleting %s', "$wwsconf->{'arc_path'}/$param->{'list'}/$email");
	}
	
	&wwslog('info','do_resetbounce: bounces for %s reset ', $email);
	
    }

    return $in{'previous_action'} || 'review';
}

## Rebuild an archive using arctxt/
sub do_rebuildarc {
    &wwslog('debug', 'do_rebuildarc(%s, %s)', $param->{'list'}, $in{'month'});

    unless ($param->{'list'}) {
	$param->{'error'}{'argument'} = 'list';
	&message('missing_arg');
	&wwslog('info','do_rebuildarc: no list');
	return undef;
    }
    
    unless ($param->{'user'}{'email'}) {
	&message('no_user');
	&wwslog('info','do_rebuildarc: no user');
	return undef;
    }

    unless ($param->{'is_listmaster'}) {
	$param->{'error'}{'action'} = 'rebuildarc';
	&message('may_not');
	&wwslog('info','do_rebuildarc: not listmaster');
	return undef;
    }
  
    my $file = "$Conf{'queueoutgoing'}/.rebuild.$list->{'name'}\@$list->{'admin'}{'host'}";

    unless (open REBUILD, ">$file") {
	$param->{'error'}{'action'} = 'rebuildarc';
	&message('failed');
	&wwslog('info','do_rebuildarc: cannot create %s', $file);
	return undef;
    }
 
    &do_log('info', 'File: %s', $file);
    
    print REBUILD ' ';
    close REBUILD;

    $param->{'error'}{'action'} = 'rebuildarc';
    &message('performed');

    return 'admin';
}

## When we catch SIGHUP, just change the value of optd
sub sighup {
    do_log('notice', 'signal HUP received, change log level');
    if ($main::opt_D) {
       undef $main::opt_D;
       undef $main::opt_d;
       do_log('notice', 'removing debug mode');
    }elsif($main::opt_d) {
       $main::opt_D = 1;
       do_log('notice', 'setting hard debug mode (-dD)');
    }else{
       $main::opt_d= 1;
       do_log('notice', 'setting simple debug mode (-d)');
    }
    $end = 1;
}









