;;;
;;;  cmail-archive.el - utility functions for archiving
;;; 
;;;  $Author: iwa $
;;;  created at: Fri May 27 13:33:49 JST 1994
;;;
;;;  Copyright (C) 1992-1996 Yukihiro Matsumoto.

;; cmail-archive.el
;; mail $B$rAw?.$9$k;~$K!"(Bcmail-archive-folder $B$G;XDj$5$l$?(B folder $B$K(B
;; cmail $B7A<0$G<+F0E*$K5-O?$,;D$j$^$9!#(B

;; Change Log:
;; 1994$BG/(B5$B7n(B27$BF|(B nao
;;     quick hack $B$r$b$H$K!"%U%!%$%k$r9=C[!#(B
;; 1994$BG/(B5$B7n(B28$BF|(B nao
;;     cmail-archive-from $B$rDI2C!#(B
;;     robust $B$K$9$k$?$a$N:Y$+$$=$@5!#(B
;; 1994$BG/(B6$B7n(B1$BF|(B nao
;;     bug fix--date command!
;; 1994$BG/(B6$B7n(B1$BF|(B nagano@rd.yahata.enicom.nsc.co.jp
;;     sendmail.el $B$N%$%s%W%j%a%s%H$K0MB8$7$F$$$?ItJ,$r=$@5!#(B
;;     cmail $B$X$NAH$_9~$_(B 
;;     ( $B0J8e!"(Bcmail $B$N(B ChangeLog $B$X(B )

;; This file is not part of GNU Emacs but obeys its copyright notice.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU Emacs, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.

; cmail-vars.el
;(defvar cmail-use-send-mail-archive nil 
;  "$BAw?.$7$?%a%$%k$N%m%0$r;XDj$7$?%U%)%k%@$K;D$9$+$I$&$+(B.")

(defvar cmail-archive-folder "archive"
  "*$BAw?.$7$?%a%$%k$rJ]B8$9$k$?$a$N%U%)%k%@L>$^$?$O!"%U%)%k%@L>$rJV$94X?t!#(B")

(defvar cmail-archive-from nil
  "*$BJ]B8$5$l$k(B From: $B9T$NFbMF!#(Bnil $B$N>l9g$K$O!"(B(user-login-name) $B$r;H$&!#(B")

;;; Code:
(provide 'cmail-archive)

(defun cmail-archive ()
  (let (day month date time timezone year folder limit
	    (buffer (current-buffer)))
    (goto-char (point-min))
    (set-buffer (get-buffer-create *cmail-arrived-mail-buffer))
    (widen)
    (erase-buffer)
    (cmail-set-buffer-multibyte t)
    (insert (current-time-string))
    (goto-char (point-min))
    (re-search-forward 
     "\\(\\w+\\) \\(\\w+\\) +\\(\\w+\\) \\([^ ]+\\) \\(\\w+\\)")
    (setq day (buffer-substring (match-beginning 1) (match-end 1)))
    (setq month (buffer-substring (match-beginning 2) (match-end 2)))
    (setq date (buffer-substring (match-beginning 3) (match-end 3)))
    (setq time (buffer-substring (match-beginning 4) (match-end 4)))
    (setq year (buffer-substring (match-beginning 5) (match-end 5)))
    (if (fboundp 'current-time-zone)
	(setq timezone (nth 1 (current-time-zone)))
      (setq timezone "GMT"))
    (erase-buffer)
    (insert-buffer buffer)
    (goto-char (point-min))
    (re-search-forward (concat "^" mail-header-separator "$") nil nil)
    (replace-match "")
    (setq limit (point-marker))
    (goto-char (point-min))
    (if (null (re-search-forward "^From: " limit t))
	(let (from)
	  (if (functionp cmail-archive-from)
	      (save-restriction
		(narrow-to-region (point-min) limit)
		(goto-char (point-min))
		(setq from (funcall cmail-archive-from)))
	    (setq from cmail-archive-from))
	  (if (null from) (setq from (user-login-name)))
	  (beginning-of-line)
	  (insert "From: " from "\n")))
    (goto-char (point-min))
    (if (null (re-search-forward "^Date: " limit t))
	(insert 
	 (format "Date: %s, %s %s %s %s %s\n" 
		 day date month 
		 (if (> (length year) 2) (substring year -2) year )
		 time timezone)))
    (goto-char (point-min))
    (insert "From " (user-login-name)
	    (format " %s %s %s %s %s\n" day month date time year))
    (insert-string "X-cmail-status: Active\n")
    (setq folder
	  (cond ((functionp cmail-archive-folder)
		 (save-restriction
		   (narrow-to-region (point-min) limit)
		   (goto-char (point-min))
		   (funcall cmail-archive-folder)))
		(t cmail-archive-folder)))
    (cond ((stringp folder)
	   (encode-coding-region (point-min) (point-max)
				 *cmail-primary-coding-system)
	   (goto-char (point-max))
	   (insert "\n" *cmail-borderline)
	   (cmail-append-mail-to-folder (current-buffer) folder)
	   (cmail-save-folder folder)
	   (if (string= folder cmail-current-folder)
	       (cmail-make-summary folder))))
    (set-marker limit nil)
    (set-buffer buffer))
  )

;;; cmail-archive.el ends here
