#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>

#include <Y2/Y.h>
#include <Y2/Ylib.h>

#include "../include/string.h"


#ifndef DEF_CON_ARG
# define DEF_CON_ARG	"127.0.0.1:9433"
#endif


/*
 *	Print help.
 */
void PrintUsage()
{
	printf("\
Usage: yshutdown [options]\n\
\n\
    [options] can be any of the following:\n\
\n\
        --recorder <address:port>    Specify which YIFF server to connect to.\n\
\n"
	);


	return;
}


int main(int argc, char *argv[])
{
	int i;

	char *con_arg = NULL;

	YConnection *con = NULL;



	/* Parse arguments. */
	for(i = 1; i < argc; i++)
	{
	    if(argv[i] == NULL)
		continue;

	    /* Help. */
	    if(strcasepfx(argv[i], "--h") ||
               strcasepfx(argv[i], "-h") ||
               !strcmp(argv[i], "?")
	    )
	    {
		PrintUsage();
		return(0);
	    }



	    /* Connect address. */
	    else if(strcasepfx(argv[i], "--rec") ||
                    strcasepfx(argv[i], "-rec")
	    )
	    {
		i++;
		if(i < argc)
		{
		    free(con_arg);
		    con_arg = StringCopyAlloc(argv[i]);
		}
		else
		{
		    fprintf(stderr,
			"%s: Requires argument.\n",
			argv[i - 1]
		    );
		}
	    }
	}


	/*
	 *	Connect to YIFF server.
	 */
	con = YOpenConnection(
	    NULL,		/* No start argument. */
	    con_arg
	);
	if(con == NULL)
	{
	    printf("%s: Cannot connect to YIFF server.\n",
		(con_arg == NULL) ? DEF_CON_ARG : con_arg
	    );

            free(con_arg);
            con_arg = NULL;

	    return(-1);
	}


	/*
	 *	Shut down the server.
	 */
	YShutdownServer(con);


	free(con_arg);
	con_arg = NULL;


	return(0);
}
