/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 

#ifndef VDKCSORTLIST_H
#define VDKCSORTLIST_H
#include <vdk/vdkclist.h>

class VDKCustomSortedList: public VDKCustomList
{
 protected:
 int keypos;
 char *oldkey;
 public:
 // properties
 bool Unique;

 VDKCustomSortedList(VDKForm* owner,
		     int keyPos,
		     int columns = 1,
		     char **titles = NULL,
		     GtkSelectionMode mode = GTK_SELECTION_SINGLE);
 ~VDKCustomSortedList() {}
 
 bool AddKey(char **s, char** pixdata = NULL, int col = 0);
 void UpdateKey(char* key, char** s, 
		char** pixdata = NULL, int col = 0);
 void UpdateCellKey(char* key, int col, 
		    char* s, char** pixdata = NULL);
 void RemoveKey(char* key);
 int FindKey(char* key);
 int KeyPos() { return keypos; }
};
#endif
