#!/usr/bin/perl
#
# Extract the public function definitions from the SDL header files

sub get_public_functions {
	my($file) = shift;

	if ( !defined(open(HDR, $file)) ) {
		warn("Can't read from $file: $!\n");
		return;
	}
	$export = "";
	while ( ($export ne "") || ($line=<HDR>) ) {
		$export = "";
		if ( $line =~ /^SDL_DEFUN(.*)/ ) {
			$export = $1;
			$looking = 1;
			while ( $looking ) {
				$line = scalar(<HDR>);
				if ( $line =~ /^\s\s+([^\s].*)/ ) {
					$export .= " $1";
				} else {
					$looking = 0;
				}
			}
			print "SDL_DECLARE${export}\n";
		}
	}
	close(HDR);
}

foreach $file (@ARGV) {
	get_public_functions $file;
}
