/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997, 1998, 1999  Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    slouken@devolution.com
*/

#ifdef SAVE_RCSID
static char rcsid =
 "@(#) $Id: SDL_fbvideo.h,v 1.2 1999/11/24 02:57:12 hercules Exp $";
#endif

#ifndef _SDL_fbvideo_h
#define _SDL_fbvideo_h

#include <linux/fb.h>

#include "SDL_mouse.h"
#include "SDL_sysvideo.h"

/* Hidden "this" pointer for the video functions */
#define _THIS	SDL_VideoDevice *this

/* Private display data */
struct SDL_PrivateVideoData {
    int console_fd;
    __u16 console_pal[3*256];
    SDL_Rect video_mode;
    SDL_Rect **SDL_modelist[4];
};
/* Old variable names */
#define console_fd		(this->hidden->console_fd)
#define console_pal		(this->hidden->console_pal)
#define video_mode		(this->hidden->video_mode)
#define SDL_modelist		(this->hidden->SDL_modelist)

#endif /* _SDL_fbvideo_h */
