/********************************************************************************
*                                                                               *
*                                   Image Test                                  *
*                                                                               *
********************************************************************************/
#include "fx.h"


FXuchar grey_ramp[512*50*3];                 // Created images
FXuchar red_ramp[512*50*3];
FXuchar green_ramp[512*50*3];
FXuchar blue_ramp[512*50*3];


// Event Handler Object
class ImageWindow : public FXMainWindow {

  // Macro for class hierarchy declarations
  FXDECLARE(ImageWindow)

private:

  FXCanvas        *canvas;                    // Canvas to draw into
  FXColorWell     *backwell;                  // Color Well for background
  FXColorWell     *borderwell;                // Color Well for border
  FXColorWell     *textwell;                  // Color Well for text
  FXImage         *grey;
  FXImage         *red;
  FXImage         *green;
  FXImage         *blue;
  FXFont          *font;                      // Font for text
  
protected:
  ImageWindow(){}

public:

  // Message handlers
  long onCanvasRepaint(FXObject*,FXSelector,void*);
  long onCmdWell(FXObject*,FXSelector,void*);

public:
  
  // Messages for our class
  enum{
    ID_CANVAS=FXMainWindow::ID_LAST,
    ID_WELL,
    ID_LAST
    };
  
public:

  // ScribbleApp constructor
  ImageWindow(FXApp* a);
  
  // Initialize
  virtual void create();
  };



// Message Map for the Scribble App class
FXDEFMAP(ImageWindow) ImageWindowMap[]={

  //____Message_Type______________ID_______________Message_Handler___
  FXMAPFUNC(SEL_PAINT,   ImageWindow::ID_CANVAS,  ImageWindow::onCanvasRepaint),
  FXMAPFUNC(SEL_COMMAND, ImageWindow::ID_WELL,    ImageWindow::onCmdWell),
  
  };



// Macro for the ScribbleApp class hierarchy implementation
FXIMPLEMENT(ImageWindow,FXMainWindow,ImageWindowMap,ARRAYNUMBER(ImageWindowMap))



// Construct a ScribbleApp
ImageWindow::ImageWindow(FXApp* a):FXMainWindow(a,"Image Application",NULL,NULL,DECOR_ALL,0,0,800,600){
  FXint x,y;
  FXVerticalFrame *canvasFrame;
  FXVerticalFrame *buttonFrame;
  FXHorizontalFrame *contents;

  FXColorDialog *colordlg=new FXColorDialog(this,"Color Dialog");
    
  contents=new FXHorizontalFrame(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);
  
  // LEFT pane to contain the canvas
  canvasFrame=new FXVerticalFrame(contents,FRAME_SUNKEN|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_TOP|LAYOUT_LEFT,0,0,0,0,10,10,10,10);
  
    // Label above the canvas               
    new FXLabel(canvasFrame,"Canvas Frame",NULL,JUSTIFY_CENTER_X|LAYOUT_FILL_X);
  
    // Horizontal divider line
    new FXHorizontalSeparator(canvasFrame,SEPARATOR_GROOVE|LAYOUT_FILL_X);

    // Drawing canvas
    canvas=new FXCanvas(canvasFrame,this,ID_CANVAS,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_TOP|LAYOUT_LEFT);


  // RIGHT pane for the buttons
  buttonFrame=new FXVerticalFrame(contents,FRAME_SUNKEN|LAYOUT_FILL_Y|LAYOUT_TOP|LAYOUT_LEFT,0,0,0,0,10,10,10,10);

    // Label above the buttons  
    new FXLabel(buttonFrame,"Button Frame",NULL,JUSTIFY_CENTER_X|LAYOUT_FILL_X);
    
    // Horizontal divider line
    new FXHorizontalSeparator(buttonFrame,SEPARATOR_RIDGE|LAYOUT_FILL_X);

    new FXLabel(buttonFrame,"&Background\nColor well",NULL,JUSTIFY_CENTER_X|LAYOUT_FILL_X);
    backwell=new FXColorWell(buttonFrame,FXRGB(255,255,255),this,ID_WELL,LAYOUT_CENTER_X|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,100,30);
    
    new FXLabel(buttonFrame,"B&order\nColor well",NULL,JUSTIFY_CENTER_X|LAYOUT_FILL_X);
    borderwell=new FXColorWell(buttonFrame,FXRGB(0,0,0),this,ID_WELL,LAYOUT_CENTER_X|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,100,30);
    
    new FXLabel(buttonFrame,"&Text\nColor well",NULL,JUSTIFY_CENTER_X|LAYOUT_FILL_X);
    textwell=new FXColorWell(buttonFrame,FXRGB(0,0,0),this,ID_WELL,LAYOUT_CENTER_X|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,100,30);
    
    // Button to draw
    new FXButton(buttonFrame,"&Colors...\tPop the color dialog",NULL,colordlg,FXWindow::ID_SHOW,FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_TOP|LAYOUT_LEFT,0,0,0,0,10,10,5,5);

    // Exit button
    new FXButton(buttonFrame,"E&xit\tQuit ImageApp",NULL,getApp(),FXApp::ID_QUIT,FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_TOP|LAYOUT_LEFT,0,0,0,0,10,10,5,5);

    
  // Create images
  grey=new FXImage(getApp(),grey_ramp,IMAGE_DITHER|IMAGE_SHMI|IMAGE_SHMP,512,50);
  red=new FXImage(getApp(),red_ramp,IMAGE_DITHER|IMAGE_SHMI|IMAGE_SHMP,512,50);
  green=new FXImage(getApp(),green_ramp,IMAGE_DITHER|IMAGE_SHMI|IMAGE_SHMP,512,50);
  blue=new FXImage(getApp(),blue_ramp,IMAGE_DITHER|IMAGE_SHMI|IMAGE_SHMP,512,50);
  
  
  // Fill the ramps
  for(x=0; x<512; x++){
    for(y=0; y<50; y++){
      grey_ramp[3*(y*512+x)]=x/2;
      grey_ramp[3*(y*512+x)+1]=x/2;
      grey_ramp[3*(y*512+x)+2]=x/2;
      }
    for(y=0; y<50; y++){
      red_ramp[3*(y*512+x)]=x/2;
      red_ramp[3*(y*512+x)+1]=0;
      red_ramp[3*(y*512+x)+2]=0;
      }
    for(y=0; y<50; y++){
      green_ramp[3*(y*512+x)]=0;
      green_ramp[3*(y*512+x)+1]=x/2;
      green_ramp[3*(y*512+x)+2]=0;
      }
    for(y=0; y<50; y++){
      blue_ramp[3*(y*512+x)]=0;
      blue_ramp[3*(y*512+x)+1]=0;
      blue_ramp[3*(y*512+x)+2]=x/2;
      }
    }
  
  // Make font
  font=new FXFont(getApp(),"times",36,FONTWEIGHT_BOLD);
  
  // Make a tip
  new FXTooltip(getApp());
  }
    
 

// Create and initialize 
void ImageWindow::create(){

  // Create the windows
  FXMainWindow::create();
  
  // Create images
  grey->create();
  red->create();
  green->create();
  blue->create();
  
  // Font too
  font->create();
  
  // Make it appear
  show();
  }


// Handle the clear message
long ImageWindow::onCanvasRepaint(FXObject*,FXSelector,void* ptr){
  FXDCWindow dc(canvas,(FXEvent*)ptr);
  FXuint pat;
  
  // Erase the canvas, color comes from well
  dc.setForeground(backwell->getRGBA());
  
  dc.fillRectangle(0,0,canvas->getWidth(),canvas->getHeight());
  
  // Draw images
  dc.drawImage(grey,10,50);
  dc.drawImage(red,10,150);
  dc.drawImage(green,10,250);
  dc.drawImage(blue,10,350);
  
  // Draw patterns
  dc.setFillStyle(FILL_OPAQUESTIPPLED);
  dc.setForeground(FXRGB(0,0,0));
  dc.setBackground(FXRGB(255,255,255));
  for(pat=STIPPLE_0; pat<=STIPPLE_16; pat+=1){
    dc.setStipple((FXStipplePattern)pat);
    dc.fillRectangle(10+(512*pat)/17,450,31,50);
    }
  dc.setFillStyle(FILL_SOLID);
  
  // Draw borders
  dc.setForeground(borderwell->getRGBA());
  dc.drawRectangle(10,50,512,50);
  dc.drawRectangle(10,150,512,50);
  dc.drawRectangle(10,250,512,50);
  dc.drawRectangle(10,350,512,50);
  dc.drawRectangle(10,450,512,50);

  // Draw text
  dc.setTextFont(font);
  dc.setForeground(textwell->getRGBA());
  dc.drawText(540,90,"Grey",4);
  dc.drawText(540,190,"Red",3);
  dc.drawText(540,290,"Green",5);
  dc.drawText(540,390,"Blue",4);
  dc.drawText(540,490,"Patterns",8);
  
    
  return 1;
  }


// Color well got changed
long ImageWindow::onCmdWell(FXObject*,FXSelector,void*){
  canvas->update(0,0,canvas->getWidth(),canvas->getHeight());
  return 1;
  }


// Here we begin
int main(int argc,char *argv[]){

  // Make application
  FXApp* application=new FXApp();
  
  // Start app
  application->init(argc,argv);
  
  // Make window
  new ImageWindow(application);
  
  // Create the application's windows
  application->create();
  
  // Run the application
  application->run();
  
  return 0;
  }




